/*
 * Decompiled with CFR 0.152.
 */
package play;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import play.Mode;
import play.libs.Scala;
import scala.compat.java8.OptionConverters;

@Singleton
public class Environment {
    private final play.api.Environment env;

    @Inject
    public Environment(play.api.Environment environment) {
        this.env = environment;
    }

    public Environment(File file, ClassLoader classLoader, Mode mode) {
        this(new play.api.Environment(file, classLoader, mode.asScala()));
    }

    public Environment(File file, Mode mode) {
        this(file, Environment.class.getClassLoader(), mode);
    }

    public Environment(File file) {
        this(file, Environment.class.getClassLoader(), Mode.TEST);
    }

    public Environment(Mode mode) {
        this(new File("."), Environment.class.getClassLoader(), mode);
    }

    public File rootPath() {
        return this.env.rootPath();
    }

    public ClassLoader classLoader() {
        return this.env.classLoader();
    }

    public Mode mode() {
        return this.env.mode().asJava();
    }

    public boolean isDev() {
        return this.mode().equals((Object)Mode.DEV);
    }

    public boolean isProd() {
        return this.mode().equals((Object)Mode.PROD);
    }

    public boolean isTest() {
        return this.mode().equals((Object)Mode.TEST);
    }

    public File getFile(String string) {
        return this.env.getFile(string);
    }

    public Optional<File> getExistingFile(String string) {
        return OptionConverters.toJava(this.env.getExistingFile(string));
    }

    public URL resource(String string) {
        return Scala.orNull(this.env.resource(string));
    }

    public InputStream resourceAsStream(String string) {
        return Scala.orNull(this.env.resourceAsStream(string));
    }

    public static Environment simple() {
        return new Environment(new File("."), Environment.class.getClassLoader(), Mode.TEST);
    }

    public play.api.Environment asScala() {
        return this.env;
    }
}

