/*
 * Decompiled with CFR 0.152.
 */
package play.api.data.format;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.TimeZone;
import java.util.UUID;
import play.api.data.FormError;
import play.api.data.FormError$;
import play.api.data.format.Formats$;
import play.api.data.format.Formatter;
import play.api.data.format.PlayDate$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.BigDecimal;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Right;
import scala.util.control.Exception$;

public final class Formats$ {
    public static final Formats$ MODULE$ = new Formats$();
    private static final Formatter<BigDecimal> bigDecimalFormat = MODULE$.bigDecimalFormat((Option<Tuple2<Object, Object>>)None$.MODULE$);
    private static final Formatter<java.util.Date> dateFormat = MODULE$.dateFormat("yyyy-MM-dd", MODULE$.dateFormat$default$2());
    private static final Formatter<Date> sqlDateFormat = MODULE$.sqlDateFormat("yyyy-MM-dd");
    private static final Formatter<Timestamp> sqlTimestampFormat = MODULE$.sqlTimestampFormat("yyyy-MM-dd HH:mm:ss", MODULE$.sqlTimestampFormat$default$2());
    private static final Formatter<LocalDate> localDateFormat = MODULE$.localDateFormat("yyyy-MM-dd");
    private static final Formatter<LocalDateTime> localDateTimeFormat = MODULE$.localDateTimeFormat("yyyy-MM-dd HH:mm:ss", MODULE$.localDateTimeFormat$default$2());
    private static final Formatter<LocalTime> localTimeFormat = MODULE$.localTimeFormat("HH:mm:ss");

    public <A> Formatter<A> ignoredFormat(A value) {
        return new Formatter<A>(value){
            private Option<Tuple2<String, Seq<Object>>> format;
            private final Object value$1;

            public Option<Tuple2<String, Seq<Object>>> format() {
                return this.format;
            }

            public void play$api$data$format$Formatter$_setter_$format_$eq(Option<Tuple2<String, Seq<Object>>> x$1) {
                this.format = x$1;
            }

            public Right<Nothing$, A> bind(String key, Map<String, String> data) {
                return package$.MODULE$.Right().apply(this.value$1);
            }

            public Map<String, Nothing$> unbind(String key, A value) {
                return Predef$.MODULE$.Map().empty();
            }
            {
                this.value$1 = value$1;
                Formatter.$init$(this);
                Statics.releaseFence();
            }
        };
    }

    public Formatter<String> stringFormat() {
        return new Formatter<String>(){
            private Option<Tuple2<String, Seq<Object>>> format;

            public Option<Tuple2<String, Seq<Object>>> format() {
                return this.format;
            }

            public void play$api$data$format$Formatter$_setter_$format_$eq(Option<Tuple2<String, Seq<Object>>> x$1) {
                this.format = x$1;
            }

            public Either<Seq<FormError>, String> bind(String key, Map<String, String> data) {
                return data.get((Object)key).toRight((Function0 & Serializable)() -> new .colon.colon((Object)FormError$.MODULE$.apply(key, "error.required", (Seq<Object>)Nil$.MODULE$), (List)Nil$.MODULE$));
            }

            public Map<String, String> unbind(String key, String value) {
                return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value)}));
            }
            {
                Formatter.$init$(this);
                Statics.releaseFence();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$bind$1(java.lang.String )}, serializedLambda);
            }
        };
    }

    public Formatter<Object> charFormat() {
        return new Formatter<Object>(){
            private Option<Tuple2<String, Seq<Object>>> format;

            public Option<Tuple2<String, Seq<Object>>> format() {
                return this.format;
            }

            public void play$api$data$format$Formatter$_setter_$format_$eq(Option<Tuple2<String, Seq<Object>>> x$1) {
                this.format = x$1;
            }

            public Either<Seq<FormError>, Object> bind(String key, Map<String, String> data) {
                return (Either)data.get((Object)key).filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)anon.3.$anonfun$bind$2(s))).map((Function1 & Serializable)s -> package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToCharacter((char)s.charAt(0)))).getOrElse((Function0 & Serializable)() -> package$.MODULE$.Left().apply((Object)new .colon.colon((Object)FormError$.MODULE$.apply(key, "error.required", (Seq<Object>)Nil$.MODULE$), (List)Nil$.MODULE$)));
            }

            public Map<String, String> unbind(String key, char value) {
                return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)Character.toString(value))}));
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public static final /* synthetic */ boolean $anonfun$bind$2(String s) {
                if (s.length() != 1) return false;
                String string = s;
                String string2 = " ";
                if (string == null) {
                    if (string2 == null) return false;
                    return true;
                } else if (string.equals(string2)) return false;
                return true;
            }
            {
                Formatter.$init$(this);
                Statics.releaseFence();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$bind$2$adapted(java.lang.String ), $anonfun$bind$3(java.lang.String ), $anonfun$bind$4(java.lang.String )}, serializedLambda);
            }
        };
    }

    public <T> Either<Seq<FormError>, T> parsing(Function1<String, T> parse, String errMsg, Seq<Object> errArgs, String key, Map<String, String> data) {
        return this.stringFormat().bind(key, data).right().flatMap((Function1 & Serializable)s -> Exception$.MODULE$.allCatch().either((Function0 & Serializable)() -> parse.apply(s)).left().map((Function1 & Serializable)e -> new .colon.colon((Object)FormError$.MODULE$.apply(key, errMsg, errArgs), (List)Nil$.MODULE$)));
    }

    private <T> Formatter<T> numberFormatter(Function1<String, T> convert, boolean real) {
        Tuple2 tuple2;
        Tuple2 tuple22 = tuple2 = real ? new Tuple2((Object)"format.real", (Object)"error.real") : new Tuple2((Object)"format.numeric", (Object)"error.number");
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String formatString = (String)tuple2._1();
        String errorString = (String)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)formatString, (Object)errorString);
        String formatString2 = (String)tuple23._1();
        String errorString2 = (String)tuple23._2();
        return new Formatter<T>(formatString2, convert, errorString2){
            private final Some<Tuple2<String, Nil$>> format;
            private final Function1 convert$1;
            private final String errorString$1;

            public void play$api$data$format$Formatter$_setter_$format_$eq(Option<Tuple2<String, Seq<Object>>> x$1) {
            }

            public Some<Tuple2<String, Nil$>> format() {
                return this.format;
            }

            public Either<Seq<FormError>, T> bind(String key, Map<String, String> data) {
                return Formats$.MODULE$.parsing(this.convert$1, this.errorString$1, (Seq<Object>)Nil$.MODULE$, key, data);
            }

            public Map<String, String> unbind(String key, T value) {
                return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value.toString())}));
            }
            {
                this.convert$1 = convert$1;
                this.errorString$1 = errorString$1;
                Formatter.$init$(this);
                this.format = new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)formatString$1), (Object)Nil$.MODULE$));
            }
        };
    }

    private <T> boolean numberFormatter$default$2() {
        return false;
    }

    public Formatter<Object> longFormat() {
        return this.numberFormatter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$2))), this.numberFormatter$default$2());
    }

    public Formatter<Object> intFormat() {
        return this.numberFormatter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$3))), this.numberFormatter$default$2());
    }

    public Formatter<Object> shortFormat() {
        return this.numberFormatter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToShort((short)StringOps$.MODULE$.toShort$extension(Predef$.MODULE$.augmentString(x$4))), this.numberFormatter$default$2());
    }

    public Formatter<Object> byteFormat() {
        return this.numberFormatter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToByte((byte)StringOps$.MODULE$.toByte$extension(Predef$.MODULE$.augmentString(x$5))), this.numberFormatter$default$2());
    }

    public Formatter<Object> floatFormat() {
        return this.numberFormatter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToFloat((float)StringOps$.MODULE$.toFloat$extension(Predef$.MODULE$.augmentString(x$6))), true);
    }

    public Formatter<Object> doubleFormat() {
        return this.numberFormatter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToDouble((double)StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(x$7))), true);
    }

    public Formatter<BigDecimal> bigDecimalFormat(Option<Tuple2<Object, Object>> precision) {
        return new Formatter<BigDecimal>(precision){
            private final Some<Tuple2<String, Nil$>> format;
            private final Option precision$1;

            public void play$api$data$format$Formatter$_setter_$format_$eq(Option<Tuple2<String, Seq<Object>>> x$1) {
            }

            public Some<Tuple2<String, Nil$>> format() {
                return this.format;
            }

            public Either<Seq<FormError>, BigDecimal> bind(String key, Map<String, String> data) {
                return Formats$.MODULE$.stringFormat().bind(key, data).right().flatMap((Function1 & Serializable)s -> Exception$.MODULE$.allCatch().either((Function0 & Serializable)() -> {
                    BigDecimal bd = package$.MODULE$.BigDecimal().apply(s);
                    return (BigDecimal)$this.precision$1.map((Function1 & Serializable)x0$1 -> {
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 != null) {
                            int p = tuple2._1$mcI$sp();
                            int s = tuple2._2$mcI$sp();
                            if (bd.precision() - bd.scale() > p - s) {
                                throw new ArithmeticException("Invalid precision");
                            }
                            return bd.setScale(s);
                        }
                        throw new MatchError((Object)tuple2);
                    }).getOrElse((Function0 & Serializable)() -> bd);
                }).left().map((Function1 & Serializable)e -> {
                    FormError formError;
                    Some some;
                    Tuple2 tuple2;
                    Option option = $this.precision$1;
                    if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                        int p = tuple2._1$mcI$sp();
                        int s = tuple2._2$mcI$sp();
                        formError = FormError$.MODULE$.apply(key, "error.real.precision", (Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{p, s}))));
                    } else if (None$.MODULE$.equals(option)) {
                        formError = FormError$.MODULE$.apply(key, "error.real", (Seq<Object>)Nil$.MODULE$);
                    } else {
                        throw new MatchError((Object)option);
                    }
                    return new .colon.colon((Object)formError, (List)Nil$.MODULE$);
                }));
            }

            public Map<String, String> unbind(String key, BigDecimal value) {
                return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)((BigDecimal)this.precision$1.map((Function1 & Serializable)p -> value.setScale(p._2$mcI$sp())).getOrElse((Function0 & Serializable)() -> value)).toString())}));
            }
            {
                this.precision$1 = precision$1;
                Formatter.$init$(this);
                this.format = new Some((Object)new Tuple2((Object)"format.real", (Object)Nil$.MODULE$));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$bind$5(play.api.data.format.Formats$$anon$5 java.lang.String java.lang.String ), $anonfun$bind$6(play.api.data.format.Formats$$anon$5 java.lang.String ), $anonfun$bind$7(scala.math.BigDecimal scala.Tuple2 ), $anonfun$bind$8(scala.math.BigDecimal ), $anonfun$bind$9(play.api.data.format.Formats$$anon$5 java.lang.String java.lang.Throwable ), $anonfun$unbind$1(scala.math.BigDecimal scala.Tuple2 ), $anonfun$unbind$2(scala.math.BigDecimal )}, serializedLambda);
            }
        };
    }

    public Formatter<BigDecimal> bigDecimalFormat() {
        return bigDecimalFormat;
    }

    public Formatter<Object> booleanFormat() {
        return new Formatter<Object>(){
            private final Some<Tuple2<String, Nil$>> format;

            public void play$api$data$format$Formatter$_setter_$format_$eq(Option<Tuple2<String, Seq<Object>>> x$1) {
            }

            public Some<Tuple2<String, Nil$>> format() {
                return this.format;
            }

            public Either<Seq<FormError>, Object> bind(String key, Map<String, String> data) {
                return package$.MODULE$.Right().apply(data.getOrElse((Object)key, (Function0 & Serializable)() -> "false")).right().flatMap((Function1 & Serializable)x0$1 -> {
                    String string = x0$1;
                    switch (string == null ? 0 : string.hashCode()) {
                        case 3569038: {
                            if (!"true".equals(string)) break;
                            return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((boolean)true));
                        }
                        case 97196323: {
                            if (!"false".equals(string)) break;
                            return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((boolean)false));
                        }
                    }
                    return package$.MODULE$.Left().apply((Object)new .colon.colon((Object)FormError$.MODULE$.apply(key, "error.boolean", (Seq<Object>)Nil$.MODULE$), (List)Nil$.MODULE$));
                });
            }

            public Map<String, String> unbind(String key, boolean value) {
                return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)Boolean.toString(value))}));
            }
            {
                Formatter.$init$(this);
                this.format = new Some((Object)new Tuple2((Object)"format.boolean", (Object)Nil$.MODULE$));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$bind$10(), $anonfun$bind$11(java.lang.String java.lang.String )}, serializedLambda);
            }
        };
    }

    public Formatter<java.util.Date> dateFormat(String pattern, TimeZone timeZone) {
        return new Formatter<java.util.Date>(timeZone, pattern){
            private final ZoneId javaTimeZone;
            private final DateTimeFormatter formatter;
            private final Some<Tuple2<String, Seq<String>>> format;

            public void play$api$data$format$Formatter$_setter_$format_$eq(Option<Tuple2<String, Seq<Object>>> x$1) {
            }

            private ZoneId javaTimeZone() {
                return this.javaTimeZone;
            }

            private DateTimeFormatter formatter() {
                return this.formatter;
            }

            private java.util.Date dateParse(String data) {
                ZonedDateTime instant = PlayDate$.MODULE$.parse(data, this.formatter()).toZonedDateTime(ZoneOffset.UTC);
                return java.util.Date.from(instant.withZoneSameLocal(this.javaTimeZone()).toInstant());
            }

            public Some<Tuple2<String, Seq<String>>> format() {
                return this.format;
            }

            public Either<Seq<FormError>, java.util.Date> bind(String key, Map<String, String> data2) {
                return Formats$.MODULE$.parsing((Function1 & Serializable)data -> this.dateParse((String)data), "error.date", (Seq<Object>)Nil$.MODULE$, key, data2);
            }

            public Map<String, String> unbind(String key, java.util.Date value) {
                return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)this.formatter().format(value.toInstant().atZone(this.javaTimeZone())))}));
            }
            {
                Formatter.$init$(this);
                this.javaTimeZone = timeZone$1.toZoneId();
                this.formatter = DateTimeFormatter.ofPattern(pattern$1);
                this.format = new Some((Object)new Tuple2((Object)"format.date", (Object)new .colon.colon((Object)pattern$1, (List)Nil$.MODULE$)));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$bind$12(play.api.data.format.Formats$$anon$7 java.lang.String )}, serializedLambda);
            }
        };
    }

    public TimeZone dateFormat$default$2() {
        return TimeZone.getDefault();
    }

    public Formatter<java.util.Date> dateFormat() {
        return dateFormat;
    }

    public Formatter<Date> sqlDateFormat(String pattern) {
        return new Formatter<Date>(pattern){
            private final Formatter<LocalDate> dateFormatter;
            private final Some<Tuple2<String, Seq<String>>> format;

            public void play$api$data$format$Formatter$_setter_$format_$eq(Option<Tuple2<String, Seq<Object>>> x$1) {
            }

            private Formatter<LocalDate> dateFormatter() {
                return this.dateFormatter;
            }

            public Some<Tuple2<String, Seq<String>>> format() {
                return this.format;
            }

            public Either<Seq<FormError>, Date> bind(String key, Map<String, String> data) {
                return this.dateFormatter().bind(key, data).right().map((Function1 & Serializable)d -> Date.valueOf(d));
            }

            public Map<String, String> unbind(String key, Date value) {
                return this.dateFormatter().unbind(key, value.toLocalDate());
            }
            {
                Formatter.$init$(this);
                this.dateFormatter = Formats$.MODULE$.localDateFormat(pattern$2);
                this.format = new Some((Object)new Tuple2((Object)"format.date", (Object)new .colon.colon((Object)pattern$2, (List)Nil$.MODULE$)));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$bind$13(java.time.LocalDate )}, serializedLambda);
            }
        };
    }

    public Formatter<Date> sqlDateFormat() {
        return sqlDateFormat;
    }

    public Formatter<Timestamp> sqlTimestampFormat(String pattern, TimeZone timeZone) {
        return new Formatter<Timestamp>(pattern, timeZone){
            private final DateTimeFormatter formatter;
            private final Some<Tuple2<String, Seq<String>>> format;

            public void play$api$data$format$Formatter$_setter_$format_$eq(Option<Tuple2<String, Seq<Object>>> x$1) {
            }

            private DateTimeFormatter formatter() {
                return this.formatter;
            }

            private Timestamp timestampParse(String data) {
                return Timestamp.valueOf(LocalDateTime.parse(data, this.formatter()));
            }

            public Some<Tuple2<String, Seq<String>>> format() {
                return this.format;
            }

            public Either<Seq<FormError>, Timestamp> bind(String key, Map<String, String> data2) {
                return Formats$.MODULE$.parsing((Function1 & Serializable)data -> this.timestampParse((String)data), "error.timestamp", (Seq<Object>)Nil$.MODULE$, key, data2);
            }

            public Map<String, String> unbind(String key, Timestamp value) {
                return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value.toLocalDateTime().format(this.formatter()))}));
            }
            {
                Formatter.$init$(this);
                this.formatter = DateTimeFormatter.ofPattern(pattern$3).withZone(timeZone$2.toZoneId());
                this.format = new Some((Object)new Tuple2((Object)"format.timestamp", (Object)new .colon.colon((Object)pattern$3, (List)Nil$.MODULE$)));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$bind$14(play.api.data.format.Formats$$anon$9 java.lang.String )}, serializedLambda);
            }
        };
    }

    public TimeZone sqlTimestampFormat$default$2() {
        return TimeZone.getDefault();
    }

    public Formatter<Timestamp> sqlTimestampFormat() {
        return sqlTimestampFormat;
    }

    public Formatter<LocalDate> localDateFormat(String pattern) {
        return new Formatter<LocalDate>(pattern){
            private final DateTimeFormatter formatter;
            private final Some<Tuple2<String, Seq<String>>> format;

            public void play$api$data$format$Formatter$_setter_$format_$eq(Option<Tuple2<String, Seq<Object>>> x$1) {
            }

            private DateTimeFormatter formatter() {
                return this.formatter;
            }

            private LocalDate localDateParse(String data) {
                return LocalDate.parse(data, this.formatter());
            }

            public Some<Tuple2<String, Seq<String>>> format() {
                return this.format;
            }

            public Either<Seq<FormError>, LocalDate> bind(String key, Map<String, String> data2) {
                return Formats$.MODULE$.parsing((Function1 & Serializable)data -> this.localDateParse((String)data), "error.date", (Seq<Object>)Nil$.MODULE$, key, data2);
            }

            public Map<String, String> unbind(String key, LocalDate value) {
                return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value.format(this.formatter()))}));
            }
            {
                Formatter.$init$(this);
                this.formatter = DateTimeFormatter.ofPattern(pattern$4);
                this.format = new Some((Object)new Tuple2((Object)"format.date", (Object)new .colon.colon((Object)pattern$4, (List)Nil$.MODULE$)));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$bind$15(play.api.data.format.Formats$$anon$10 java.lang.String )}, serializedLambda);
            }
        };
    }

    public Formatter<LocalDate> localDateFormat() {
        return localDateFormat;
    }

    public Formatter<LocalDateTime> localDateTimeFormat(String pattern, ZoneId zoneId) {
        return new Formatter<LocalDateTime>(pattern, zoneId){
            private final DateTimeFormatter formatter;
            private final Some<Tuple2<String, Seq<String>>> format;

            public void play$api$data$format$Formatter$_setter_$format_$eq(Option<Tuple2<String, Seq<Object>>> x$1) {
            }

            private DateTimeFormatter formatter() {
                return this.formatter;
            }

            private LocalDateTime localDateTimeParse(String data) {
                return LocalDateTime.parse(data, this.formatter());
            }

            public Some<Tuple2<String, Seq<String>>> format() {
                return this.format;
            }

            public Either<Seq<FormError>, LocalDateTime> bind(String key, Map<String, String> data2) {
                return Formats$.MODULE$.parsing((Function1 & Serializable)data -> this.localDateTimeParse((String)data), "error.localDateTime", (Seq<Object>)Nil$.MODULE$, key, data2);
            }

            public Map<String, String> unbind(String key, LocalDateTime value) {
                return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value.format(this.formatter()))}));
            }
            {
                Formatter.$init$(this);
                this.formatter = DateTimeFormatter.ofPattern(pattern$5).withZone(zoneId$1);
                this.format = new Some((Object)new Tuple2((Object)"format.localDateTime", (Object)new .colon.colon((Object)pattern$5, (List)Nil$.MODULE$)));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$bind$16(play.api.data.format.Formats$$anon$11 java.lang.String )}, serializedLambda);
            }
        };
    }

    public ZoneId localDateTimeFormat$default$2() {
        return ZoneId.systemDefault();
    }

    public Formatter<LocalDateTime> localDateTimeFormat() {
        return localDateTimeFormat;
    }

    public Formatter<LocalTime> localTimeFormat(String pattern) {
        return new Formatter<LocalTime>(pattern){
            private final DateTimeFormatter formatter;
            private final Some<Tuple2<String, Seq<String>>> format;

            public void play$api$data$format$Formatter$_setter_$format_$eq(Option<Tuple2<String, Seq<Object>>> x$1) {
            }

            private DateTimeFormatter formatter() {
                return this.formatter;
            }

            private LocalTime localTimeParse(String data) {
                return LocalTime.parse(data, this.formatter());
            }

            public Some<Tuple2<String, Seq<String>>> format() {
                return this.format;
            }

            public Either<Seq<FormError>, LocalTime> bind(String key, Map<String, String> data2) {
                return Formats$.MODULE$.parsing((Function1 & Serializable)data -> this.localTimeParse((String)data), "error.localTime", (Seq<Object>)Nil$.MODULE$, key, data2);
            }

            public Map<String, String> unbind(String key, LocalTime value) {
                return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value.format(this.formatter()))}));
            }
            {
                Formatter.$init$(this);
                this.formatter = DateTimeFormatter.ofPattern(pattern$6);
                this.format = new Some((Object)new Tuple2((Object)"format.localTime", (Object)new .colon.colon((Object)pattern$6, (List)Nil$.MODULE$)));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$bind$17(play.api.data.format.Formats$$anon$12 java.lang.String )}, serializedLambda);
            }
        };
    }

    public Formatter<LocalTime> localTimeFormat() {
        return localTimeFormat;
    }

    public Formatter<UUID> uuidFormat() {
        return new Formatter<UUID>(){
            private final Some<Tuple2<String, Nil$>> format;

            public void play$api$data$format$Formatter$_setter_$format_$eq(Option<Tuple2<String, Seq<Object>>> x$1) {
            }

            public Some<Tuple2<String, Nil$>> format() {
                return this.format;
            }

            public Either<Seq<FormError>, UUID> bind(String key, Map<String, String> data) {
                return Formats$.MODULE$.parsing((Function1 & Serializable)x$1 -> UUID.fromString(x$1), "error.uuid", (Seq<Object>)Nil$.MODULE$, key, data);
            }

            public Map<String, String> unbind(String key, UUID value) {
                return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value.toString())}));
            }
            {
                Formatter.$init$(this);
                this.format = new Some((Object)new Tuple2((Object)"format.uuid", (Object)Nil$.MODULE$));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$bind$18(java.lang.String )}, serializedLambda);
            }
        };
    }

    private Formats$() {
    }
}

