/*
 * Decompiled with CFR 0.152.
 */
package play.api.http;

import com.typesafe.config.ConfigException;
import java.io.Serializable;
import javax.inject.Inject;
import javax.inject.Singleton;
import play.api.ConfigLoader$;
import play.api.Configuration;
import play.api.Environment;
import play.api.Logger;
import play.api.Logger$;
import play.api.MarkerContext$;
import play.api.Mode;
import play.api.Mode$Dev$;
import play.api.http.HttpFilters;
import play.api.inject.BindingKey;
import play.api.inject.BindingKey$;
import play.api.inject.Injector;
import play.api.mvc.EssentialFilter;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Singleton
@ScalaSignature(bytes="\u0006\u0005Y4A!\u0005\n\u00013!AA\u0005\u0001B\u0001B\u0003%Q\u0005\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003+\u0011!i\u0003A!A!\u0002\u0013q\u0003\"\u0002\u001b\u0001\t\u0003)\u0004b\u0002\"\u0001\u0005\u0004%Ia\u0011\u0005\u0007\u0019\u0002\u0001\u000b\u0011\u0002#\t\u000f5\u0003!\u0019!C\u0005\u001d\"1!\u000b\u0001Q\u0001\n=Cqa\u0015\u0001C\u0002\u0013%1\t\u0003\u0004U\u0001\u0001\u0006I\u0001\u0012\u0005\b+\u0002\u0011\r\u0011\"\u0003D\u0011\u00191\u0006\u0001)A\u0005\t\"9q\u000b\u0001b\u0001\n\u0003B\u0006BB6\u0001A\u0003%\u0011\fC\u0003m\u0001\u0011%Q\u000eC\u0003r\u0001\u0011\u0005QN\u0001\bF]\u0006\u0014G.\u001a3GS2$XM]:\u000b\u0005M!\u0012\u0001\u00025uiBT!!\u0006\f\u0002\u0007\u0005\u0004\u0018NC\u0001\u0018\u0003\u0011\u0001H.Y=\u0004\u0001M\u0019\u0001A\u0007\u0011\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\r\u0005s\u0017PU3g!\t\t#%D\u0001\u0013\u0013\t\u0019#CA\u0006IiR\u0004h)\u001b7uKJ\u001c\u0018aA3omB\u0011aeJ\u0007\u0002)%\u0011\u0001\u0006\u0006\u0002\f\u000b:4\u0018N]8o[\u0016tG/A\u0007d_:4\u0017nZ;sCRLwN\u001c\t\u0003M-J!\u0001\f\u000b\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0003!IgN[3di>\u0014\bCA\u00183\u001b\u0005\u0001$BA\u0019\u0015\u0003\u0019IgN[3di&\u00111\u0007\r\u0002\t\u0013:TWm\u0019;pe\u00061A(\u001b8jiz\"BAN\u001c9sA\u0011\u0011\u0005\u0001\u0005\u0006I\u0011\u0001\r!\n\u0005\u0006S\u0011\u0001\rA\u000b\u0005\u0006[\u0011\u0001\rA\f\u0015\u0003\tm\u0002\"\u0001\u0010!\u000e\u0003uR!!\r \u000b\u0003}\nQA[1wCbL!!Q\u001f\u0003\r%s'.Z2u\u0003\r)(\u000f\\\u000b\u0002\tB\u0011QIS\u0007\u0002\r*\u0011q\tS\u0001\u0005Y\u0006twMC\u0001J\u0003\u0011Q\u0017M^1\n\u0005-3%AB*ue&tw-\u0001\u0003ve2\u0004\u0013A\u00027pO\u001e,'/F\u0001P!\t1\u0003+\u0003\u0002R)\t1Aj\\4hKJ\fq\u0001\\8hO\u0016\u0014\b%\u0001\u0006f]\u0006\u0014G.\u001a3LKf\f1\"\u001a8bE2,GmS3zA\u0005YA-[:bE2,GmS3z\u00031!\u0017n]1cY\u0016$7*Z=!\u0003\u001d1\u0017\u000e\u001c;feN,\u0012!\u0017\t\u00045\n,gBA.a\u001d\tav,D\u0001^\u0015\tq\u0006$\u0001\u0004=e>|GOP\u0005\u0002;%\u0011\u0011\rH\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0019GMA\u0002TKFT!!\u0019\u000f\u0011\u0005\u0019LW\"A4\u000b\u0005!$\u0012aA7wG&\u0011!n\u001a\u0002\u0010\u000bN\u001cXM\u001c;jC24\u0015\u000e\u001c;fe\u0006Aa-\u001b7uKJ\u001c\b%A\u000bqe&tG/T3tg\u0006<W-\u00138EKZlu\u000eZ3\u0015\u00039\u0004\"aG8\n\u0005Ad\"\u0001B+oSR\fQa\u001d;beRD#\u0001A:\u0011\u0005q\"\u0018BA;>\u0005%\u0019\u0016N\\4mKR|g\u000e")
public class EnabledFilters
implements HttpFilters {
    private final Environment env;
    private final Configuration configuration;
    private final Injector injector;
    private final String url;
    private final Logger logger;
    private final String enabledKey;
    private final String disabledKey;
    private final Seq<EssentialFilter> filters;

    @Override
    public play.http.HttpFilters asJava() {
        return HttpFilters.asJava$(this);
    }

    private String url() {
        return this.url;
    }

    private Logger logger() {
        return this.logger;
    }

    private String enabledKey() {
        return this.enabledKey;
    }

    private String disabledKey() {
        return this.disabledKey;
    }

    @Override
    public Seq<EssentialFilter> filters() {
        return this.filters;
    }

    private void printMessageInDevMode() {
        Mode mode = this.env.mode();
        Mode$Dev$ mode$Dev$ = Mode$Dev$.MODULE$;
        if (!(mode != null ? !mode.equals(mode$Dev$) : mode$Dev$ != null)) {
            StringBuffer b = new StringBuffer();
            b.append(new StringBuilder(27).append("Enabled Filters (see <").append(this.url()).append(">):\n\n").toString());
            this.filters().foreach((Function1 & Serializable)f -> b.append(new StringBuilder(5).append("    ").append(f.getClass().getCanonicalName()).append("\n").toString()));
            this.logger().info((Function0<String>)(Function0 & Serializable)() -> b.toString(), MarkerContext$.MODULE$.NoMarker());
            return;
        }
    }

    public void start() {
        this.printMessageInDevMode();
    }

    private final /* synthetic */ Seq liftedTree1$1() {
        Nil$ nil$;
        try {
            Set disabledSet = ((IterableOnceOps)this.configuration.get(this.disabledKey(), ConfigLoader$.MODULE$.seqStringLoader())).toSet();
            Seq enabledList = (Seq)((IterableOps)this.configuration.get(this.enabledKey(), ConfigLoader$.MODULE$.seqStringLoader())).filterNot((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)disabledSet.contains((Object)elem)));
            nil$ = (Seq)enabledList.map((Function1 & Serializable)filterClassName -> {
                BindingKey<?> bindingKey;
                try {
                    Class<?> filterClass = $this.env.classLoader().loadClass((String)filterClassName);
                    bindingKey = BindingKey$.MODULE$.apply(filterClass);
                }
                catch (ClassNotFoundException e) {
                    throw $this.configuration.reportError(this.enabledKey(), new StringBuilder(18).append("Cannot load class ").append((String)filterClassName).toString(), (Option<Throwable>)new Some((Object)e));
                }
                return bindingKey;
            });
        }
        catch (ConfigException.Null e) {
            nil$ = Nil$.MODULE$;
        }
        catch (ConfigException.Missing e) {
            nil$ = Nil$.MODULE$;
        }
        return nil$;
    }

    @Inject
    public EnabledFilters(Environment env, Configuration configuration, Injector injector) {
        this.env = env;
        this.configuration = configuration;
        this.injector = injector;
        HttpFilters.$init$(this);
        this.url = "https://www.playframework.com/documentation/latest/Filters";
        this.logger = Logger$.MODULE$.apply(this.getClass());
        this.enabledKey = "play.filters.enabled";
        this.disabledKey = "play.filters.disabled";
        Seq bindings = this.liftedTree1$1();
        this.filters = (Seq)bindings.map((Function1 & Serializable)x$1 -> (EssentialFilter)$this.injector.instanceOf(x$1));
        this.start();
    }
}

