/*
 * Decompiled with CFR 0.152.
 */
package play.api.http;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.api.Application;
import play.api.Application$;
import play.api.ConfigLoader$;
import play.api.Configuration;
import play.api.Environment;
import play.api.Mode$Dev$;
import play.api.Mode$Prod$;
import play.api.Play$;
import play.api.http.ActionCompositionConfiguration;
import play.api.http.ActionCompositionConfiguration$;
import play.api.http.CookiesConfiguration;
import play.api.http.CookiesConfiguration$;
import play.api.http.FileMimeTypesConfiguration;
import play.api.http.FileMimeTypesConfiguration$;
import play.api.http.FlashConfiguration;
import play.api.http.FlashConfiguration$;
import play.api.http.HttpConfiguration;
import play.api.http.JWTConfiguration;
import play.api.http.JWTConfigurationParser$;
import play.api.http.ParserConfiguration;
import play.api.http.ParserConfiguration$;
import play.api.http.SecretConfiguration;
import play.api.http.SecretConfiguration$;
import play.api.http.SessionConfiguration;
import play.api.http.SessionConfiguration$;
import play.api.libs.Codecs$;
import play.api.mvc.Cookie;
import play.api.mvc.Cookie$SameSite$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple8;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class HttpConfiguration$
implements Serializable {
    public static final HttpConfiguration$ MODULE$ = new HttpConfiguration$();
    private static final Logger logger = LoggerFactory.getLogger(HttpConfiguration.class);
    private static final Function1<Application, HttpConfiguration> httpConfigurationCache = Application$.MODULE$.instanceCache(ClassTag$.MODULE$.apply(HttpConfiguration.class));

    public String $lessinit$greater$default$1() {
        return "/";
    }

    public ParserConfiguration $lessinit$greater$default$2() {
        return new ParserConfiguration(ParserConfiguration$.MODULE$.apply$default$1(), ParserConfiguration$.MODULE$.apply$default$2());
    }

    public ActionCompositionConfiguration $lessinit$greater$default$3() {
        return new ActionCompositionConfiguration(ActionCompositionConfiguration$.MODULE$.apply$default$1(), ActionCompositionConfiguration$.MODULE$.apply$default$2());
    }

    public CookiesConfiguration $lessinit$greater$default$4() {
        return new CookiesConfiguration(CookiesConfiguration$.MODULE$.apply$default$1());
    }

    public SessionConfiguration $lessinit$greater$default$5() {
        return new SessionConfiguration(SessionConfiguration$.MODULE$.apply$default$1(), SessionConfiguration$.MODULE$.apply$default$2(), SessionConfiguration$.MODULE$.apply$default$3(), SessionConfiguration$.MODULE$.apply$default$4(), SessionConfiguration$.MODULE$.apply$default$5(), SessionConfiguration$.MODULE$.apply$default$6(), SessionConfiguration$.MODULE$.apply$default$7(), SessionConfiguration$.MODULE$.apply$default$8());
    }

    public FlashConfiguration $lessinit$greater$default$6() {
        return new FlashConfiguration(FlashConfiguration$.MODULE$.apply$default$1(), FlashConfiguration$.MODULE$.apply$default$2(), FlashConfiguration$.MODULE$.apply$default$3(), FlashConfiguration$.MODULE$.apply$default$4(), FlashConfiguration$.MODULE$.apply$default$5(), FlashConfiguration$.MODULE$.apply$default$6(), FlashConfiguration$.MODULE$.apply$default$7());
    }

    public FileMimeTypesConfiguration $lessinit$greater$default$7() {
        return new FileMimeTypesConfiguration(FileMimeTypesConfiguration$.MODULE$.apply$default$1());
    }

    public SecretConfiguration $lessinit$greater$default$8() {
        return new SecretConfiguration(SecretConfiguration$.MODULE$.apply$default$1(), SecretConfiguration$.MODULE$.apply$default$2());
    }

    private Logger logger() {
        return logger;
    }

    private Function1<Application, HttpConfiguration> httpConfigurationCache() {
        return httpConfigurationCache;
    }

    public Option<Cookie.SameSite> parseSameSite(Configuration config, String key) {
        return config.get(key, ConfigLoader$.MODULE$.optionLoader(ConfigLoader$.MODULE$.stringLoader())).flatMap((Function1 & Serializable)value -> {
            Option<Cookie.SameSite> result;
            block0: {
                result = Cookie$SameSite$.MODULE$.parse((String)value);
                if (!result.isEmpty()) break block0;
                String values = Cookie$SameSite$.MODULE$.values().mkString(", ");
                MODULE$.logger().warn(new StringBuilder(59).append("Assuming ").append(key).append(" = null, since \"").append((String)value).append("\" is not a valid SameSite value (").append(values).append(")").toString());
            }
            return result;
        });
    }

    public Map<String, String> parseFileMimeTypes(Configuration config) {
        return ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(config.get("play.http.fileMimeTypes", ConfigLoader$.MODULE$.stringLoader())), '\n'))).flatMap((Function1 & Serializable)l -> {
            String string;
            String line = l.trim();
            Tuple2 tuple2 = StringOps$.MODULE$.splitAt$extension(Predef$.MODULE$.augmentString(line), 1);
            if (tuple2 != null) {
                String string2 = (String)tuple2._1();
                String string3 = (String)tuple2._2();
                if ("".equals(string2) && "".equals(string3)) {
                    return Option$.MODULE$.empty();
                }
            }
            if (tuple2 != null && "#".equals(string = (String)tuple2._1())) {
                return Option$.MODULE$.empty();
            }
            Tuple2 tuple22 = StringOps$.MODULE$.span$extension(Predef$.MODULE$.augmentString(line), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HttpConfiguration$.$anonfun$parseFileMimeTypes$2(BoxesRunTime.unboxToChar((Object)x$1))));
            if (tuple22 != null) {
                String key = (String)tuple22._1();
                String v = (String)tuple22._2();
                return new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(v), 1)));
            }
            return Option$.MODULE$.empty();
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public HttpConfiguration fromConfiguration(Configuration config, Environment environment) {
        String context = HttpConfiguration$.getPath$1("play.http.context", (Option)new Some((Object)"application.context"), config);
        String sessionPath = HttpConfiguration$.getPath$1("play.http.session.path", HttpConfiguration$.getPath$default$2$1(), config);
        String flashPath = HttpConfiguration$.getPath$1("play.http.flash.path", HttpConfiguration$.getPath$default$2$1(), config);
        if (config.has("mimetype")) {
            throw config.globalError("mimetype replaced by play.http.fileMimeTypes map", config.globalError$default$2());
        }
        String x$1 = config.getDeprecated("play.http.session.cookieName", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"session.cookieName"}), ConfigLoader$.MODULE$.stringLoader());
        boolean x$2 = BoxesRunTime.unboxToBoolean((Object)config.getDeprecated("play.http.session.secure", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"session.secure"}), ConfigLoader$.MODULE$.booleanLoader()));
        Option<FiniteDuration> x$3 = config.getDeprecated("play.http.session.maxAge", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"session.maxAge"}), ConfigLoader$.MODULE$.optionLoader(ConfigLoader$.MODULE$.finiteDurationLoader()));
        boolean x$4 = BoxesRunTime.unboxToBoolean((Object)config.getDeprecated("play.http.session.httpOnly", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"session.httpOnly"}), ConfigLoader$.MODULE$.booleanLoader()));
        Option<String> x$5 = config.getDeprecated("play.http.session.domain", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"session.domain"}), ConfigLoader$.MODULE$.optionLoader(ConfigLoader$.MODULE$.stringLoader()));
        Option<Cookie.SameSite> x$6 = this.parseSameSite(config, "play.http.session.sameSite");
        String x$7 = sessionPath;
        JWTConfiguration x$8 = JWTConfigurationParser$.MODULE$.apply(config, "play.http.session.jwt");
        String x$9 = config.getDeprecated("play.http.flash.cookieName", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"flash.cookieName"}), ConfigLoader$.MODULE$.stringLoader());
        boolean x$10 = BoxesRunTime.unboxToBoolean((Object)config.get("play.http.flash.secure", ConfigLoader$.MODULE$.booleanLoader()));
        boolean x$11 = BoxesRunTime.unboxToBoolean((Object)config.get("play.http.flash.httpOnly", ConfigLoader$.MODULE$.booleanLoader()));
        Option<String> x$12 = config.get("play.http.flash.domain", ConfigLoader$.MODULE$.optionLoader(ConfigLoader$.MODULE$.stringLoader()));
        Option<Cookie.SameSite> x$13 = this.parseSameSite(config, "play.http.flash.sameSite");
        String x$14 = flashPath;
        JWTConfiguration x$15 = JWTConfigurationParser$.MODULE$.apply(config, "play.http.flash.jwt");
        return new HttpConfiguration(context, new ParserConfiguration(config.getDeprecated("play.http.parser.maxMemoryBuffer", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"parsers.text.maxLength"}), ConfigLoader$.MODULE$.bytesLoader()).toBytes(), config.get("play.http.parser.maxDiskBuffer", ConfigLoader$.MODULE$.bytesLoader()).toBytes()), new ActionCompositionConfiguration(BoxesRunTime.unboxToBoolean((Object)config.get("play.http.actionComposition.controllerAnnotationsFirst", ConfigLoader$.MODULE$.booleanLoader())), BoxesRunTime.unboxToBoolean((Object)config.get("play.http.actionComposition.executeActionCreatorActionFirst", ConfigLoader$.MODULE$.booleanLoader()))), new CookiesConfiguration(BoxesRunTime.unboxToBoolean((Object)config.get("play.http.cookies.strict", ConfigLoader$.MODULE$.booleanLoader()))), new SessionConfiguration(x$1, x$2, x$3, x$4, x$5, x$7, x$6, x$8), new FlashConfiguration(x$9, x$10, x$11, x$12, x$14, x$13, x$15), new FileMimeTypesConfiguration(this.parseFileMimeTypes(config)), this.getSecretConfiguration(config, environment));
    }

    /*
     * Unable to fully structure code
     */
    private SecretConfiguration getSecretConfiguration(Configuration config, Environment environment) {
        block12: {
            block13: {
                block11: {
                    Blank = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\s*"));
                    var8_4 = false;
                    var9_5 = null;
                    var10_6 = config.get("play.http.secret.key", ConfigLoader$.MODULE$.optionLoader(ConfigLoader$.MODULE$.stringLoader()));
                    if (var10_6 instanceof Some != false && "changeme".equals(var12_8 = (String)(var11_7 = (Some)var10_6).value()) != false ? true : (var10_6 instanceof Some != false && (var14_10 = (String)(var13_9 = (Some)var10_6).value()) != null && (var15_11 = Blank.unapplySeq((CharSequence)var14_10)).isEmpty() == false && var15_11.get() != null && ((List)var15_11.get()).lengthCompare(0) == 0 ? true : None$.MODULE$.equals(var10_6) != false)) {
                        v0 = environment.mode();
                        var16_12 = Mode$Prod$.MODULE$;
                        if (!(v0 != null ? v0.equals(var16_12) == false : var16_12 != null)) {
                            message = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n              |The application secret has not been set, and we are in prod mode. Your application is not secure.\n              |To set the application secret, please read http://playframework.com/documentation/latest/ApplicationSecret\n          "));
                            throw config.reportError("play.http.secret", message, config.reportError$default$3());
                        }
                    }
                    if (var10_6 instanceof Some) {
                        var8_4 = true;
                        var9_5 = (Some)var10_6;
                        s = (String)var9_5.value();
                        if (s.length() < SecretConfiguration$.MODULE$.SHORTEST_SECRET_LENGTH()) {
                            v1 = environment.mode();
                            var19_15 = Mode$Prod$.MODULE$;
                            if (!(v1 != null ? v1.equals(var19_15) == false : var19_15 != null)) {
                                message = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n              |The application secret is too short and does not have the recommended amount of entropy.  Your application is not secure.\n              |To set the application secret, please read http://playframework.com/documentation/latest/ApplicationSecret\n          "));
                                throw config.reportError("play.http.secret", message, config.reportError$default$3());
                            }
                        }
                    }
                    if (!var8_4 || (s = (String)var9_5.value()).length() >= SecretConfiguration$.MODULE$.SHORT_SECRET_LENGTH()) break block11;
                    v2 = environment.mode();
                    var22_18 = Mode$Prod$.MODULE$;
                    if (v2 != null ? v2.equals(var22_18) == false : var22_18 != null) break block11;
                    message = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n              |Your secret key is very short, and may be vulnerable to dictionary attacks.  Your application may not be secure.\n              |The application secret should ideally be 32 bytes of completely random input, encoded in base64.\n              |To set the application secret, please read http://playframework.com/documentation/latest/ApplicationSecret\n          "));
                    this.logger().warn(message);
                    v3 = s;
                    break block12;
                }
                if (!var8_4 || (s = (String)var9_5.value()).length() >= SecretConfiguration$.MODULE$.SHORTEST_SECRET_LENGTH() || s.equals("changeme") || !StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(s.trim()))) break block13;
                v4 = environment.mode();
                var25_21 = Mode$Dev$.MODULE$;
                if (v4 != null ? v4.equals(var25_21) == false : var25_21 != null) break block13;
                message = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n              |The application secret is too short and does not have the recommended amount of entropy.  Your application is not secure\n              |and it will fail to start in production mode.\n              |To set the application secret, please read http://playframework.com/documentation/latest/ApplicationSecret\n          "));
                this.logger().warn(message);
                v3 = s;
                break block12;
            }
            if (!var8_4 || (s = (String)var9_5.value()).length() >= SecretConfiguration$.MODULE$.SHORT_SECRET_LENGTH() || s.equals("changeme") || !StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(s.trim()))) ** GOTO lbl-1000
            v5 = environment.mode();
            var28_24 = Mode$Dev$.MODULE$;
            if (!(v5 != null ? v5.equals(var28_24) == false : var28_24 != null)) {
                message = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n              |Your secret key is very short, and may be vulnerable to dictionary attacks.  Your application may not be secure.\n              |The application secret should ideally be 32 bytes of completely random input, encoded in base64. While the application\n              |will be able to start in production mode, you will also see a warning when it is starting.\n              |To set the application secret, please read http://playframework.com/documentation/latest/ApplicationSecret\n          "));
                this.logger().warn(message);
                v3 = s;
            } else if (var10_6 instanceof Some != false && "changeme".equals(var31_27 = (String)(var30_26 = (Some)var10_6).value()) != false ? true : (var10_6 instanceof Some != false && (var33_29 = (String)(var32_28 = (Some)var10_6).value()) != null && (var34_30 = Blank.unapplySeq((CharSequence)var33_29)).isEmpty() == false && var34_30.get() != null && ((List)var34_30.get()).lengthCompare(0) == 0 ? true : None$.MODULE$.equals(var10_6) != false)) {
                appConfLocation = environment.resource("application.conf");
                secret = (String)appConfLocation.fold((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$getSecretConfiguration$1(), ()Ljava/lang/String;)(), (Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$getSecretConfiguration$2(java.net.URL ), (Ljava/net/URL;)Ljava/lang/String;)());
                md5Secret = Codecs$.MODULE$.md5(secret);
                this.logger().debug(new StringBuilder(38).append("Generated dev mode secret ").append(md5Secret).append(" for app at ").append(appConfLocation.getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$getSecretConfiguration$3(), ()Ljava/lang/String;)())).toString());
                v3 = md5Secret;
            } else if (var8_4) {
                v3 = s = (String)var9_5.value();
            } else {
                throw new MatchError(var10_6);
            }
        }
        secret = v3;
        provider = config.getDeprecated("play.http.secret.provider", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"play.crypto.provider"}), ConfigLoader$.MODULE$.optionLoader(ConfigLoader$.MODULE$.stringLoader()));
        return new SecretConfiguration(String.valueOf(secret), provider);
    }

    public HttpConfiguration current() {
        Try<Application> try_ = Play$.MODULE$.privateMaybeApplication();
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Application app = (Application)success.value();
            return (HttpConfiguration)this.httpConfigurationCache().apply((Object)app);
        }
        if (try_ instanceof Failure) {
            return new HttpConfiguration(this.apply$default$1(), this.apply$default$2(), this.apply$default$3(), this.apply$default$4(), this.apply$default$5(), this.apply$default$6(), this.apply$default$7(), this.apply$default$8());
        }
        throw new MatchError(try_);
    }

    public HttpConfiguration createWithDefaults() {
        return new HttpConfiguration(this.apply$default$1(), this.apply$default$2(), this.apply$default$3(), this.apply$default$4(), this.apply$default$5(), this.apply$default$6(), this.apply$default$7(), this.apply$default$8());
    }

    public HttpConfiguration apply(String context, ParserConfiguration parser2, ActionCompositionConfiguration actionComposition, CookiesConfiguration cookies, SessionConfiguration session, FlashConfiguration flash, FileMimeTypesConfiguration fileMimeTypes, SecretConfiguration secret) {
        return new HttpConfiguration(context, parser2, actionComposition, cookies, session, flash, fileMimeTypes, secret);
    }

    public String apply$default$1() {
        return "/";
    }

    public ParserConfiguration apply$default$2() {
        return new ParserConfiguration(ParserConfiguration$.MODULE$.apply$default$1(), ParserConfiguration$.MODULE$.apply$default$2());
    }

    public ActionCompositionConfiguration apply$default$3() {
        return new ActionCompositionConfiguration(ActionCompositionConfiguration$.MODULE$.apply$default$1(), ActionCompositionConfiguration$.MODULE$.apply$default$2());
    }

    public CookiesConfiguration apply$default$4() {
        return new CookiesConfiguration(CookiesConfiguration$.MODULE$.apply$default$1());
    }

    public SessionConfiguration apply$default$5() {
        return new SessionConfiguration(SessionConfiguration$.MODULE$.apply$default$1(), SessionConfiguration$.MODULE$.apply$default$2(), SessionConfiguration$.MODULE$.apply$default$3(), SessionConfiguration$.MODULE$.apply$default$4(), SessionConfiguration$.MODULE$.apply$default$5(), SessionConfiguration$.MODULE$.apply$default$6(), SessionConfiguration$.MODULE$.apply$default$7(), SessionConfiguration$.MODULE$.apply$default$8());
    }

    public FlashConfiguration apply$default$6() {
        return new FlashConfiguration(FlashConfiguration$.MODULE$.apply$default$1(), FlashConfiguration$.MODULE$.apply$default$2(), FlashConfiguration$.MODULE$.apply$default$3(), FlashConfiguration$.MODULE$.apply$default$4(), FlashConfiguration$.MODULE$.apply$default$5(), FlashConfiguration$.MODULE$.apply$default$6(), FlashConfiguration$.MODULE$.apply$default$7());
    }

    public FileMimeTypesConfiguration apply$default$7() {
        return new FileMimeTypesConfiguration(FileMimeTypesConfiguration$.MODULE$.apply$default$1());
    }

    public SecretConfiguration apply$default$8() {
        return new SecretConfiguration(SecretConfiguration$.MODULE$.apply$default$1(), SecretConfiguration$.MODULE$.apply$default$2());
    }

    public Option<Tuple8<String, ParserConfiguration, ActionCompositionConfiguration, CookiesConfiguration, SessionConfiguration, FlashConfiguration, FileMimeTypesConfiguration, SecretConfiguration>> unapply(HttpConfiguration x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple8((Object)x$0.context(), (Object)x$0.parser(), (Object)x$0.actionComposition(), (Object)x$0.cookies(), (Object)x$0.session(), (Object)x$0.flash(), (Object)x$0.fileMimeTypes(), (Object)x$0.secret()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(HttpConfiguration$.class);
    }

    public static final /* synthetic */ boolean $anonfun$parseFileMimeTypes$2(char x$1) {
        return x$1 != '=';
    }

    private static final String getPath$1(String key, Option deprecatedKey, Configuration config$1) {
        String string;
        Option option = deprecatedKey;
        if (option instanceof Some) {
            Some some = (Some)option;
            String depKey = (String)some.value();
            string = config$1.getDeprecated(key, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{depKey}), ConfigLoader$.MODULE$.stringLoader());
        } else if (None$.MODULE$.equals(option)) {
            string = config$1.get(key, ConfigLoader$.MODULE$.stringLoader());
        } else {
            throw new MatchError((Object)option);
        }
        String path = string;
        if (!path.startsWith("/")) {
            throw config$1.globalError(new StringBuilder(20).append(key).append(" must start with a /").toString(), config$1.globalError$default$2());
        }
        return path;
    }

    private static final Option getPath$default$2$1() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ String $anonfun$getSecretConfiguration$1() {
        return "she sells sea shells on the sea shore";
    }

    public static final /* synthetic */ String $anonfun$getSecretConfiguration$2(URL x$2) {
        return x$2.toString();
    }

    public static final /* synthetic */ String $anonfun$getSecretConfiguration$3() {
        return "unknown location";
    }

    private HttpConfiguration$() {
    }
}

