/*
 * Decompiled with CFR 0.152.
 */
package play.api.http;

import java.io.Serializable;
import javax.inject.Inject;
import play.api.Environment;
import play.api.Logger;
import play.api.Logger$;
import play.api.MarkerContext$;
import play.api.Mode;
import play.api.Mode$Prod$;
import play.api.OptionalSourceMapper;
import play.api.UsefulException;
import play.api.http.HttpErrorHandler;
import play.api.http.HttpErrorHandlerExceptions$;
import play.api.http.JsonHttpErrorHandler$;
import play.api.http.Status$;
import play.api.http.Writeable$;
import play.api.libs.json.JsArray;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsObject$;
import play.api.libs.json.JsString;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import play.api.mvc.RequestHeader;
import play.api.mvc.Result;
import play.api.mvc.Results$;
import play.core.SourceMapper;
import play.libs.exception.ExceptionUtils;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IndexedSeq;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005e\u0001B\n\u0015\u0001mA\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\tW\u0001\u0011\t\u0011)A\u0005Y!)Q\u0007\u0001C\u0001m!9!\b\u0001b\u0001\n\u0013Y\u0004BB \u0001A\u0003%A\bC\u00036\u0001\u0011\u0005\u0001\tC\u0003Q\u0001\u00115\u0011\u000bC\u0003a\u0001\u0011\u0005\u0013\rC\u0004\u0002\f\u0001!\t%!\u0004\t\u000f\u0005\u001d\u0002\u0001\"\u0005\u0002*!9\u0011Q\u0007\u0001\u0005\u0012\u0005]\u0002bBA\"\u0001\u0011E\u0011Q\t\u0005\b\u0003\u0013\u0002A\u0011CA&\u0011\u001d\t\t\u0006\u0001C\t\u0003':\u0011\"!\u0019\u0015\u0003\u0003E\t!a\u0019\u0007\u0011M!\u0012\u0011!E\u0001\u0003KBa!\u000e\t\u0005\u0002\u0005\u001d\u0004\"CA5!E\u0005I\u0011AA6\u0005QQ5o\u001c8IiR\u0004XI\u001d:pe\"\u000bg\u000e\u001a7fe*\u0011QCF\u0001\u0005QR$\bO\u0003\u0002\u00181\u0005\u0019\u0011\r]5\u000b\u0003e\tA\u0001\u001d7bs\u000e\u00011c\u0001\u0001\u001dEA\u0011Q\u0004I\u0007\u0002=)\tq$A\u0003tG\u0006d\u0017-\u0003\u0002\"=\t1\u0011I\\=SK\u001a\u0004\"a\t\u0013\u000e\u0003QI!!\n\u000b\u0003!!#H\u000f]#se>\u0014\b*\u00198eY\u0016\u0014\u0018aC3om&\u0014xN\\7f]R\u0004\"\u0001K\u0015\u000e\u0003YI!A\u000b\f\u0003\u0017\u0015sg/\u001b:p]6,g\u000e^\u0001\rg>,(oY3NCB\u0004XM\u001d\t\u0004;5z\u0013B\u0001\u0018\u001f\u0005\u0019y\u0005\u000f^5p]B\u0011\u0001gM\u0007\u0002c)\u0011!\u0007G\u0001\u0005G>\u0014X-\u0003\u00025c\ta1k\\;sG\u0016l\u0015\r\u001d9fe\u00061A(\u001b8jiz\"2a\u000e\u001d:!\t\u0019\u0003\u0001C\u0003'\u0007\u0001\u0007q\u0005C\u0004,\u0007A\u0005\t\u0019\u0001\u0017\u0002\r1|wmZ3s+\u0005a\u0004C\u0001\u0015>\u0013\tqdC\u0001\u0004M_\u001e<WM]\u0001\bY><w-\u001a:!)\r9\u0014I\u0011\u0005\u0006M\u0019\u0001\ra\n\u0005\u0006\u0007\u001a\u0001\r\u0001R\u0001\u0015_B$\u0018n\u001c8bYN{WO]2f\u001b\u0006\u0004\b/\u001a:\u0011\u0005!*\u0015B\u0001$\u0017\u0005Qy\u0005\u000f^5p]\u0006d7k\\;sG\u0016l\u0015\r\u001d9fe\"\u0012a\u0001\u0013\t\u0003\u0013:k\u0011A\u0013\u0006\u0003\u00172\u000ba!\u001b8kK\u000e$(\"A'\u0002\u000b)\fg/\u0019=\n\u0005=S%AB%oU\u0016\u001cG/A\u0003feJ|'\u000f\u0006\u0002S5B\u00111\u000bW\u0007\u0002)*\u0011QKV\u0001\u0005UN|gN\u0003\u0002X-\u0005!A.\u001b2t\u0013\tIFK\u0001\u0005Kg>\u0013'.Z2u\u0011\u0015Yv\u00011\u0001S\u0003\u001d\u0019wN\u001c;f]RD#aB/\u0011\u0005uq\u0016BA0\u001f\u0005\u0019Ig\u000e\\5oK\u0006iqN\\\"mS\u0016tG/\u0012:s_J$BA\u00198tqB\u00191M\u001a5\u000e\u0003\u0011T!!\u001a\u0010\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002hI\n1a)\u001e;ve\u0016\u0004\"!\u001b7\u000e\u0003)T!a\u001b\f\u0002\u0007548-\u0003\u0002nU\n1!+Z:vYRDQa\u001c\u0005A\u0002A\fqA]3rk\u0016\u001cH\u000f\u0005\u0002jc&\u0011!O\u001b\u0002\u000e%\u0016\fX/Z:u\u0011\u0016\fG-\u001a:\t\u000bQD\u0001\u0019A;\u0002\u0015M$\u0018\r^;t\u0007>$W\r\u0005\u0002\u001em&\u0011qO\b\u0002\u0004\u0013:$\bbB=\t!\u0003\u0005\rA_\u0001\b[\u0016\u001c8/Y4f!\rY\u0018Q\u0001\b\u0004y\u0006\u0005\u0001CA?\u001f\u001b\u0005q(BA@\u001b\u0003\u0019a$o\\8u}%\u0019\u00111\u0001\u0010\u0002\rA\u0013X\rZ3g\u0013\u0011\t9!!\u0003\u0003\rM#(/\u001b8h\u0015\r\t\u0019AH\u0001\u000e_:\u001cVM\u001d<fe\u0016\u0013(o\u001c:\u0015\u000b\t\fy!!\u0005\t\u000b=L\u0001\u0019\u00019\t\u000f\u0005M\u0011\u00021\u0001\u0002\u0016\u0005IQ\r_2faRLwN\u001c\t\u0005\u0003/\t\tC\u0004\u0003\u0002\u001a\u0005uabA?\u0002\u001c%\tq$C\u0002\u0002 y\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002$\u0005\u0015\"!\u0003+ie><\u0018M\u00197f\u0015\r\tyBH\u0001\u000fM\u0006$\u0018\r\\#se>\u0014(j]8o)\u0019\tY#!\r\u00024A\u00191+!\f\n\u0007\u0005=BKA\u0004KgZ\u000bG.^3\t\u000b=T\u0001\u0019\u00019\t\u000f\u0005M!\u00021\u0001\u0002\u0016\u0005qA-\u001a<TKJ4XM]#se>\u0014HCBA\u0016\u0003s\tY\u0004C\u0003p\u0017\u0001\u0007\u0001\u000fC\u0004\u0002\u0014-\u0001\r!!\u0010\u0011\u0007!\ny$C\u0002\u0002BY\u0011q\"V:fMVdW\t_2faRLwN\\\u0001\u001eM>\u0014X.\u0019;EKZ\u001cVM\u001d<fe\u0016\u0013(o\u001c:Fq\u000e,\u0007\u000f^5p]R!\u00111FA$\u0011\u001d\t\u0019\u0002\u0004a\u0001\u0003+\tq\u0002\u001d:pIN+'O^3s\u000bJ\u0014xN\u001d\u000b\u0007\u0003W\ti%a\u0014\t\u000b=l\u0001\u0019\u00019\t\u000f\u0005MQ\u00021\u0001\u0002>\u0005qAn\\4TKJ4XM]#se>\u0014HCBA+\u00037\ni\u0006E\u0002\u001e\u0003/J1!!\u0017\u001f\u0005\u0011)f.\u001b;\t\u000b=t\u0001\u0019\u00019\t\u000f\u0005}c\u00021\u0001\u0002>\u0005yQo]3gk2,\u0005pY3qi&|g.\u0001\u000bKg>t\u0007\n\u001e;q\u000bJ\u0014xN\u001d%b]\u0012dWM\u001d\t\u0003GA\u0019\"\u0001\u0005\u000f\u0015\u0005\u0005\r\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0002n)\u001aA&a\u001c,\u0005\u0005E\u0004\u0003BA:\u0003{j!!!\u001e\u000b\t\u0005]\u0014\u0011P\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u001f\u001f\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u007f\n)HA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class JsonHttpErrorHandler
implements HttpErrorHandler {
    private final Environment environment;
    private final Option<SourceMapper> sourceMapper;
    private final Logger logger;

    public static Option<SourceMapper> $lessinit$greater$default$2() {
        return JsonHttpErrorHandler$.MODULE$.$lessinit$greater$default$2();
    }

    @Override
    public String onClientError$default$3() {
        return HttpErrorHandler.onClientError$default$3$(this);
    }

    private Logger logger() {
        return this.logger;
    }

    private final JsObject error(JsObject content) {
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)content, (Writes)JsObject$.MODULE$.writes()))}));
    }

    @Override
    public Future<Result> onClientError(RequestHeader request, int statusCode, String message) {
        if (Status$.MODULE$.isClientError(statusCode)) {
            return Future$.MODULE$.successful((Object)Results$.MODULE$.Status(statusCode).apply(this.error(Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requestId"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToLong((long)request.id()), (Writes)Writes$.MODULE$.LongWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)message, (Writes)Writes$.MODULE$.StringWrites()))}))), Writeable$.MODULE$.writeableOf_JsValue()));
        }
        throw new IllegalArgumentException(new StringBuilder(58).append("onClientError invoked with non client error status code ").append(statusCode).append(": ").append(message).toString());
    }

    @Override
    public Future<Result> onServerError(RequestHeader request, Throwable exception) {
        Future future;
        try {
            Mode mode = this.environment.mode();
            Mode$Prod$ mode$Prod$ = Mode$Prod$.MODULE$;
            boolean isProd = !(mode != null ? !mode.equals(mode$Prod$) : mode$Prod$ != null);
            UsefulException usefulException = HttpErrorHandlerExceptions$.MODULE$.throwableToUsefulException(this.sourceMapper, isProd, exception);
            this.logServerError(request, usefulException);
            future = Future$.MODULE$.successful((Object)Results$.MODULE$.InternalServerError().apply(isProd ? this.prodServerError(request, usefulException) : this.devServerError(request, usefulException), Writeable$.MODULE$.writeableOf_JsValue()));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.logger().error((Function0<String>)(Function0 & Serializable)() -> "Error while handling error", (Function0<Throwable>)(Function0 & Serializable)() -> e, MarkerContext$.MODULE$.NoMarker());
                future = Future$.MODULE$.successful((Object)Results$.MODULE$.InternalServerError().apply(this.fatalErrorJson(request, e), Writeable$.MODULE$.writeableOf_JsValue()));
            }
            throw throwable;
        }
        return future;
    }

    public JsValue fatalErrorJson(RequestHeader request, Throwable exception) {
        return Json$.MODULE$.obj((Seq)Nil$.MODULE$);
    }

    public JsValue devServerError(RequestHeader request, UsefulException exception) {
        return this.error(Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)exception.id, (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requestId"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToLong((long)request.id()), (Writes)Writes$.MODULE$.LongWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exception"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"title"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)exception.title, (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"description"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)exception.description, (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stacktrace"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)this.formatDevServerErrorException(exception.cause), Writes$.MODULE$.jsValueWrites()))})), (Writes)JsObject$.MODULE$.writes()))})));
    }

    public JsValue formatDevServerErrorException(Throwable exception) {
        return new JsArray((IndexedSeq)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ExceptionUtils.getStackFrames(exception)), (Function1 & Serializable)s -> new JsString(s.trim()), ClassTag$.MODULE$.apply(JsString.class))));
    }

    public JsValue prodServerError(RequestHeader request, UsefulException exception) {
        return this.error(Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)exception.id, (Writes)Writes$.MODULE$.StringWrites()))})));
    }

    public void logServerError(RequestHeader request, UsefulException usefulException) {
        this.logger().error((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |\n        |! @%s - Internal server error, for (%s) [%s] ->\n        | "))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{usefulException$2.id, request.method(), request.uri()})), (Function0<Throwable>)(Function0 & Serializable)() -> usefulException, MarkerContext$.MODULE$.NoMarker());
    }

    public JsonHttpErrorHandler(Environment environment, Option<SourceMapper> sourceMapper) {
        this.environment = environment;
        this.sourceMapper = sourceMapper;
        this.logger = Logger$.MODULE$.apply(this.getClass());
    }

    @Inject
    public JsonHttpErrorHandler(Environment environment, OptionalSourceMapper optionalSourceMapper) {
        this(environment, optionalSourceMapper.sourceMapper());
    }
}

