/*
 * Decompiled with CFR 0.152.
 */
package play.api.internal.libs.concurrent;

import akka.Done;
import akka.actor.ActorSystem;
import akka.actor.CoordinatedShutdown;
import akka.actor.CoordinatedShutdown$;
import akka.annotation.InternalApi;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.Await$;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;

@InternalApi
public final class CoordinatedShutdownSupport$ {
    public static final CoordinatedShutdownSupport$ MODULE$ = new CoordinatedShutdownSupport$();
    private static final Logger logger = LoggerFactory.getLogger((String)"play.api.internal.libs.concurrent.CoordinatedShutdownSupport");

    private Logger logger() {
        return logger;
    }

    public Future<Done> asyncShutdown(ActorSystem actorSystem, CoordinatedShutdown.Reason reason) {
        return ((CoordinatedShutdown)CoordinatedShutdown$.MODULE$.apply(actorSystem)).run(reason);
    }

    public void syncShutdown(ActorSystem actorSystem, CoordinatedShutdown.Reason reason) throws TimeoutException, InterruptedException {
        FiniteDuration shutdownTimeout = ((CoordinatedShutdown)CoordinatedShutdown$.MODULE$.apply(actorSystem)).totalTimeout().$plus(Duration$.MODULE$.apply(5L, TimeUnit.SECONDS));
        this.logger().info(new StringBuilder(67).append("Starting synchronous coordinated shutdown with ").append(reason).append(" reason and ").append(shutdownTimeout).append(" timeout").toString());
        Await$.MODULE$.result(this.asyncShutdown(actorSystem, reason), (Duration)shutdownTimeout);
    }

    private CoordinatedShutdownSupport$() {
    }
}

