/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.concurrent;

import akka.actor.ActorSystem;
import akka.actor.ActorSystem$;
import akka.actor.BootstrapSetup;
import akka.actor.BootstrapSetup$;
import akka.actor.setup.ActorSystemSetup;
import akka.actor.setup.ActorSystemSetup$;
import akka.actor.setup.Setup;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigValueFactory;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.api.ConfigLoader$;
import play.api.Configuration;
import play.api.libs.concurrent.ActorSystemProvider;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

public final class ActorSystemProvider$ {
    public static final ActorSystemProvider$ MODULE$ = new ActorSystemProvider$();
    private static final Logger logger = LoggerFactory.getLogger(ActorSystemProvider.class);

    private Logger logger() {
        return logger;
    }

    public ActorSystem start(ClassLoader classLoader, Configuration config) {
        return this.start(classLoader, config, (Seq<Setup>)Nil$.MODULE$);
    }

    public ActorSystem start(ClassLoader classLoader, Configuration config, Setup additionalSetup) {
        return this.start(classLoader, config, (Seq<Setup>)new .colon.colon((Object)additionalSetup, (List)Nil$.MODULE$));
    }

    public ActorSystem start(ClassLoader classLoader, Configuration config, Seq<Setup> additionalSetups) {
        BootstrapSetup bootstrapSetup;
        String exitJvmPath = "akka.coordinated-shutdown.exit-jvm";
        if (BoxesRunTime.unboxToBoolean((Object)config.get(exitJvmPath, ConfigLoader$.MODULE$.booleanLoader()))) {
            String errorMessage = new StringBuilder(118).append("Can't start Play: detected \"").append(exitJvmPath).append(" = on\". ").append("Using \"").append(exitJvmPath).append(" = on\" in Play may cause a deadlock when shutting down. ").append("Please set \"").append(exitJvmPath).append(" = off\"").toString();
            this.logger().error(errorMessage);
            throw config.reportError(exitJvmPath, errorMessage, config.reportError$default$3());
        }
        String playTimeoutKey = "play.akka.shutdown-timeout";
        Duration playTimeoutDuration = (Duration)Try$.MODULE$.apply((Function0 & Serializable)() -> config.get(playTimeoutKey, ConfigLoader$.MODULE$.durationLoader())).getOrElse((Function0 & Serializable)() -> Duration$.MODULE$.Inf());
        int akkaMaxDelay = 2147483;
        FiniteDuration akkaMaxDuration = Duration$.MODULE$.apply((long)akkaMaxDelay, "seconds");
        Duration normalisedDuration = playTimeoutDuration.min((Duration)akkaMaxDuration);
        java.time.Duration akkaTimeoutDuration = java.time.Duration.ofMillis(normalisedDuration.toMillis());
        String akkaTimeoutKey = "akka.coordinated-shutdown.phases.actor-system-terminate.timeout";
        Config akkaConfig = config.get(config.get("play.akka.config", ConfigLoader$.MODULE$.stringLoader()), ConfigLoader$.MODULE$.configLoader()).withFallback((ConfigMergeable)config.underlying()).withValue(akkaTimeoutKey, ConfigValueFactory.fromAnyRef((Object)akkaTimeoutDuration));
        String name = config.get("play.akka.actor-system", ConfigLoader$.MODULE$.stringLoader());
        BootstrapSetup bootstrapSetup2 = bootstrapSetup = BootstrapSetup$.MODULE$.apply((Option)new Some((Object)classLoader), (Option)new Some((Object)akkaConfig), (Option)None$.MODULE$);
        ActorSystemSetup actorSystemSetup = ActorSystemSetup$.MODULE$.apply((Seq)additionalSetups.$plus$colon((Object)bootstrapSetup2));
        this.logger().debug(new StringBuilder(42).append("Starting application default Akka system: ").append(name).toString());
        return ActorSystem$.MODULE$.apply(name, actorSystemSetup);
    }

    private ActorSystemProvider$() {
    }
}

