/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.crypto;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.time.Clock;
import javax.inject.Inject;
import play.api.libs.Codecs$;
import play.api.libs.crypto.CSRFTokenSigner;
import play.api.libs.crypto.CookieSigner;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005E4A!\u0004\b\u0001/!A!\u0005\u0001B\u0001B\u0003%1\u0005\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003(\u0011\u0015y\u0003\u0001\"\u00011\u0011\u001di\u0004A1A\u0005\nyBa!\u0012\u0001!\u0002\u0013y\u0004\"\u0002$\u0001\t\u00039\u0005\"B+\u0001\t\u00031\u0006\"B.\u0001\t\u0003a\u0006\"B/\u0001\t\u0003a\u0006\"\u00020\u0001\t\u0003y\u0006\"B4\u0001\t\u0003B\u0007\"B7\u0001\t\u0013q'A\u0006#fM\u0006,H\u000e^\"T%\u001a#vn[3o'&<g.\u001a:\u000b\u0005=\u0001\u0012AB2ssB$xN\u0003\u0002\u0012%\u0005!A.\u001b2t\u0015\t\u0019B#A\u0002ba&T\u0011!F\u0001\u0005a2\f\u0017p\u0001\u0001\u0014\u0007\u0001Ab\u0004\u0005\u0002\u001a95\t!DC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\"D\u0001\u0004B]f\u0014VM\u001a\t\u0003?\u0001j\u0011AD\u0005\u0003C9\u0011qbQ*S\rR{7.\u001a8TS\u001etWM]\u0001\u0007g&<g.\u001a:\u0011\u0005}!\u0013BA\u0013\u000f\u00051\u0019un\\6jKNKwM\\3s\u0003\u0015\u0019Gn\\2l!\tAS&D\u0001*\u0015\tQ3&\u0001\u0003uS6,'\"\u0001\u0017\u0002\t)\fg/Y\u0005\u0003]%\u0012Qa\u00117pG.\fa\u0001P5oSRtDcA\u00193gA\u0011q\u0004\u0001\u0005\u0006E\r\u0001\ra\t\u0005\u0006M\r\u0001\ra\n\u0015\u0003\u0007U\u0002\"AN\u001e\u000e\u0003]R!\u0001O\u001d\u0002\r%t'.Z2u\u0015\u0005Q\u0014!\u00026bm\u0006D\u0018B\u0001\u001f8\u0005\u0019IeN[3di\u00061!/\u00198e_6,\u0012a\u0010\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005.\n\u0001b]3dkJLG/_\u0005\u0003\t\u0006\u0013AbU3dkJ,'+\u00198e_6\fqA]1oI>l\u0007%A\u0005tS\u001etGk\\6f]R\u0011\u0001j\u0015\t\u0003\u0013Bs!A\u0013(\u0011\u0005-SR\"\u0001'\u000b\u000553\u0012A\u0002\u001fs_>$h(\u0003\u0002P5\u00051\u0001K]3eK\u001aL!!\u0015*\u0003\rM#(/\u001b8h\u0015\ty%\u0004C\u0003U\r\u0001\u0007\u0001*A\u0003u_.,g.\u0001\nfqR\u0014\u0018m\u0019;TS\u001etW\r\u001a+pW\u0016tGCA,[!\rI\u0002\fS\u0005\u00033j\u0011aa\u00149uS>t\u0007\"\u0002+\b\u0001\u0004A\u0015!D4f]\u0016\u0014\u0018\r^3U_.,g.F\u0001I\u0003M9WM\\3sCR,7+[4oK\u0012$vn[3o\u0003M\u0019w.\u001c9be\u0016\u001c\u0016n\u001a8fIR{7.\u001a8t)\r\u00017-\u001a\t\u00033\u0005L!A\u0019\u000e\u0003\u000f\t{w\u000e\\3b]\")AM\u0003a\u0001\u0011\u00061Ao\\6f]\u0006CQA\u001a\u0006A\u0002!\u000ba\u0001^8lK:\u0014\u0015AE2p]N$\u0018M\u001c;US6,W)];bYN$2\u0001Y5l\u0011\u0015Q7\u00021\u0001I\u0003\u0005\t\u0007\"\u00027\f\u0001\u0004A\u0015!\u00012\u0002\u000f%\u001cX)];bYR\u0019\u0001m\u001c9\t\u000b)d\u0001\u0019\u0001%\t\u000b1d\u0001\u0019\u0001%")
public class DefaultCSRFTokenSigner
implements CSRFTokenSigner {
    private final CookieSigner signer;
    private final Clock clock;
    private final SecureRandom random;

    private SecureRandom random() {
        return this.random;
    }

    @Override
    public String signToken(String token) {
        long nonce = this.clock.millis();
        String joined = new StringBuilder(1).append(nonce).append("-").append(token).toString();
        return new StringBuilder(1).append(this.signer.sign(joined)).append("-").append(joined).toString();
    }

    @Override
    public Option<String> extractSignedToken(String token) {
        Object object;
        String[] stringArray = token.split("-", 3);
        if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 3) == 0) {
            String signature = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
            String nonce = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
            String raw2 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2);
            if (this.isEqual(signature, this.signer.sign(new StringBuilder(1).append(nonce).append("-").append(raw2).toString()))) {
                return new Some((Object)raw2);
            }
        }
        return None$.MODULE$;
    }

    @Override
    public String generateToken() {
        byte[] bytes = new byte[12];
        this.random().nextBytes(bytes);
        return Codecs$.MODULE$.toHexString(bytes);
    }

    @Override
    public String generateSignedToken() {
        return this.signToken(this.generateToken());
    }

    @Override
    public boolean compareSignedTokens(String tokenA, String tokenB) {
        return BoxesRunTime.unboxToBoolean((Object)this.extractSignedToken(tokenA).flatMap((Function1 & Serializable)rawA -> this.extractSignedToken(tokenB).map((Function1 & Serializable)rawB -> BoxesRunTime.boxToBoolean((boolean)this.isEqual(rawA, rawB)))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
    }

    @Override
    public boolean constantTimeEquals(String a, String b) {
        return this.isEqual(a, b);
    }

    private boolean isEqual(String a, String b) {
        return MessageDigest.isEqual(a.getBytes(StandardCharsets.UTF_8), b.getBytes(StandardCharsets.UTF_8));
    }

    @Inject
    public DefaultCSRFTokenSigner(CookieSigner signer, Clock clock) {
        this.signer = signer;
        this.clock = clock;
        this.random = new SecureRandom();
        this.random().nextBytes(new byte[55]);
    }
}

