/*
 * Decompiled with CFR 0.152.
 */
package play.api.mvc;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.PrematureJwtException;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SignatureException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.Clock;
import java.util.Base64;
import java.util.Date;
import java.util.Map;
import play.api.Logger;
import play.api.Logger$;
import play.api.MarkerContext$;
import play.api.MarkerContexts$SecurityMarkerContext$;
import play.api.Mode;
import play.api.Mode$Dev$;
import play.api.http.JWTConfiguration;
import play.api.http.SecretConfiguration;
import play.api.mvc.CookieDataCodec;
import play.api.mvc.JWTCookieDataCodec$JWTIDGenerator$;
import play.libs.Scala;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.MapOps;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005mca\u0002\u0010 !\u0003\r\tA\n\u0005\u0006c\u0001!\tA\r\u0005\bm\u0001\u0011\r\u0011\"\u00038\u0011\u0015a\u0004A\"\u0001>\u0011\u0015!\u0005A\"\u0001F\u0011!I\u0005\u0001#b\u0001\n\u0013Q\u0005bBA \u0001\u0011\u0005\u0013\u0011\t\u0005\b\u0003\u0013\u0002A\u0011IA&\u0011\u001d\ty\u0005\u0001C\t\u0003#Ba\u0001\u0016\u0001\u0005\u0012\u0005es!B' \u0011\u0003qe!\u0002\u0010 \u0011\u0003y\u0005\"\u0002)\f\t\u0003\tf!\u0002*\f\u0001\r\u001a\u0006\u0002\u0003\u001f\u000e\u0005\u0003\u0005\u000b\u0011\u0002 \t\u0011\u0011k!\u0011!Q\u0001\n\u0019C\u0001\u0002V\u0007\u0003\u0002\u0003\u0006I!\u0016\u0005\u0006!6!\t!\u0018\u0005\bG6\u0011\r\u0011\"\u0003e\u0011\u0019AW\u0002)A\u0005K\"9a/\u0004b\u0001\n\u00139\bbBA\u0004\u001b\u0001\u0006I\u0001\u001f\u0005\b\u0003\u0013iA\u0011AA\u0006\u0011\u001d\t9\"\u0004C\u0001\u000339\u0001\"a\b\f\u0011\u0003\u0019\u0013\u0011\u0005\u0004\t\u0003GY\u0001\u0012A\u0012\u0002&!1\u0001+\u0007C\u0001\u0003OA\u0011\"!\u000b\u001a\u0005\u0004%I!a\u000b\t\u0011\u0005e\u0012\u0004)A\u0005\u0003[Aq!a\u000f\u001a\t\u0003\tiD\u0001\nK/R\u001bun\\6jK\u0012\u000bG/Y\"pI\u0016\u001c'B\u0001\u0011\"\u0003\rigo\u0019\u0006\u0003E\r\n1!\u00199j\u0015\u0005!\u0013\u0001\u00029mCf\u001c\u0001aE\u0002\u0001O5\u0002\"\u0001K\u0016\u000e\u0003%R\u0011AK\u0001\u0006g\u000e\fG.Y\u0005\u0003Y%\u0012a!\u00118z%\u00164\u0007C\u0001\u00180\u001b\u0005y\u0012B\u0001\u0019 \u0005=\u0019un\\6jK\u0012\u000bG/Y\"pI\u0016\u001c\u0017A\u0002\u0013j]&$H\u0005F\u00014!\tAC'\u0003\u00026S\t!QK\\5u\u0003\u0019awnZ4feV\t\u0001\b\u0005\u0002:u5\t\u0011%\u0003\u0002<C\t1Aj\\4hKJ\f1c]3de\u0016$8i\u001c8gS\u001e,(/\u0019;j_:,\u0012A\u0010\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0003\u0003\u0006\nA\u0001\u001b;ua&\u00111\t\u0011\u0002\u0014'\u0016\u001c'/\u001a;D_:4\u0017nZ;sCRLwN\\\u0001\u0011U^$8i\u001c8gS\u001e,(/\u0019;j_:,\u0012A\u0012\t\u0003\u007f\u001dK!\u0001\u0013!\u0003!);FkQ8oM&<WO]1uS>t\u0017!\u00034pe6\fG\u000f^3s+\u0005Y\u0005C\u0001'\u000e\u001d\tq#\"\u0001\nK/R\u001bun\\6jK\u0012\u000bG/Y\"pI\u0016\u001c\u0007C\u0001\u0018\f'\tYq%\u0001\u0004=S:LGO\u0010\u000b\u0002\u001d\na!j\u0016+G_Jl\u0017\r\u001e;feN\u0011QbJ\u0001\u0006G2|7m\u001b\t\u0003-nk\u0011a\u0016\u0006\u00031f\u000bA\u0001^5nK*\t!,\u0001\u0003kCZ\f\u0017B\u0001/X\u0005\u0015\u0019En\\2l)\u0011q\u0006-\u00192\u0011\u0005}kQ\"A\u0006\t\u000bq\n\u0002\u0019\u0001 \t\u000b\u0011\u000b\u0002\u0019\u0001$\t\u000bQ\u000b\u0002\u0019A+\u0002\u0011)<Ho\u00117pG.,\u0012!\u001a\n\u0004M&|g\u0001B4\u0014\u0001\u0015\u0014A\u0002\u0010:fM&tW-\\3oiz\n\u0011B[<u\u00072|7m\u001b\u0011\u0011\u0005)lW\"A6\u000b\u00051L\u0016\u0001\u00027b]\u001eL!A\\6\u0003\r=\u0013'.Z2u!\t\u0001X/D\u0001r\u0015\t\u00118/\u0001\u0007kg>tw/\u001a2u_.,gNC\u0001u\u0003\tIw.\u0003\u0002]c\u0006\u0019\"-Y:fmQ*enY8eK\u0012\u001cVm\u0019:fiV\t\u0001\u0010E\u0002z\u0003\u0003q!A\u001f@\u0011\u0005mLS\"\u0001?\u000b\u0005u,\u0013A\u0002\u001fs_>$h(\u0003\u0002\u0000S\u00051\u0001K]3eK\u001aLA!a\u0001\u0002\u0006\t11\u000b\u001e:j]\u001eT!a`\u0015\u0002)\t\f7/\u001a\u001c5\u000b:\u001cw\u000eZ3e'\u0016\u001c'/\u001a;!\u0003\u0015\u0001\u0018M]:f)\u0011\ti!a\u0005\u0011\u000be\fy\u0001_\u0014\n\t\u0005E\u0011Q\u0001\u0002\u0004\u001b\u0006\u0004\bBBA\u000b-\u0001\u0007\u00010A\u0007f]\u000e|G-\u001a3TiJLgnZ\u0001\u0007M>\u0014X.\u0019;\u0015\u0007a\fY\u0002C\u0004\u0002\u001e]\u0001\r!!\u0004\u0002\r\rd\u0017-[7t\u00039Qu\u000bV%E\u000f\u0016tWM]1u_J\u0004\"aX\r\u0003\u001d);F+\u0013#HK:,'/\u0019;peN\u0011\u0011d\n\u000b\u0003\u0003C\t!a\u001d:\u0016\u0005\u00055\u0002\u0003BA\u0018\u0003ki!!!\r\u000b\u0007\u0005M\u0012,\u0001\u0005tK\u000e,(/\u001b;z\u0013\u0011\t9$!\r\u0003\u0019M+7-\u001e:f%\u0006tGm\\7\u0002\u0007M\u0014\b%\u0001\u0006hK:,'/\u0019;f\u0013\u0012$\u0012\u0001_\u0001\u0007K:\u001cw\u000eZ3\u0015\u0007a\f\u0019\u0005C\u0004\u0002F\u0019\u0001\r!a\u0012\u0002\t\u0011\fG/\u0019\t\u0006s\u0006=\u0001\u0010_\u0001\u0007I\u0016\u001cw\u000eZ3\u0015\t\u0005\u001d\u0013Q\n\u0005\u0007\u0003+9\u0001\u0019\u0001=\u0002\u0011Ut\u0017.];f\u0013\u0012$\"!a\u0015\u0011\t!\n)\u0006_\u0005\u0004\u0003/J#AB(qi&|g.F\u0001V\u0001")
public interface JWTCookieDataCodec
extends CookieDataCodec {
    public void play$api$mvc$JWTCookieDataCodec$_setter_$play$api$mvc$JWTCookieDataCodec$$logger_$eq(Logger var1);

    public Logger play$api$mvc$JWTCookieDataCodec$$logger();

    public SecretConfiguration secretConfiguration();

    public JWTConfiguration jwtConfiguration();

    public static /* synthetic */ JWTFormatter play$api$mvc$JWTCookieDataCodec$$formatter$(JWTCookieDataCodec $this) {
        return $this.play$api$mvc$JWTCookieDataCodec$$formatter();
    }

    default public JWTFormatter play$api$mvc$JWTCookieDataCodec$$formatter() {
        return new JWTFormatter(this.secretConfiguration(), this.jwtConfiguration(), this.clock());
    }

    public static /* synthetic */ String encode$(JWTCookieDataCodec $this, scala.collection.immutable.Map data) {
        return $this.encode((scala.collection.immutable.Map<String, String>)data);
    }

    @Override
    default public String encode(scala.collection.immutable.Map<String, String> data) {
        scala.collection.immutable.Map dataMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.jwtConfiguration().dataClaim()), (Object)Jwts.claims(Scala.asJava(data)))}));
        return this.play$api$mvc$JWTCookieDataCodec$$formatter().format((scala.collection.immutable.Map<String, Object>)dataMap);
    }

    public static /* synthetic */ scala.collection.immutable.Map decode$(JWTCookieDataCodec $this, String encodedString) {
        return $this.decode(encodedString);
    }

    @Override
    default public scala.collection.immutable.Map<String, String> decode(String encodedString) {
        scala.collection.immutable.Map map2;
        try {
            scala.collection.immutable.Map<String, Object> claimMap = this.play$api$mvc$JWTCookieDataCodec$$formatter().parse(encodedString);
            Map data = (Map)claimMap.apply((Object)this.jwtConfiguration().dataClaim());
            map2 = ((MapOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(data).asScala()).mapValues((Function1 & Serializable)v -> v.toString()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof IllegalStateException) {
                IllegalStateException illegalStateException = (IllegalStateException)throwable2;
                this.play$api$mvc$JWTCookieDataCodec$$logger().error((Function0<String>)(Function0 & Serializable)() -> illegalStateException.getMessage(), MarkerContext$.MODULE$.NoMarker());
                map2 = Predef$.MODULE$.Map().empty();
            }
            if (throwable2 instanceof PrematureJwtException) {
                PrematureJwtException prematureJwtException = (PrematureJwtException)throwable2;
                String id = prematureJwtException.getClaims().getId();
                this.play$api$mvc$JWTCookieDataCodec$$logger().warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(46).append("decode: premature JWT found! id = ").append(id).append(", message = ").append(prematureJwtException.getMessage()).toString(), MarkerContexts$SecurityMarkerContext$.MODULE$);
                map2 = Predef$.MODULE$.Map().empty();
            }
            if (throwable2 instanceof ExpiredJwtException) {
                ExpiredJwtException expiredJwtException = (ExpiredJwtException)throwable2;
                String id = expiredJwtException.getClaims().getId();
                this.play$api$mvc$JWTCookieDataCodec$$logger().warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("decode: expired JWT found! id = ").append(id).append(", message = ").append(expiredJwtException.getMessage()).toString(), MarkerContexts$SecurityMarkerContext$.MODULE$);
                map2 = Predef$.MODULE$.Map().empty();
            }
            if (throwable2 instanceof SignatureException) {
                SignatureException signatureException = (SignatureException)throwable2;
                this.play$api$mvc$JWTCookieDataCodec$$logger().warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("decode: cookie has invalid signature! message = ").append(signatureException.getMessage()).toString(), MarkerContexts$SecurityMarkerContext$.MODULE$);
                Logger devLogger = this.play$api$mvc$JWTCookieDataCodec$$logger().forMode((Seq<Mode>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Mode[]{Mode$Dev$.MODULE$}));
                devLogger.info((Function0<String>)(Function0 & Serializable)() -> "The JWT signature in the cookie does not match the locally computed signature with the server. This usually indicates the browser has a leftover cookie from another Play application, so clearing cookies may resolve this error message.", MarkerContext$.MODULE$.NoMarker());
                map2 = Predef$.MODULE$.Map().empty();
            }
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.play$api$mvc$JWTCookieDataCodec$$logger().warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("decode: could not decode JWT: ").append(e.getMessage()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e, MarkerContexts$SecurityMarkerContext$.MODULE$);
                map2 = Predef$.MODULE$.Map().empty();
            }
            throw throwable;
        }
        return map2;
    }

    public static /* synthetic */ Option uniqueId$(JWTCookieDataCodec $this) {
        return $this.uniqueId();
    }

    default public Option<String> uniqueId() {
        return new Some((Object)JWTCookieDataCodec$JWTIDGenerator$.MODULE$.generateId());
    }

    public static /* synthetic */ Clock clock$(JWTCookieDataCodec $this) {
        return $this.clock();
    }

    default public Clock clock() {
        return Clock.systemUTC();
    }

    public static void $init$(JWTCookieDataCodec $this) {
        $this.play$api$mvc$JWTCookieDataCodec$_setter_$play$api$mvc$JWTCookieDataCodec$$logger_$eq(Logger$.MODULE$.apply($this.getClass()));
    }

    public static class JWTFormatter {
        private final JWTConfiguration jwtConfiguration;
        public final Clock play$api$mvc$JWTCookieDataCodec$JWTFormatter$$clock;
        private final io.jsonwebtoken.Clock jwtClock;
        private final String base64EncodedSecret;

        private io.jsonwebtoken.Clock jwtClock() {
            return this.jwtClock;
        }

        private String base64EncodedSecret() {
            return this.base64EncodedSecret;
        }

        public scala.collection.immutable.Map<String, Object> parse(String encodedString) {
            String headerAlgorithm;
            Jws jws = Jwts.parser().setClock(this.jwtClock()).setSigningKey(this.base64EncodedSecret()).setAllowedClockSkewSeconds(this.jwtConfiguration.clockSkew().toSeconds()).parseClaimsJws(encodedString);
            String string = headerAlgorithm = ((JwsHeader)jws.getHeader()).getAlgorithm();
            String string2 = this.jwtConfiguration.signatureAlgorithm();
            if (string == null ? string2 != null : !string.equals(string2)) {
                String id = ((Claims)jws.getBody()).getId();
                String msg = new StringBuilder(33).append("Invalid header algorithm ").append(headerAlgorithm).append(" in JWT ").append(id).toString();
                throw new IllegalStateException(msg);
            }
            return ((IterableOnceOps)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)jws.getBody()).asScala()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        public String format(scala.collection.immutable.Map<String, Object> claims) {
            JwtBuilder builder = Jwts.builder();
            Date now = this.jwtClock().now();
            claims.foreach((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    Object v = tuple2._2();
                    return builder.claim(k, v);
                }
                throw new MatchError((Object)tuple2);
            });
            this.jwtConfiguration.expiresAfter().map((Function1 & Serializable)duration -> {
                Date expirationDate = new Date(now.getTime() + duration.toMillis());
                return builder.setExpiration(expirationDate);
            });
            builder.setNotBefore(now);
            builder.setIssuedAt(now);
            SignatureAlgorithm sigAlg = SignatureAlgorithm.valueOf((String)this.jwtConfiguration.signatureAlgorithm());
            return builder.signWith(sigAlg, this.base64EncodedSecret()).compact();
        }

        public JWTFormatter(SecretConfiguration secretConfiguration, JWTConfiguration jwtConfiguration, Clock clock) {
            this.jwtConfiguration = jwtConfiguration;
            this.play$api$mvc$JWTCookieDataCodec$JWTFormatter$$clock = clock;
            this.jwtClock = new io.jsonwebtoken.Clock(this){
                private final /* synthetic */ JWTFormatter $outer;

                public Date now() {
                    return Date.from(this.$outer.play$api$mvc$JWTCookieDataCodec$JWTFormatter$$clock.instant());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
            this.base64EncodedSecret = Base64.getEncoder().encodeToString(secretConfiguration.secret().getBytes(StandardCharsets.UTF_8));
        }
    }
}

