/*
 * Decompiled with CFR 0.152.
 */
package play.core.formatters;

import akka.NotUsed;
import akka.stream.Attributes;
import akka.stream.FlowShape;
import akka.stream.FlowShape$;
import akka.stream.Graph;
import akka.stream.Inlet;
import akka.stream.Inlet$;
import akka.stream.Outlet;
import akka.stream.Outlet$;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import akka.stream.stage.GraphStage;
import akka.stream.stage.GraphStageLogic;
import akka.stream.stage.InHandler;
import akka.stream.stage.OutHandler;
import akka.util.ByteString;
import akka.util.ByteString$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import play.api.mvc.MultipartFormData;
import play.core.formatters.Multipart;
import play.core.formatters.Multipart$;
import play.core.formatters.Multipart$$anon$1$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple4;
import scala.collection.immutable.IndexedSeq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;

public final class Multipart$ {
    public static final Multipart$ MODULE$ = new Multipart$();
    private static final byte[] alphabet = "-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".getBytes(StandardCharsets.US_ASCII);

    private String CrLf() {
        return "\r\n";
    }

    public Source<ByteString, ?> transform(Source<MultipartFormData.Part<Source<ByteString, ?>>, ?> body, String boundary) {
        return body.via(this.format(boundary, Charset.defaultCharset(), 4096));
    }

    public Flow<MultipartFormData.Part<Source<ByteString, ?>>, ByteString, NotUsed> format(String boundary, Charset nioCharset, int chunkSize) {
        return (Flow)Flow$.MODULE$.apply().via(this.streamed(boundary, nioCharset, chunkSize)).flatMapConcat((Function1 & Serializable)x -> (Source)Predef$.MODULE$.identity(x));
    }

    public String randomBoundary(int length, Random random) {
        if (length < 1 || length > 70) {
            throw new IllegalArgumentException("length can't be greater than 70 or less than 1");
        }
        IndexedSeq bytes = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), length).map((Function1 & Serializable)object -> BoxesRunTime.boxToByte((byte)Multipart$.$anonfun$randomBoundary$1(random, BoxesRunTime.unboxToInt((Object)object))));
        return new String((byte[])bytes.toArray((ClassTag)ClassTag$.MODULE$.Byte()), StandardCharsets.US_ASCII);
    }

    public int randomBoundary$default$1() {
        return 18;
    }

    public Random randomBoundary$default$2() {
        return ThreadLocalRandom.current();
    }

    public String escapeParamWithHTML5Strategy(String value) {
        return value.replace("\"", "%22").replace("\r", "%0D").replace("\n", "%0A");
    }

    private GraphStage<FlowShape<MultipartFormData.Part<Source<ByteString, ?>>, Source<ByteString, Object>>> streamed(String boundary, Charset nioCharset, int chunkSize) {
        return new GraphStage<FlowShape<MultipartFormData.Part<Source<ByteString, ?>>, Source<ByteString, Object>>>(nioCharset, chunkSize, boundary){
            private final Inlet<MultipartFormData.Part<Source<ByteString, ?>>> play$core$formatters$Multipart$$anon$$in;
            private final Outlet<Source<ByteString, Object>> play$core$formatters$Multipart$$anon$$out;
            public final Charset nioCharset$1;
            public final int chunkSize$1;
            public final String boundary$1;

            public Inlet<MultipartFormData.Part<Source<ByteString, ?>>> play$core$formatters$Multipart$$anon$$in() {
                return this.play$core$formatters$Multipart$$anon$$in;
            }

            public Outlet<Source<ByteString, Object>> play$core$formatters$Multipart$$anon$$out() {
                return this.play$core$formatters$Multipart$$anon$$out;
            }

            public FlowShape<MultipartFormData.Part<Source<ByteString, ?>>, Source<ByteString, Object>> shape() {
                return FlowShape$.MODULE$.of(this.play$core$formatters$Multipart$$anon$$in(), this.play$core$formatters$Multipart$$anon$$out());
            }

            public GraphStageLogic createLogic(Attributes inheritedAttributes) {
                return new OutHandler(this){
                    private boolean firstBoundaryRendered;
                    private final /* synthetic */ anon.1 $outer;

                    public void onUpstreamFailure(Throwable ex) throws Exception {
                        InHandler.onUpstreamFailure$((InHandler)this, (Throwable)ex);
                    }

                    public void onDownstreamFinish() throws Exception {
                        OutHandler.onDownstreamFinish$((OutHandler)this);
                    }

                    public void onDownstreamFinish(Throwable cause) throws Exception {
                        OutHandler.onDownstreamFinish$((OutHandler)this, (Throwable)cause);
                    }

                    private boolean firstBoundaryRendered() {
                        return this.firstBoundaryRendered;
                    }

                    private void firstBoundaryRendered_$eq(boolean x$1) {
                        this.firstBoundaryRendered = x$1;
                    }

                    public void onPush() {
                        Tuple4 tuple4;
                        Multipart.CustomCharsetByteStringFormatter f = new Multipart.CustomCharsetByteStringFormatter(this.$outer.nioCharset$1, this.$outer.chunkSize$1);
                        MultipartFormData.Part bodyPart = (MultipartFormData.Part)this.grab(this.$outer.play$core$formatters$Multipart$$anon$$in());
                        Multipart$.MODULE$.play$core$formatters$Multipart$$renderBoundary(f, this.$outer.boundary$1, !this.firstBoundaryRendered());
                        this.firstBoundaryRendered_$eq(true);
                        MultipartFormData.Part part = bodyPart;
                        if (part instanceof MultipartFormData.DataPart) {
                            MultipartFormData.DataPart dataPart = (MultipartFormData.DataPart)part;
                            String innerKey = dataPart.key();
                            tuple4 = new Tuple4((Object)innerKey, (Object)None$.MODULE$, (Object)Option$.MODULE$.apply((Object)"text/plain"), (Object)"form-data");
                        } else if (part instanceof MultipartFormData.FilePart) {
                            MultipartFormData.FilePart filePart = (MultipartFormData.FilePart)part;
                            String innerKey = filePart.key();
                            String innerFilename = filePart.filename();
                            Option<String> innerContentType = filePart.contentType();
                            String innerDispositionType = filePart.dispositionType();
                            tuple4 = new Tuple4((Object)innerKey, (Object)Option$.MODULE$.apply((Object)innerFilename), innerContentType, (Object)innerDispositionType);
                        } else {
                            throw new UnsupportedOperationException();
                        }
                        Tuple4 tuple42 = tuple4;
                        if (tuple42 == null) {
                            throw new MatchError((Object)tuple42);
                        }
                        String key = (String)tuple42._1();
                        Option filename = (Option)tuple42._2();
                        Option contentType = (Option)tuple42._3();
                        String dispositionType = (String)tuple42._4();
                        Tuple4 tuple43 = new Tuple4((Object)key, (Object)filename, (Object)contentType, (Object)dispositionType);
                        String key2 = (String)tuple43._1();
                        Option filename2 = (Option)tuple43._2();
                        Option contentType2 = (Option)tuple43._3();
                        String dispositionType2 = (String)tuple43._4();
                        Multipart$.MODULE$.play$core$formatters$Multipart$$renderDisposition(f, dispositionType2, key2, (Option<String>)filename2);
                        contentType2.foreach((Function1 & Serializable)ct -> {
                            anon$1$$anon$2.$anonfun$onPush$2(f, ct);
                            return BoxedUnit.UNIT;
                        });
                        Multipart$.MODULE$.play$core$formatters$Multipart$$renderBuffer(f);
                        this.push(this.$outer.play$core$formatters$Multipart$$anon$$out(), anon$1$$anon$2.completePartFormatting$1(bodyPart, f));
                    }

                    public void onPull() {
                        boolean finishing = this.isClosed(this.$outer.play$core$formatters$Multipart$$anon$$in());
                        if (finishing && this.firstBoundaryRendered()) {
                            Multipart.ByteStringFormatter f = new Multipart.ByteStringFormatter(this.$outer.boundary$1.length() + 4);
                            Multipart$.MODULE$.play$core$formatters$Multipart$$renderFinalBoundary(f, this.$outer.boundary$1);
                            this.push(this.$outer.play$core$formatters$Multipart$$anon$$out(), Source$.MODULE$.single((Object)f.get()));
                            this.completeStage();
                            return;
                        }
                        if (finishing) {
                            this.completeStage();
                            return;
                        }
                        this.pull(this.$outer.play$core$formatters$Multipart$$anon$$in());
                    }

                    public void onUpstreamFinish() {
                        if (this.isAvailable(this.$outer.play$core$formatters$Multipart$$anon$$out())) {
                            this.onPull();
                            return;
                        }
                    }

                    public static final /* synthetic */ void $anonfun$onPush$1(NotUsed x$1) {
                    }

                    private static final Source bodyPartChunks$1(Source data, Multipart.CustomCharsetByteStringFormatter f$1) {
                        return ((Source)Source$.MODULE$.single((Object)f$1.get()).$plus$plus((Graph)data)).mapMaterializedValue((Function1 & Serializable)x$1 -> {
                            anon$1$$anon$2.$anonfun$onPush$1(x$1);
                            return BoxedUnit.UNIT;
                        });
                    }

                    private static final Source completePartFormatting$1(MultipartFormData.Part bodyPart$1, Multipart.CustomCharsetByteStringFormatter f$1) {
                        MultipartFormData.Part part = bodyPart$1;
                        if (part instanceof MultipartFormData.DataPart) {
                            MultipartFormData.DataPart dataPart = (MultipartFormData.DataPart)part;
                            String data = dataPart.value();
                            return Source$.MODULE$.single((Object)f$1.$tilde$tilde(ByteString$.MODULE$.apply(data)).get());
                        }
                        if (part instanceof MultipartFormData.FilePart) {
                            MultipartFormData.FilePart filePart = (MultipartFormData.FilePart)part;
                            Source ref = (Source)filePart.ref();
                            return anon$1$$anon$2.bodyPartChunks$1(ref, f$1);
                        }
                        throw new UnsupportedOperationException();
                    }

                    public static final /* synthetic */ void $anonfun$onPush$2(Multipart.CustomCharsetByteStringFormatter f$1, String ct) {
                        Multipart$.MODULE$.play$core$formatters$Multipart$$renderContentType(f$1, ct);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        super($outer.shape());
                        OutHandler.$init$((OutHandler)this);
                        InHandler.$init$((InHandler)this);
                        this.firstBoundaryRendered = false;
                        this.setHandlers($outer.play$core$formatters$Multipart$$anon$$in(), $outer.play$core$formatters$Multipart$$anon$$out(), this);
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onPush$1$adapted(akka.NotUsed ), $anonfun$onPush$2$adapted(play.core.formatters.Multipart$CustomCharsetByteStringFormatter java.lang.String )}, serializedLambda);
                    }
                };
            }
            {
                this.nioCharset$1 = nioCharset$1;
                this.chunkSize$1 = chunkSize$1;
                this.boundary$1 = boundary$1;
                this.play$core$formatters$Multipart$$anon$$in = Inlet$.MODULE$.apply("CustomCharsetByteStringFormatter.in");
                this.play$core$formatters$Multipart$$anon$$out = Outlet$.MODULE$.apply("CustomCharsetByteStringFormatter.out");
            }
        };
    }

    public void play$core$formatters$Multipart$$renderBoundary(Multipart.Formatter f, String boundary, boolean suppressInitialCrLf) {
        Object object = !suppressInitialCrLf ? f.$tilde$tilde(this.CrLf()) : BoxedUnit.UNIT;
        f.$tilde$tilde('-').$tilde$tilde('-').$tilde$tilde(boundary).$tilde$tilde(this.CrLf());
    }

    private boolean renderBoundary$default$3() {
        return false;
    }

    public void play$core$formatters$Multipart$$renderFinalBoundary(Multipart.Formatter f, String boundary) {
        f.$tilde$tilde(this.CrLf()).$tilde$tilde('-').$tilde$tilde('-').$tilde$tilde(boundary).$tilde$tilde('-').$tilde$tilde('-');
    }

    public void play$core$formatters$Multipart$$renderDisposition(Multipart.Formatter f, String dispositionType, String contentDisposition, Option<String> filename) {
        f.$tilde$tilde("Content-Disposition: ").$tilde$tilde(dispositionType).$tilde$tilde("; name=").$tilde$tilde('\"').$tilde$tilde(this.escapeParamWithHTML5Strategy(contentDisposition)).$tilde$tilde('\"');
        filename.foreach((Function1 & Serializable)name -> f.$tilde$tilde("; filename=").$tilde$tilde('\"').$tilde$tilde(MODULE$.escapeParamWithHTML5Strategy((String)name)).$tilde$tilde('\"'));
        f.$tilde$tilde(this.CrLf());
    }

    public void play$core$formatters$Multipart$$renderContentType(Multipart.Formatter f, String contentType) {
        f.$tilde$tilde("Content-Type: ").$tilde$tilde(contentType).$tilde$tilde(this.CrLf());
    }

    public void play$core$formatters$Multipart$$renderBuffer(Multipart.Formatter f) {
        f.$tilde$tilde(this.CrLf());
    }

    public static final /* synthetic */ byte $anonfun$randomBoundary$1(Random random$1, int n) {
        return alphabet[random$1.nextInt(alphabet.length)];
    }

    private Multipart$() {
    }
}

