/*
 * Decompiled with CFR 0.152.
 */
package play.libs.concurrent;

import akka.Done;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import play.libs.Scala;
import play.libs.concurrent.Futures;
import scala.compat.java8.FutureConverters;
import scala.concurrent.duration.FiniteDuration;

public class DefaultFutures
implements Futures {
    private final play.api.libs.concurrent.Futures delegate;

    @Inject
    public DefaultFutures(play.api.libs.concurrent.Futures futures) {
        this.delegate = futures;
    }

    @Override
    public <A> CompletionStage<A> timeout(CompletionStage<A> completionStage, long l, TimeUnit timeUnit) {
        Objects.requireNonNull(completionStage, "Null stage");
        Objects.requireNonNull(timeUnit, "Null unit");
        FiniteDuration finiteDuration = FiniteDuration.apply((long)l, (TimeUnit)timeUnit);
        return FutureConverters.toJava(this.delegate.timeout(finiteDuration, Scala.asScalaWithFuture(() -> completionStage)));
    }

    @Override
    public <A> CompletionStage<A> timeout(CompletionStage<A> completionStage, Duration duration) {
        Objects.requireNonNull(completionStage, "Null stage");
        Objects.requireNonNull(duration, "Null duration");
        FiniteDuration finiteDuration = FiniteDuration.apply((long)duration.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
        return FutureConverters.toJava(this.delegate.timeout(finiteDuration, Scala.asScalaWithFuture(() -> completionStage)));
    }

    @Override
    public <A> CompletionStage<A> delayed(Callable<CompletionStage<A>> callable, long l, TimeUnit timeUnit) {
        Objects.requireNonNull(callable, "Null callable");
        Objects.requireNonNull(Long.valueOf(l), "Null amount");
        Objects.requireNonNull(timeUnit, "Null unit");
        FiniteDuration finiteDuration = FiniteDuration.apply((long)l, (TimeUnit)timeUnit);
        return FutureConverters.toJava(this.delegate.delayed(finiteDuration, Scala.asScalaWithFuture(callable)));
    }

    @Override
    public CompletionStage<Done> delay(Duration duration) {
        FiniteDuration finiteDuration = FiniteDuration.apply((long)duration.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
        return FutureConverters.toJava(this.delegate.delay(finiteDuration));
    }

    @Override
    public CompletionStage<Done> delay(long l, TimeUnit timeUnit) {
        FiniteDuration finiteDuration = FiniteDuration.apply((long)l, (TimeUnit)timeUnit);
        return FutureConverters.toJava(this.delegate.delay(finiteDuration));
    }

    @Override
    public <A> CompletionStage<A> delayed(Callable<CompletionStage<A>> callable, Duration duration) {
        Objects.requireNonNull(callable, "Null callable");
        Objects.requireNonNull(duration, "Null duration");
        FiniteDuration finiteDuration = FiniteDuration.apply((long)duration.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
        return FutureConverters.toJava(this.delegate.delayed(finiteDuration, Scala.asScalaWithFuture(callable)));
    }
}

