/*
 * Decompiled with CFR 0.152.
 */
package play.mvc;

import akka.japi.function.Function;
import akka.stream.javadsl.Source;
import akka.util.ByteString;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.concurrent.ThreadLocalRandom;
import play.api.mvc.MultipartFormData;
import play.core.formatters.Multipart;
import play.mvc.Http;
import scala.Option;

public class MultipartFormatter {
    public static String randomBoundary() {
        return Multipart.randomBoundary(18, ThreadLocalRandom.current());
    }

    public static String boundaryToContentType(String string) {
        return "multipart/form-data; boundary=" + string;
    }

    public static Source<ByteString, ?> transform(Source<? super Http.MultipartFormData.Part<Source<ByteString, ?>>, ?> source, String string) {
        Source source2 = source.map((Function & Serializable)object -> {
            if (object instanceof Http.MultipartFormData.DataPart) {
                Http.MultipartFormData.DataPart dataPart = (Http.MultipartFormData.DataPart)object;
                return new MultipartFormData.DataPart(dataPart.getKey(), dataPart.getValue());
            }
            if (object instanceof Http.MultipartFormData.FilePart) {
                Http.MultipartFormData.FilePart filePart = (Http.MultipartFormData.FilePart)object;
                if (filePart.ref instanceof Source) {
                    Source source = (Source)filePart.ref;
                    Option option = Option.apply((Object)filePart.getContentType());
                    return new MultipartFormData.FilePart<akka.stream.scaladsl.Source>(filePart.getKey(), filePart.getFilename(), (Option<String>)option, source.asScala(), filePart.getFileSize(), filePart.getDispositionType());
                }
            }
            throw new UnsupportedOperationException("Unsupported Part Class");
        });
        return source2.via(Multipart.format(string, Charset.defaultCharset(), 4096));
    }
}

