/*
 * Decompiled with CFR 0.152.
 */
package play.mvc;

import akka.annotation.ApiMayChange;
import akka.stream.javadsl.Source;
import akka.util.ByteString;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.LongFunction;
import play.core.j.JavaRangeResult;
import play.mvc.FileMimeTypes;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.StaticFileMimeTypes;

public class RangeResults {
    private static Optional<String> rangeHeader(Http.Request request) {
        return request.header("Range");
    }

    public static Result ofStream(Http.Request request, InputStream inputStream) {
        return JavaRangeResult.ofStream(inputStream, RangeResults.rangeHeader(request), null, Optional.empty());
    }

    public static Result ofStream(Http.Request request, InputStream inputStream, long l) {
        return JavaRangeResult.ofStream(l, inputStream, RangeResults.rangeHeader(request), null, Optional.empty());
    }

    public static Result ofStream(Http.Request request, InputStream inputStream, long l, String string) {
        return JavaRangeResult.ofStream(l, inputStream, RangeResults.rangeHeader(request), string, Optional.empty());
    }

    public static Result ofStream(Http.Request request, InputStream inputStream, long l, String string, String string2) {
        return JavaRangeResult.ofStream(l, inputStream, RangeResults.rangeHeader(request), string, Optional.ofNullable(string2));
    }

    public static Result ofPath(Http.Request request, Path path) {
        return RangeResults.ofPath(request, path, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result ofPath(Http.Request request, Path path, FileMimeTypes fileMimeTypes) {
        return JavaRangeResult.ofPath(path, RangeResults.rangeHeader(request), fileMimeTypes.forFileName(path.toFile().getName()));
    }

    public static Result ofPath(Http.Request request, Path path, String string) {
        return RangeResults.ofPath(request, path, string, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result ofPath(Http.Request request, Path path, String string, FileMimeTypes fileMimeTypes) {
        return JavaRangeResult.ofPath(path, RangeResults.rangeHeader(request), string, fileMimeTypes.forFileName(string));
    }

    public static Result ofFile(Http.Request request, File file) {
        return RangeResults.ofFile(request, file, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result ofFile(Http.Request request, File file, FileMimeTypes fileMimeTypes) {
        return JavaRangeResult.ofFile(file, RangeResults.rangeHeader(request), fileMimeTypes.forFileName(file.getName()));
    }

    public static Result ofFile(Http.Request request, File file, String string) {
        return RangeResults.ofFile(request, file, string, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result ofFile(Http.Request request, File file, String string, FileMimeTypes fileMimeTypes) {
        return JavaRangeResult.ofFile(file, RangeResults.rangeHeader(request), string, fileMimeTypes.forFileName(string));
    }

    public static Result ofSource(Http.Request request, Long l, Source<ByteString, ?> source, String string, String string2) {
        return JavaRangeResult.ofSource(l, source, RangeResults.rangeHeader(request), Optional.ofNullable(string), Optional.ofNullable(string2));
    }

    @ApiMayChange
    public static Result ofSource(Http.Request request, Long l, SourceFunction sourceFunction, String string, String string2) {
        return JavaRangeResult.ofSource(Optional.of(l), sourceFunction, RangeResults.rangeHeader(request), Optional.ofNullable(string), Optional.ofNullable(string2));
    }

    @ApiMayChange
    public static interface SourceFunction
    extends LongFunction<SourceAndOffset> {
    }

    @ApiMayChange
    public static class SourceAndOffset {
        private final long offset;
        private final Source<ByteString, ?> source;

        public SourceAndOffset(long l, Source<ByteString, ?> source) {
            this.offset = l;
            this.source = source;
        }

        public long getOffset() {
            return this.offset;
        }

        public Source<ByteString, ?> getSource() {
            return this.source;
        }
    }
}

