/*
 * Decompiled with CFR 0.152.
 */
package play.mvc;

import akka.japi.function.Creator;
import akka.japi.function.Function;
import akka.stream.IOResult;
import akka.stream.javadsl.FileIO;
import akka.stream.javadsl.Source;
import akka.stream.javadsl.StreamConverters;
import akka.util.ByteString;
import akka.util.ByteString$;
import akka.util.ByteStringBuilder;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import play.http.HttpEntity;
import play.libs.Json;
import play.mvc.FileMimeTypes;
import play.mvc.Result;
import play.mvc.Results;
import play.mvc.StaticFileMimeTypes;

public class StatusHeader
extends Result {
    private static final int DEFAULT_CHUNK_SIZE = 8192;
    private static final boolean DEFAULT_INLINE_MODE = true;

    public StatusHeader(int n) {
        super(n);
    }

    public Result sendInputStream(InputStream inputStream) {
        return this.sendInputStream(inputStream, () -> {}, null);
    }

    public Result sendInputStream(InputStream inputStream, Runnable runnable, Executor executor) {
        return this.sendInputStream(inputStream, Optional.empty(), runnable, executor);
    }

    public Result sendInputStream(InputStream inputStream, Optional<String> optional) {
        return this.sendInputStream(inputStream, optional, () -> {}, null);
    }

    public Result sendInputStream(InputStream inputStream, Optional<String> optional, Runnable runnable, Executor executor) {
        if (inputStream == null) {
            throw new NullPointerException("Null stream");
        }
        return new Result(this.status(), HttpEntity.chunked(StatusHeader.attachOnClose((Source<ByteString, CompletionStage<IOResult>>)StreamConverters.fromInputStream((Creator & Serializable)() -> inputStream, (int)8192), runnable, executor), optional));
    }

    public Result sendInputStream(InputStream inputStream, long l) {
        return this.sendInputStream(inputStream, l, () -> {}, null);
    }

    public Result sendInputStream(InputStream inputStream, long l, Runnable runnable, Executor executor) {
        return this.sendInputStream(inputStream, l, Optional.empty(), runnable, executor);
    }

    public Result sendInputStream(InputStream inputStream, long l, Optional<String> optional) {
        return this.sendInputStream(inputStream, l, optional, () -> {}, null);
    }

    public Result sendInputStream(InputStream inputStream, long l, Optional<String> optional, Runnable runnable, Executor executor) {
        if (inputStream == null) {
            throw new NullPointerException("Null stream");
        }
        return new Result(this.status(), (HttpEntity)new HttpEntity.Streamed(StatusHeader.attachOnClose((Source<ByteString, CompletionStage<IOResult>>)StreamConverters.fromInputStream((Creator & Serializable)() -> inputStream, (int)8192), runnable, executor), Optional.of(l), optional));
    }

    public Result sendBytes(byte[] byArray) {
        return this.sendBytes(byArray, Optional.empty());
    }

    public Result sendBytes(byte[] byArray, Optional<String> optional) {
        return new Result(this.status(), (HttpEntity)new HttpEntity.Strict(ByteString.fromArray((byte[])byArray), optional));
    }

    public Result sendBytes(byte[] byArray, boolean bl, Optional<String> optional) {
        return this.sendBytes(byArray, bl, optional, StaticFileMimeTypes.fileMimeTypes());
    }

    public Result sendBytes(byte[] byArray, boolean bl, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return new Result(this.status(), Results.contentDispositionHeader(bl, optional), new HttpEntity.Strict(ByteString.fromArray((byte[])byArray), optional.map(string -> fileMimeTypes.forFileName((String)string).orElse("application/octet-stream"))));
    }

    public Result sendByteString(ByteString byteString) {
        return this.sendByteString(byteString, Optional.empty());
    }

    public Result sendByteString(ByteString byteString, Optional<String> optional) {
        return new Result(this.status(), (HttpEntity)new HttpEntity.Strict(byteString, optional));
    }

    public Result sendByteString(ByteString byteString, boolean bl, Optional<String> optional) {
        return this.sendByteString(byteString, bl, optional, StaticFileMimeTypes.fileMimeTypes());
    }

    public Result sendByteString(ByteString byteString, boolean bl, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return new Result(this.status(), Results.contentDispositionHeader(bl, optional), new HttpEntity.Strict(byteString, optional.map(string -> fileMimeTypes.forFileName((String)string).orElse("application/octet-stream"))));
    }

    public Result sendResource(String string) {
        return this.sendResource(string, () -> {}, null);
    }

    public Result sendResource(String string, Runnable runnable, Executor executor) {
        return this.sendResource(string, StaticFileMimeTypes.fileMimeTypes(), runnable, executor);
    }

    public Result sendResource(String string, FileMimeTypes fileMimeTypes) {
        return this.sendResource(string, fileMimeTypes, () -> {}, null);
    }

    public Result sendResource(String string, FileMimeTypes fileMimeTypes, Runnable runnable, Executor executor) {
        return this.sendResource(string, true, fileMimeTypes, runnable, executor);
    }

    public Result sendResource(String string, ClassLoader classLoader) {
        return this.sendResource(string, classLoader, () -> {}, null);
    }

    public Result sendResource(String string, ClassLoader classLoader, Runnable runnable, Executor executor) {
        return this.sendResource(string, classLoader, StaticFileMimeTypes.fileMimeTypes(), runnable, executor);
    }

    public Result sendResource(String string, ClassLoader classLoader, Optional<String> optional) {
        return this.sendResource(string, classLoader, optional, () -> {}, null);
    }

    public Result sendResource(String string, ClassLoader classLoader, Optional<String> optional, Runnable runnable, Executor executor) {
        return this.sendResource(string, classLoader, optional, StaticFileMimeTypes.fileMimeTypes(), runnable, executor);
    }

    public Result sendResource(String string, ClassLoader classLoader, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return this.sendResource(string, classLoader, optional, fileMimeTypes, () -> {}, null);
    }

    public Result sendResource(String string, ClassLoader classLoader, Optional<String> optional, FileMimeTypes fileMimeTypes, Runnable runnable, Executor executor) {
        return this.sendResource(string, classLoader, true, optional, fileMimeTypes, runnable, executor);
    }

    public Result sendResource(String string, ClassLoader classLoader, FileMimeTypes fileMimeTypes) {
        return this.sendResource(string, classLoader, fileMimeTypes, () -> {}, null);
    }

    public Result sendResource(String string, ClassLoader classLoader, FileMimeTypes fileMimeTypes, Runnable runnable, Executor executor) {
        return this.sendResource(string, classLoader, true, fileMimeTypes, runnable, executor);
    }

    public Result sendResource(String string, Optional<String> optional) {
        return this.sendResource(string, optional, () -> {}, null);
    }

    public Result sendResource(String string, Optional<String> optional, Runnable runnable, Executor executor) {
        return this.sendResource(string, optional, StaticFileMimeTypes.fileMimeTypes(), runnable, executor);
    }

    public Result sendResource(String string, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return this.sendResource(string, optional, fileMimeTypes, () -> {}, null);
    }

    public Result sendResource(String string, Optional<String> optional, FileMimeTypes fileMimeTypes, Runnable runnable, Executor executor) {
        return this.sendResource(string, true, optional, fileMimeTypes, runnable, executor);
    }

    public Result sendResource(String string, boolean bl) {
        return this.sendResource(string, bl, () -> {}, null);
    }

    public Result sendResource(String string, boolean bl, Runnable runnable, Executor executor) {
        return this.sendResource(string, bl, StaticFileMimeTypes.fileMimeTypes(), runnable, executor);
    }

    public Result sendResource(String string, boolean bl, FileMimeTypes fileMimeTypes) {
        return this.sendResource(string, bl, fileMimeTypes, () -> {}, null);
    }

    public Result sendResource(String string, boolean bl, FileMimeTypes fileMimeTypes, Runnable runnable, Executor executor) {
        return this.sendResource(string, this.getClass().getClassLoader(), bl, fileMimeTypes, runnable, executor);
    }

    public Result sendResource(String string, ClassLoader classLoader, boolean bl) {
        return this.sendResource(string, classLoader, bl, () -> {}, null);
    }

    public Result sendResource(String string, ClassLoader classLoader, boolean bl, Runnable runnable, Executor executor) {
        return this.sendResource(string, classLoader, bl, StaticFileMimeTypes.fileMimeTypes(), runnable, executor);
    }

    public Result sendResource(String string, ClassLoader classLoader, boolean bl, FileMimeTypes fileMimeTypes) {
        return this.sendResource(string, classLoader, bl, fileMimeTypes, () -> {}, null);
    }

    public Result sendResource(String string, ClassLoader classLoader, boolean bl, FileMimeTypes fileMimeTypes, Runnable runnable, Executor executor) {
        return this.sendResource(string, classLoader, bl, Optional.ofNullable(string), fileMimeTypes, runnable, executor);
    }

    @Deprecated
    public Result sendResource(String string, boolean bl, String string2) {
        return this.sendResource(string, bl, Optional.ofNullable(string2));
    }

    public Result sendResource(String string, boolean bl, Optional<String> optional) {
        return this.sendResource(string, bl, optional, () -> {}, null);
    }

    public Result sendResource(String string, boolean bl, Optional<String> optional, Runnable runnable, Executor executor) {
        return this.sendResource(string, bl, optional, StaticFileMimeTypes.fileMimeTypes(), runnable, executor);
    }

    @Deprecated
    public Result sendResource(String string, boolean bl, String string2, FileMimeTypes fileMimeTypes) {
        return this.sendResource(string, bl, Optional.ofNullable(string2), fileMimeTypes);
    }

    public Result sendResource(String string, boolean bl, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return this.sendResource(string, bl, optional, fileMimeTypes, () -> {}, null);
    }

    public Result sendResource(String string, boolean bl, Optional<String> optional, FileMimeTypes fileMimeTypes, Runnable runnable, Executor executor) {
        return this.sendResource(string, this.getClass().getClassLoader(), bl, optional, fileMimeTypes, runnable, executor);
    }

    @Deprecated
    public Result sendResource(String string, ClassLoader classLoader, boolean bl, String string2) {
        return this.sendResource(string, classLoader, bl, Optional.ofNullable(string2));
    }

    public Result sendResource(String string, ClassLoader classLoader, boolean bl, Optional<String> optional) {
        return this.sendResource(string, classLoader, bl, optional, () -> {}, null);
    }

    public Result sendResource(String string, ClassLoader classLoader, boolean bl, Optional<String> optional, Runnable runnable, Executor executor) {
        return this.sendResource(string, classLoader, bl, optional, StaticFileMimeTypes.fileMimeTypes(), runnable, executor);
    }

    @Deprecated
    public Result sendResource(String string, ClassLoader classLoader, boolean bl, String string2, FileMimeTypes fileMimeTypes) {
        return this.sendResource(string, classLoader, bl, Optional.ofNullable(string2), fileMimeTypes);
    }

    public Result sendResource(String string, ClassLoader classLoader, boolean bl, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return this.sendResource(string, classLoader, bl, optional, fileMimeTypes, () -> {}, null);
    }

    public Result sendResource(String string, ClassLoader classLoader, boolean bl, Optional<String> optional, FileMimeTypes fileMimeTypes, Runnable runnable, Executor executor) {
        return this.doSendResource((Source<ByteString, CompletionStage<IOResult>>)StreamConverters.fromInputStream((Creator & Serializable)() -> classLoader.getResourceAsStream(string)), Optional.empty(), optional, bl, fileMimeTypes, runnable, executor);
    }

    public Result sendPath(Path path) {
        return this.sendPath(path, () -> {}, null);
    }

    public Result sendPath(Path path, Runnable runnable, Executor executor) {
        return this.sendPath(path, StaticFileMimeTypes.fileMimeTypes(), runnable, executor);
    }

    public Result sendPath(Path path, FileMimeTypes fileMimeTypes) {
        return this.sendPath(path, fileMimeTypes, () -> {}, null);
    }

    public Result sendPath(Path path, FileMimeTypes fileMimeTypes, Runnable runnable, Executor executor) {
        return this.sendPath(path, true, fileMimeTypes, runnable, executor);
    }

    public Result sendPath(Path path, boolean bl) {
        return this.sendPath(path, bl, () -> {}, null);
    }

    public Result sendPath(Path path, boolean bl, Runnable runnable, Executor executor) {
        return this.sendPath(path, bl, StaticFileMimeTypes.fileMimeTypes(), runnable, executor);
    }

    public Result sendPath(Path path, boolean bl, FileMimeTypes fileMimeTypes) {
        return this.sendPath(path, bl, fileMimeTypes, () -> {}, null);
    }

    public Result sendPath(Path path2, boolean bl, FileMimeTypes fileMimeTypes, Runnable runnable, Executor executor) {
        return this.sendPath(path2, bl, Optional.ofNullable(path2).map(path -> path.getFileName().toString()), fileMimeTypes, runnable, executor);
    }

    @Deprecated
    public Result sendPath(Path path, String string) {
        return this.sendPath(path, Optional.ofNullable(string));
    }

    public Result sendPath(Path path, Optional<String> optional) {
        return this.sendPath(path, optional, () -> {}, null);
    }

    public Result sendPath(Path path, Optional<String> optional, Runnable runnable, Executor executor) {
        return this.sendPath(path, optional, StaticFileMimeTypes.fileMimeTypes(), runnable, executor);
    }

    @Deprecated
    public Result sendPath(Path path, String string, FileMimeTypes fileMimeTypes) {
        return this.sendPath(path, Optional.ofNullable(string), fileMimeTypes);
    }

    public Result sendPath(Path path, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return this.sendPath(path, optional, fileMimeTypes, () -> {}, null);
    }

    public Result sendPath(Path path, Optional<String> optional, FileMimeTypes fileMimeTypes, Runnable runnable, Executor executor) {
        return this.sendPath(path, true, optional, fileMimeTypes, runnable, executor);
    }

    @Deprecated
    public Result sendPath(Path path, boolean bl, String string) {
        return this.sendPath(path, bl, Optional.ofNullable(string));
    }

    public Result sendPath(Path path, boolean bl, Optional<String> optional) {
        return this.sendPath(path, bl, optional, () -> {}, null);
    }

    public Result sendPath(Path path, boolean bl, Optional<String> optional, Runnable runnable, Executor executor) {
        return this.sendPath(path, bl, optional, StaticFileMimeTypes.fileMimeTypes(), runnable, executor);
    }

    @Deprecated
    public Result sendPath(Path path, boolean bl, String string, FileMimeTypes fileMimeTypes) {
        return this.sendPath(path, bl, Optional.ofNullable(string), fileMimeTypes);
    }

    public Result sendPath(Path path, boolean bl, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return this.sendPath(path, bl, optional, fileMimeTypes, () -> {}, null);
    }

    public Result sendPath(Path path, boolean bl, Optional<String> optional, FileMimeTypes fileMimeTypes, Runnable runnable, Executor executor) {
        if (path == null) {
            throw new NullPointerException("null content");
        }
        try {
            return this.doSendResource((Source<ByteString, CompletionStage<IOResult>>)FileIO.fromPath((Path)path), Optional.of(Files.size(path)), optional, bl, fileMimeTypes, runnable, executor);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public Result sendFile(File file) {
        return this.sendFile(file, () -> {}, null);
    }

    public Result sendFile(File file, Runnable runnable, Executor executor) {
        return this.sendFile(file, StaticFileMimeTypes.fileMimeTypes(), runnable, executor);
    }

    public Result sendFile(File file, FileMimeTypes fileMimeTypes) {
        return this.sendFile(file, fileMimeTypes, () -> {}, null);
    }

    public Result sendFile(File file, FileMimeTypes fileMimeTypes, Runnable runnable, Executor executor) {
        return this.sendFile(file, true, fileMimeTypes, runnable, executor);
    }

    public Result sendFile(File file, boolean bl) {
        return this.sendFile(file, bl, () -> {}, null);
    }

    public Result sendFile(File file, boolean bl, Runnable runnable, Executor executor) {
        return this.sendFile(file, bl, StaticFileMimeTypes.fileMimeTypes(), runnable, executor);
    }

    public Result sendFile(File file, boolean bl, FileMimeTypes fileMimeTypes) {
        return this.sendFile(file, bl, fileMimeTypes, () -> {}, null);
    }

    public Result sendFile(File file2, boolean bl, FileMimeTypes fileMimeTypes, Runnable runnable, Executor executor) {
        if (file2 == null) {
            throw new NullPointerException("null file");
        }
        return this.sendFile(file2, bl, Optional.ofNullable(file2).map(file -> file.getName()), fileMimeTypes, runnable, executor);
    }

    @Deprecated
    public Result sendFile(File file, String string) {
        return this.sendFile(file, Optional.ofNullable(string));
    }

    public Result sendFile(File file, Optional<String> optional) {
        return this.sendFile(file, optional, () -> {}, null);
    }

    public Result sendFile(File file, Optional<String> optional, Runnable runnable, Executor executor) {
        return this.sendFile(file, optional, StaticFileMimeTypes.fileMimeTypes(), runnable, executor);
    }

    @Deprecated
    public Result sendFile(File file, String string, FileMimeTypes fileMimeTypes) {
        return this.sendFile(file, Optional.ofNullable(string), fileMimeTypes);
    }

    public Result sendFile(File file, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return this.sendFile(file, optional, fileMimeTypes, () -> {}, null);
    }

    public Result sendFile(File file, Optional<String> optional, FileMimeTypes fileMimeTypes, Runnable runnable, Executor executor) {
        return this.sendFile(file, true, optional, fileMimeTypes, runnable, executor);
    }

    @Deprecated
    public Result sendFile(File file, boolean bl, String string) {
        return this.sendFile(file, bl, Optional.ofNullable(string));
    }

    public Result sendFile(File file, boolean bl, Optional<String> optional) {
        return this.sendFile(file, bl, optional, () -> {}, null);
    }

    public Result sendFile(File file, boolean bl, Optional<String> optional, Runnable runnable, Executor executor) {
        return this.sendFile(file, bl, optional, StaticFileMimeTypes.fileMimeTypes(), runnable, executor);
    }

    @Deprecated
    public Result sendFile(File file, boolean bl, String string, FileMimeTypes fileMimeTypes) {
        return this.sendFile(file, bl, Optional.ofNullable(string), fileMimeTypes);
    }

    public Result sendFile(File file, boolean bl, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return this.sendFile(file, bl, optional, fileMimeTypes, () -> {}, null);
    }

    public Result sendFile(File file, boolean bl, Optional<String> optional, FileMimeTypes fileMimeTypes, Runnable runnable, Executor executor) {
        if (file == null) {
            throw new NullPointerException("null file");
        }
        try {
            return this.doSendResource((Source<ByteString, CompletionStage<IOResult>>)FileIO.fromPath((Path)file.toPath()), Optional.of(Files.size(file.toPath())), optional, bl, fileMimeTypes, runnable, executor);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private Result doSendResource(Source<ByteString, CompletionStage<IOResult>> source, Optional<Long> optional, Optional<String> optional2, boolean bl, FileMimeTypes fileMimeTypes, Runnable runnable, Executor executor) {
        return new Result(this.status(), Results.contentDispositionHeader(bl, optional2), new HttpEntity.Streamed(StatusHeader.attachOnClose(source, runnable, executor), optional, optional2.map(string -> fileMimeTypes.forFileName((String)string).orElse("application/octet-stream"))));
    }

    private static Source<ByteString, CompletionStage<IOResult>> attachOnClose(Source<ByteString, CompletionStage<IOResult>> source, Runnable runnable, Executor executor) {
        return source.mapMaterializedValue((Function & Serializable)completionStage -> executor != null ? completionStage.whenCompleteAsync((iOResult, throwable) -> runnable.run(), executor) : completionStage.whenCompleteAsync((iOResult, throwable) -> runnable.run()));
    }

    public Result chunked(Source<ByteString, ?> source) {
        return this.chunked(source, Optional.empty());
    }

    public Result chunked(Source<ByteString, ?> source, Optional<String> optional) {
        return new Result(this.status(), HttpEntity.chunked(source, optional));
    }

    public Result chunked(Source<ByteString, ?> source, boolean bl, Optional<String> optional) {
        return this.chunked(source, bl, optional, StaticFileMimeTypes.fileMimeTypes());
    }

    public Result chunked(Source<ByteString, ?> source, boolean bl, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return new Result(this.status(), Results.contentDispositionHeader(bl, optional), HttpEntity.chunked(source, optional.map(string -> fileMimeTypes.forFileName((String)string).orElse("application/octet-stream"))));
    }

    public Result streamed(Source<ByteString, ?> source, Optional<Long> optional) {
        return this.streamed(source, optional, Optional.empty());
    }

    public Result streamed(Source<ByteString, ?> source, Optional<Long> optional, Optional<String> optional2) {
        return new Result(this.status(), (HttpEntity)new HttpEntity.Streamed(source, optional, optional2));
    }

    public Result streamed(Source<ByteString, ?> source, Optional<Long> optional, boolean bl, Optional<String> optional2) {
        return this.streamed(source, optional, bl, optional2, StaticFileMimeTypes.fileMimeTypes());
    }

    public Result streamed(Source<ByteString, ?> source, Optional<Long> optional, boolean bl, Optional<String> optional2, FileMimeTypes fileMimeTypes) {
        return new Result(this.status(), Results.contentDispositionHeader(bl, optional2), new HttpEntity.Streamed(source, optional, optional2.map(string -> fileMimeTypes.forFileName((String)string).orElse("application/octet-stream"))));
    }

    public Result sendJson(JsonNode jsonNode) {
        return this.sendJson(jsonNode, JsonEncoding.UTF8);
    }

    public Result sendJson(JsonNode jsonNode, boolean bl, Optional<String> optional) {
        return this.sendJson(jsonNode, JsonEncoding.UTF8, bl, optional);
    }

    public Result sendJson(JsonNode jsonNode, JsonEncoding jsonEncoding) {
        return this.sendJson(jsonNode, jsonEncoding, true, Optional.empty());
    }

    public Result sendJson(JsonNode jsonNode, JsonEncoding jsonEncoding, boolean bl, Optional<String> optional) {
        if (jsonNode == null) {
            throw new NullPointerException("Null content");
        }
        ObjectMapper objectMapper = Json.mapper();
        ByteStringBuilder byteStringBuilder = ByteString$.MODULE$.newBuilder();
        try {
            JsonGenerator jsonGenerator = objectMapper.getFactory().createGenerator(byteStringBuilder.asOutputStream(), jsonEncoding);
            objectMapper.writeValue(jsonGenerator, (Object)jsonNode);
            String string = "application/json";
            return new Result(this.status(), Results.contentDispositionHeader(bl, optional), new HttpEntity.Strict(byteStringBuilder.result(), Optional.of(string)));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public Result sendEntity(HttpEntity httpEntity) {
        return new Result(this.status(), httpEntity);
    }

    public Result sendEntity(HttpEntity httpEntity, boolean bl, Optional<String> optional) {
        return this.sendEntity(httpEntity, bl, optional, StaticFileMimeTypes.fileMimeTypes());
    }

    public Result sendEntity(HttpEntity httpEntity, boolean bl, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return new Result(this.status(), Results.contentDispositionHeader(bl, optional), httpEntity.as(optional.flatMap(string -> fileMimeTypes.forFileName((String)string)).orElse("application/octet-stream")));
    }
}

