/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.impl;

import akka.annotation.InternalApi;
import akka.stream.impl.Buffer;
import akka.stream.impl.Buffer$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005ea!\u0002\r\u001a\u0005ey\u0002\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\u0015\t\u000b1\u0002A\u0011A\u0017\t\u000f}\u0002!\u0019!C\u0005\u0001\"1q\t\u0001Q\u0001\n\u0005Cq\u0001\u0013\u0001C\u0002\u0013%\u0011\n\u0003\u0004T\u0001\u0001\u0006IA\u0013\u0005\u0006)\u0002!\t!\u0016\u0005\u0006-\u0002!\t!\u0016\u0005\u0006/\u0002!\t\u0001\u0017\u0005\u00069\u0002!\t\u0001\u0017\u0005\u0006;\u0002!\t\u0001\u0017\u0005\u0006=\u0002!\ta\u0018\u0005\u0006E\u0002!\ta\u0019\u0005\u0006U\u0002!\ta\u001b\u0005\u0006[\u0002!\tA\u001c\u0005\u0006e\u0002!\ta\u001d\u0005\u0006i\u0002!\t!\u001e\u0005\u0006o\u0002!\ta\u001d\u0005\u0006q\u0002!\t!\u001f\u0005\u0006}\u0002!\ta \u0005\b\u0003\u0007\u0001A\u0011AA\u0003\u0011\u001d\t9\u0001\u0001C\u0001\u0003\u000bAq!!\u0003\u0001\t\u0003\t)AA\tQCJ$\u0018\u000e^5p]\u0016$')\u001e4gKJT!AG\u000e\u0002\t%l\u0007\u000f\u001c\u0006\u00039u\taa\u001d;sK\u0006l'\"\u0001\u0010\u0002\t\u0005\\7.Y\u000b\u0004AIb4C\u0001\u0001\"!\t\u0011S%D\u0001$\u0015\u0005!\u0013!B:dC2\f\u0017B\u0001\u0014$\u0005\u0019\te.\u001f*fM\u0006!1/\u001b>f\u0007\u0001\u0001\"A\t\u0016\n\u0005-\u001a#aA%oi\u00061A(\u001b8jiz\"\"A\f \u0011\t=\u0002\u0001gO\u0007\u00023A\u0011\u0011G\r\u0007\u0001\t\u0015\u0019\u0004A1\u00015\u0005\u0005Y\u0015CA\u001b9!\t\u0011c'\u0003\u00028G\t9aj\u001c;iS:<\u0007C\u0001\u0012:\u0013\tQ4EA\u0002B]f\u0004\"!\r\u001f\u0005\u000bu\u0002!\u0019\u0001\u001b\u0003\u0003YCQa\n\u0002A\u0002%\nA\u0002\\5oK\u0006\u0014()\u001e4gKJ,\u0012!\u0011\t\u0004_\t#\u0015BA\"\u001a\u0005\u0019\u0011UO\u001a4feB!!%\u0012\u0019<\u0013\t15E\u0001\u0004UkBdWMM\u0001\u000eY&tW-\u0019:Ck\u001a4WM\u001d\u0011\u0002!A\f'\u000f^5uS>t')\u001e4gKJ\u001cX#\u0001&\u0011\t-\u0003\u0006GU\u0007\u0002\u0019*\u0011QJT\u0001\b[V$\u0018M\u00197f\u0015\ty5%\u0001\u0006d_2dWm\u0019;j_:L!!\u0015'\u0003\u00075\u000b\u0007\u000fE\u00020\u0005n\n\u0011\u0003]1si&$\u0018n\u001c8Ck\u001a4WM]:!\u0003!\u0019\u0017\r]1dSRLX#A\u0015\u0002\tU\u001cX\rZ\u0001\u0007SN4U\u000f\u001c7\u0016\u0003e\u0003\"A\t.\n\u0005m\u001b#a\u0002\"p_2,\u0017M\\\u0001\bSN,U\u000e\u001d;z\u0003!qwN\\#naRL\u0018!E2p]R\f\u0017N\\:QCJ$\u0018\u000e^5p]R\u0011\u0011\f\u0019\u0005\u0006C2\u0001\r\u0001M\u0001\u0004W\u0016L\u0018aB3ocV,W/\u001a\u000b\u0004I\u001eD\u0007C\u0001\u0012f\u0013\t17E\u0001\u0003V]&$\b\"B1\u000e\u0001\u0004\u0001\u0004\"B5\u000e\u0001\u0004Y\u0014\u0001B3mK6\fq\"^:fI&s\u0007+\u0019:uSRLwN\u001c\u000b\u0003S1DQ!\u0019\bA\u0002A\nA\"\u00193e!\u0006\u0014H/\u001b;j_:$2\u0001Z8q\u0011\u0015\tw\u00021\u00011\u0011\u0015\tx\u00021\u0001S\u0003\u0019\u0011WO\u001a4fe\u00069A-Z9vKV,G#A\u001e\u0002+\u0011\u0014x\u000e](oYf\u0004\u0016M\u001d;ji&|g\u000eS3bIR\u0011\u0011L\u001e\u0005\u0006CF\u0001\r\u0001M\u0001\u0005a\u0016,7.A\u0007qK\u0016\\\u0007+\u0019:uSRLwN\u001c\u000b\u0003uv\u00042AI><\u0013\ta8E\u0001\u0004PaRLwN\u001c\u0005\u0006CN\u0001\r\u0001M\u0001\u000ea\u0006\u0014H/\u001b;j_:DU-\u00193\u0015\u0007i\f\t\u0001C\u0003b)\u0001\u0007\u0001'A\u0003dY\u0016\f'\u000fF\u0001e\u0003!!'o\u001c9IK\u0006$\u0017\u0001\u00033s_B$\u0016-\u001b7)\u0007\u0001\ti\u0001\u0005\u0003\u0002\u0010\u0005UQBAA\t\u0015\r\t\u0019\"H\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\f\u0003#\u00111\"\u00138uKJt\u0017\r\\!qS\u0002")
@InternalApi
public final class PartitionedBuffer<K, V> {
    private final Buffer<Tuple2<K, V>> linearBuffer;
    private final Map<K, Buffer<V>> partitionBuffers;

    private Buffer<Tuple2<K, V>> linearBuffer() {
        return this.linearBuffer;
    }

    private Map<K, Buffer<V>> partitionBuffers() {
        return this.partitionBuffers;
    }

    public int capacity() {
        return this.linearBuffer().capacity();
    }

    public int used() {
        return this.linearBuffer().used();
    }

    public boolean isFull() {
        return this.linearBuffer().isFull();
    }

    public boolean isEmpty() {
        return this.linearBuffer().isEmpty();
    }

    public boolean nonEmpty() {
        return this.linearBuffer().nonEmpty();
    }

    public boolean containsPartition(K key) {
        return this.partitionBuffers().contains(key);
    }

    public void enqueue(K key, V elem) {
        this.linearBuffer().enqueue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), elem));
        Option option = this.partitionBuffers().get(key);
        if (option instanceof Some) {
            Some some = (Some)option;
            Buffer pbuf = (Buffer)some.value();
            pbuf.enqueue(elem);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalStateException(new StringBuilder(102).append("Enqueuing to key ").append(key).append(" that does not have a buffer, make sure to addPartition for each key before enqueuing").toString());
        }
        throw new MatchError((Object)option);
    }

    public int usedInPartition(K key) {
        Option option = this.partitionBuffers().get(key);
        if (option instanceof Some) {
            Some some = (Some)option;
            Buffer buffer = (Buffer)some.value();
            return buffer.used();
        }
        if (None$.MODULE$.equals(option)) {
            return 0;
        }
        throw new MatchError((Object)option);
    }

    public void addPartition(K key, Buffer<V> buffer) {
        this.partitionBuffers().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), buffer));
    }

    public V dequeue() {
        Tuple2<K, V> tuple2 = this.linearBuffer().dequeue();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Object key = tuple2._1();
        Object value = tuple2._2();
        Tuple2 tuple22 = new Tuple2(key, value);
        Object key2 = tuple22._1();
        Object value2 = tuple22._2();
        Option option = this.partitionBuffers().get(key2);
        if (option instanceof Some) {
            Some some = (Some)option;
            Buffer pbuf = (Buffer)some.value();
            if (BoxesRunTime.equals(pbuf.peek(), (Object)value2)) {
                pbuf.dropHead();
                if (pbuf.isEmpty()) {
                    this.partitionBuffers().remove(key2);
                }
            }
        } else if (None$.MODULE$.equals(option)) {
        } else {
            throw new MatchError((Object)option);
        }
        return (V)value2;
    }

    public boolean dropOnlyPartitionHead(K key) {
        Option option = this.partitionBuffers().get(key);
        if (option instanceof Some) {
            Some some = (Some)option;
            Buffer pbuf = (Buffer)some.value();
            pbuf.dropHead();
            Object object = pbuf.isEmpty() ? this.partitionBuffers().remove(key) : BoxedUnit.UNIT;
            return true;
        }
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        throw new MatchError((Object)option);
    }

    public V peek() {
        return (V)this.linearBuffer().peek()._2();
    }

    public Option<V> peekPartition(K key) {
        Option pbuf = this.partitionBuffers().get(key);
        return pbuf.map((Function1 & Serializable)x$2 -> x$2.peek());
    }

    public Option<V> partitionHead(K key) {
        Option pbuf = this.partitionBuffers().get(key);
        return pbuf.map((Function1 & Serializable)x$3 -> x$3.peek());
    }

    public void clear() {
        this.linearBuffer().clear();
        this.partitionBuffers().foreach((Function1 & Serializable)x0$1 -> {
            PartitionedBuffer.$anonfun$clear$1(x0$1);
            return BoxedUnit.UNIT;
        });
        this.partitionBuffers().clear();
    }

    public void dropHead() {
        if (this.nonEmpty()) {
            Tuple2<K, V> tuple2 = this.linearBuffer().dequeue();
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Object key = tuple2._1();
            Object head = tuple2._2();
            Tuple2 tuple22 = new Tuple2(key, head);
            Object key2 = tuple22._1();
            Object head2 = tuple22._2();
            this.partitionBuffers().get(key2).foreach((Function1 & Serializable)pbuf -> {
                if (BoxesRunTime.equals(pbuf.peek(), (Object)head2)) {
                    pbuf.dropHead();
                    if (pbuf.isEmpty()) {
                        return this.partitionBuffers().remove(key2);
                    }
                    return BoxedUnit.UNIT;
                }
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public void dropTail() {
        throw new UnsupportedOperationException("cannot drop tail of a partitioned buffer");
    }

    public static final /* synthetic */ void $anonfun$clear$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Buffer buf = (Buffer)tuple2._2();
            buf.clear();
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public PartitionedBuffer(int size) {
        this.linearBuffer = Buffer$.MODULE$.apply(size, size);
        this.partitionBuffers = (Map)Map$.MODULE$.empty();
    }
}

