/*
 * Decompiled with CFR 0.152.
 */
package play.libs;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPath {
    public static NodeList selectNodes(String string, Object object, Map<String, String> map) {
        try {
            XPathFactory xPathFactory = XPathFactory.newInstance();
            javax.xml.xpath.XPath xPath = xPathFactory.newXPath();
            if (map != null) {
                PlayNamespaceContext playNamespaceContext = new PlayNamespaceContext();
                XPath.bindUnboundedNamespaces(playNamespaceContext, map);
                xPath.setNamespaceContext(playNamespaceContext);
            }
            return (NodeList)xPath.evaluate(string, object, XPathConstants.NODESET);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static NodeList selectNodes(String string, Object object) {
        return XPath.selectNodes(string, object, null);
    }

    public static Node selectNode(String string, Object object, Map<String, String> map) {
        try {
            XPathFactory xPathFactory = XPathFactory.newInstance();
            javax.xml.xpath.XPath xPath = xPathFactory.newXPath();
            if (map != null) {
                PlayNamespaceContext playNamespaceContext = new PlayNamespaceContext();
                XPath.bindUnboundedNamespaces(playNamespaceContext, map);
                xPath.setNamespaceContext(playNamespaceContext);
            }
            return (Node)xPath.evaluate(string, object, XPathConstants.NODE);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static Node selectNode(String string, Object object) {
        return XPath.selectNode(string, object, null);
    }

    private static void bindUnboundedNamespaces(PlayNamespaceContext playNamespaceContext, Map<String, String> map) {
        map.forEach((string, string2) -> {
            if (playNamespaceContext.getPrefix((String)string2) == null) {
                playNamespaceContext.bindNamespaceUri((String)string, (String)string2);
            }
        });
    }

    public static String selectText(String string, Object object, Map<String, String> map) {
        try {
            XPathFactory xPathFactory = XPathFactory.newInstance();
            javax.xml.xpath.XPath xPath = xPathFactory.newXPath();
            if (map != null) {
                PlayNamespaceContext playNamespaceContext = new PlayNamespaceContext();
                XPath.bindUnboundedNamespaces(playNamespaceContext, map);
                xPath.setNamespaceContext(playNamespaceContext);
            }
            return (String)xPath.evaluate(string, object, XPathConstants.STRING);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static String selectText(String string, Object object) {
        return XPath.selectText(string, object, null);
    }

    static class PlayNamespaceContext
    implements NamespaceContext {
        private final Map<String, String> prefixMap = new HashMap<String, String>();
        private final Map<String, Set<String>> namespaceMap = new HashMap<String, Set<String>>();

        PlayNamespaceContext() {
        }

        @Override
        public String getNamespaceURI(String string) {
            String string2 = Objects.requireNonNull(string, "Null prefix");
            return Optional.of(this.prefixMap.get(string2)).orElse("");
        }

        private Set<String> getPrefixesSet(String string) {
            if ("http://www.w3.org/XML/1998/namespace".equals(string)) {
                return Collections.singleton("xml");
            }
            if ("http://www.w3.org/2000/xmlns/".equals(string)) {
                return Collections.singleton("xmlns");
            }
            Set<String> set = this.namespaceMap.get(string);
            return set != null ? Collections.unmodifiableSet(set) : Collections.emptySet();
        }

        @Override
        public String getPrefix(String string) {
            String string2 = Objects.requireNonNull(string, "Null namespaceURI");
            return this.getPrefixesSet(string2).stream().findFirst().orElse(null);
        }

        public Iterator getPrefixes(String string) {
            String string2 = Objects.requireNonNull(string, "Null namespaceURI");
            return this.getPrefixesSet(string2).iterator();
        }

        void bindNamespaceUri(String string2, String string3) {
            String string4 = Objects.requireNonNull(string2, "Null prefix");
            String string5 = Objects.requireNonNull(string3, "Null namespaceURI");
            if (!"".equals(string4)) {
                this.prefixMap.put(string4, string5);
                Set set = this.namespaceMap.computeIfAbsent(string5, string -> new LinkedHashSet());
                set.add(string4);
            }
        }
    }
}

