/*
 * Decompiled with CFR 0.152.
 */
package jayeson.service.feedwrapper.server;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import jayeson.lib.feed.api.IBetEvent;
import jayeson.lib.feed.api.IBetMatch;
import jayeson.lib.feed.api.IBetRecord;
import jayeson.lib.feed.api.PartitionKey;
import jayeson.lib.sports.client.DeleteEvent;
import jayeson.lib.sports.client.DeleteMatch;
import jayeson.lib.sports.client.DeleteOdd;
import jayeson.lib.sports.client.InsertEvent;
import jayeson.lib.sports.client.InsertMatch;
import jayeson.lib.sports.client.InsertOdd;
import jayeson.lib.sports.client.PushDelta;
import jayeson.lib.sports.client.Reset;
import jayeson.lib.sports.client.UpdateEvent;
import jayeson.lib.sports.client.UpdateMatch;
import jayeson.lib.sports.client.UpdateOdd;
import jayeson.service.feedwrapper.datastructure.Refresh;
import jayeson.service.feedwrapper.datastructure.SnapshotImpl;
import jayeson.service.feedwrapper.server.ClientSubscriber;
import jayeson.service.feedwrapper.server.DeltaEventPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observer;
import rx.Subscription;
import rx.schedulers.Schedulers;
import rx.subjects.PublishSubject;
import rx.subjects.SerializedSubject;
import rx.subjects.Subject;

public class DeltaEventPublisherImpl
implements DeltaEventPublisher {
    private SerializedSubject<PushDelta<?>, PushDelta<?>> messageSubject;
    private final int bufferSize = 1000;
    private AtomicInteger counter = new AtomicInteger(0);
    private static Logger log = LoggerFactory.getLogger((String)"DeltaEventPublisherImpl");
    public static final SnapshotImpl EMPTY_SNAPSHOT = new SnapshotImpl();

    public DeltaEventPublisherImpl() {
        this.messageSubject = new SerializedSubject((Subject)PublishSubject.create());
        this.messageSubject.onBackpressureBuffer(1000L, () -> log.error("Buffer full, closing channel. Counter: {}", (Object)this.counter.incrementAndGet()));
    }

    public void onInsertMatch(InsertMatch<IBetMatch> match) {
        this.send((PushDelta<?>)match);
        match.get().stream().forEach(m -> log.trace("INSERT_MATCH " + m.id()));
    }

    public void onUpdateMatch(UpdateMatch<IBetMatch> match) {
        this.send((PushDelta<?>)match);
        match.get().stream().forEach(m -> log.trace("UPDATE_MATCH " + m.id()));
    }

    public void onDeleteMatch(DeleteMatch<IBetMatch> match) {
        this.send((PushDelta<?>)match);
        match.get().stream().forEach(m -> log.trace("DELETE_MATCH " + m.id()));
    }

    public void onInsertEvent(InsertEvent<IBetEvent> event) {
        this.send((PushDelta<?>)event);
        event.get().stream().forEach(m -> log.trace("INSERT_EVENT " + m.id() + "_" + m.eventState().partitionKey().source()));
    }

    public void onUpdateEvent(UpdateEvent<IBetEvent> event) {
        this.send((PushDelta<?>)event);
        event.get().stream().forEach(m -> log.trace("UPDATE_EVENT " + m.id() + "_" + m.eventState().partitionKey().source()));
    }

    public void onDeleteEvent(DeleteEvent<IBetEvent> event) {
        this.send((PushDelta<?>)event);
        event.get().stream().forEach(m -> log.trace("DELETE_EVENT " + m.id() + "_" + m.eventState().partitionKey().source()));
    }

    public void onInsertOdd(InsertOdd<IBetRecord> record) {
        this.send((PushDelta<?>)record);
        record.get().stream().forEach(m -> log.trace("INSERT_ODD " + m.id() + "_" + m.source() + "_" + String.valueOf(record.after().match(m.matchId()).event(m.eventId()).eventState().partitionKey().sportType())));
    }

    public void onUpdateOdd(UpdateOdd<IBetRecord> record) {
        this.send((PushDelta<?>)record);
        record.get().stream().forEach(m -> log.trace("UPDATE_ODD " + m.id() + "_" + m.source() + "_" + String.valueOf(record.after().match(m.matchId()).event(m.eventId()).eventState().partitionKey().sportType())));
    }

    public void onDeleteOdd(DeleteOdd<IBetRecord> record) {
        this.send((PushDelta<?>)record);
        record.get().stream().forEach(m -> log.trace("DELETE_ODD " + m.id() + "_" + m.source() + "_" + String.valueOf(record.after().match(m.matchId()).event(m.eventId()).eventState().partitionKey().sportType())));
    }

    public void onReset(Reset resetKeys) {
        this.send((PushDelta<?>)resetKeys);
        resetKeys.get().stream().forEach(m -> log.trace("RESET " + ((PartitionKey)m).source() + "_" + String.valueOf(((PartitionKey)m).oddType()) + "_" + String.valueOf(((PartitionKey)m).sportType())));
    }

    public void onRefresh(List<PartitionKey> refreshKeys) {
        Refresh refresh = new Refresh(EMPTY_SNAPSHOT, refreshKeys);
        this.send(refresh);
        refreshKeys.stream().forEach(m -> log.trace("Refresh " + m.source() + "_" + String.valueOf(m.oddType()) + "_" + String.valueOf(m.sportType())));
    }

    @Override
    public Subscription subscribe(ClientSubscriber handler) {
        return this.messageSubject.observeOn(Schedulers.io()).subscribe((Observer)handler);
    }

    @Override
    public void unsubscribe(Subscription subscription) {
        subscription.unsubscribe();
    }

    private void send(PushDelta<?> message) {
        log.debug("Notify message: {}", message);
        this.messageSubject.onNext(message);
    }
}

