/*
 * Decompiled with CFR 0.152.
 */
package jayeson.service.feedwrapper.server.netty;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.util.Map;
import java.util.UUID;
import jayeson.service.feedwrapper.server.ClientSubscriber;
import jayeson.service.feedwrapper.server.ClientSubscriberFactory;
import jayeson.service.feedwrapper.server.netty.NettyClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class ClientHandler
extends SimpleChannelInboundHandler<Map<String, Object>> {
    private final ClientSubscriberFactory subscribeHandlerFactory;
    private Logger log = LoggerFactory.getLogger(ClientHandler.class);
    private AttributeKey<ClientSubscriber> subscriberHandlerKey;
    private ObjectMapper jsonMsgEncoder;
    private Integer awaitMessageLimited;

    @Inject
    public ClientHandler(ClientSubscriberFactory subscriberHandlerFactory, ObjectMapper jsonMsgEncoder, @Named(value="awaitLimited") int awaitMessageLimited) {
        this.subscribeHandlerFactory = subscriberHandlerFactory;
        this.jsonMsgEncoder = jsonMsgEncoder;
        this.subscriberHandlerKey = AttributeKey.newInstance((String)"client");
        this.awaitMessageLimited = awaitMessageLimited;
    }

    protected void channelRead0(ChannelHandlerContext ctx, Map<String, Object> msg) throws Exception {
        Attribute subscriberAttr = ctx.attr(this.subscriberHandlerKey);
        ClientSubscriber subscriber = (ClientSubscriber)subscriberAttr.get();
        if (subscriber != null) {
            try {
                this.log.info("Received message from subscriber {}", (Object)subscriber.getClient().getId());
                this.processMessage(ctx, subscriber, msg);
            }
            catch (Exception e) {
                this.log.error("ERROR IN PROCESS", (Throwable)e);
            }
        } else {
            this.log.debug("Subscriber is null");
            ctx.close();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        super.exceptionCaught(ctx, cause);
        Attribute subscriberAttr = ctx.attr(this.subscriberHandlerKey);
        ClientSubscriber clientHandler = (ClientSubscriber)subscriberAttr.getAndRemove();
        this.log.error("CLIENT: {} ### Exception caught ", (Object)clientHandler.getClient().getId(), (Object)cause);
        ctx.close();
        if (clientHandler != null) {
            try {
                clientHandler.clientUnsubscribed(cause);
            }
            catch (Exception e) {
                this.log.error("ERROR IN SUBSCRIBER IMPL", (Throwable)e);
            }
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        NettyClient client = new NettyClient(UUID.randomUUID().toString(), ctx, this.jsonMsgEncoder, this.awaitMessageLimited);
        this.log.debug("Channel is active with client key {}", (Object)client.getId());
        ClientSubscriber subscriber = this.subscribeHandlerFactory.createSubscriberHandler(client);
        Attribute subscriberAttr = ctx.attr(this.subscriberHandlerKey);
        subscriberAttr.set((Object)subscriber);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        Attribute subscriberAttr = ctx.attr(this.subscriberHandlerKey);
        ClientSubscriber subscriber = (ClientSubscriber)subscriberAttr.getAndRemove();
        if (subscriber != null) {
            try {
                this.log.debug("Channel is inactive with client key {}", (Object)subscriber.getClient().getId());
                subscriber.clientUnsubscribed(null);
            }
            catch (Exception e) {
                this.log.error("ERROR IN SUBSCRIBER IMPL", (Throwable)e);
            }
        } else {
            this.log.debug("Channel is inactive with NULL client key");
        }
    }

    private void processMessage(ChannelHandlerContext ctx, ClientSubscriber subscriber, Map<String, Object> msg) {
        String msgType = (String)msg.get("type");
        this.log.info("CLIENT: {} Message type: {}", (Object)subscriber.getClient().getId(), (Object)msgType);
        switch (msgType) {
            case "SUBSCRIBE": 
            case "subscribe": {
                subscriber.clientSubscribed();
                break;
            }
            case "UNSUBSCRIBE": 
            case "unsubscribe": {
                subscriber.clientUnsubscribed(null);
                Attribute subscriberAttr = ctx.attr(this.subscriberHandlerKey);
                subscriberAttr.remove();
                ctx.close();
                break;
            }
            default: {
                this.log.info("CLIENT: {} Unknown message type: {}", (Object)subscriber.getClient().getId(), (Object)msgType);
            }
        }
    }
}

