/*
 * Decompiled with CFR 0.152.
 */
package jayeson.service.feedwrapper.server.netty;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import jayeson.lib.sports.client.PushDelta;
import jayeson.service.feedwrapper.server.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyClient
extends Client {
    private static Logger log = LoggerFactory.getLogger(NettyClient.class);
    private final ChannelHandlerContext ctx;
    private final ObjectMapper mapper;
    private String clientId;
    private final Object lock;
    private final AtomicBoolean isConnected;
    private final Set<ChannelFuture> listFuture;
    private ScheduledExecutorService executor;
    private final int awaitFutureLimited;

    @Inject
    public NettyClient(String clientId, ChannelHandlerContext ctx, ObjectMapper map, Integer awaitFutureLimited) {
        this.ctx = ctx;
        this.mapper = map;
        this.clientId = clientId;
        this.setId(clientId);
        log.info(clientId + " connected");
        this.lock = new Object();
        this.isConnected = new AtomicBoolean(true);
        this.awaitFutureLimited = awaitFutureLimited;
        this.listFuture = Sets.newConcurrentHashSet();
        this.executor = new ScheduledThreadPoolExecutor(1);
        this.executor.submit(this::checkMessage);
    }

    @Override
    public CompletableFuture<Boolean> send(PushDelta<?> message) {
        if (message == null) {
            throw new IllegalArgumentException("message cannot be null");
        }
        final CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        String sendingMsg = null;
        try {
            sendingMsg = this.mapper.writeValueAsString(message);
        }
        catch (JsonProcessingException e) {
            log.error("CLIENT:{} Cannot serialize object :{}", new Object[]{this.clientId, message, e});
            result.completeExceptionally(e);
            return result;
        }
        ChannelFuture future = this.ctx.writeAndFlush((Object)sendingMsg);
        future.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.cause() != null) {
                    result.completeExceptionally(future.cause());
                } else {
                    result.complete(future.isSuccess());
                }
            }
        });
        this.listFuture.add(future);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isConnected.compareAndSet(true, false)) {
                this.ctx.close().addListener(future -> {
                    log.error("CLIENT DISCONNECTED: {}", (Object)this.clientId);
                    this.executor.shutdown();
                });
            }
        }
    }

    @Override
    public boolean isConnected() {
        if (this.ctx == null || this.ctx.channel() == null) {
            return false;
        }
        return this.ctx.channel().isActive();
    }

    public void checkMessage() {
        if (this.isConnected.get()) {
            this.listFuture.removeIf(Future::isDone);
            log.debug("Client {} have {} waiting future", (Object)this.clientId, (Object)this.listFuture.size());
            if (this.listFuture.size() >= this.awaitFutureLimited) {
                log.error("[CHECK-MESSAGE] Client {} reach awaitFutureLimited.", (Object)this.clientId);
                this.disconnect();
                return;
            }
            this.executor.schedule(this::checkMessage, 3000L, TimeUnit.MILLISECONDS);
        } else {
            log.error("[CHECK-MESSAGE] Client disconnected: {}", (Object)this.clientId);
        }
    }
}

