/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.feed.api;

import jayeson.lib.feed.api.OddType;
import jayeson.lib.feed.api.SportType;

public class PartitionKey {
    private static final String SEPARATOR = "_";
    private String source;
    private OddType oddType;
    private SportType sportType;

    public PartitionKey(String source, OddType oddType, SportType sportType) {
        this.source = source;
        this.oddType = oddType;
        this.sportType = sportType;
    }

    public String source() {
        return this.source;
    }

    public OddType oddType() {
        return this.oddType;
    }

    public SportType sportType() {
        return this.sportType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.oddType == null ? 0 : this.oddType.hashCode());
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        result = 31 * result + (this.sportType == null ? 0 : this.sportType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PartitionKey other = (PartitionKey)obj;
        if (this.oddType != other.oddType) {
            return false;
        }
        if (this.source == null ? other.source != null : !this.source.equals(other.source)) {
            return false;
        }
        return this.sportType == other.sportType;
    }

    public String toString() {
        return this.sportType + SEPARATOR + this.source + SEPARATOR + this.oddType;
    }

    public static PartitionKey fromString(String input) {
        if (input == null) {
            return null;
        }
        String[] split = input.split(SEPARATOR);
        if (split.length != 3) {
            return null;
        }
        SportType sportType = null;
        OddType oddType = null;
        try {
            sportType = SportType.valueOf(split[0]);
            oddType = OddType.valueOf(split[2]);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
        String source = split[1];
        return new PartitionKey(source, oddType, sportType);
    }
}

