/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.feed.api.twoside;

import jayeson.lib.feed.api.IBetRecord;
import jayeson.lib.feed.api.twoside.PivotBias;
import jayeson.lib.feed.api.twoside.PivotType;
import jayeson.lib.feed.api.twoside.RateLine;
import jayeson.lib.feed.api.twoside.TargetType;

public interface IB2Record
extends IBetRecord {
    public float pivotValue();

    public PivotType pivotType();

    public PivotBias pivotBias();

    public boolean isSwapped();

    public float rateOver();

    public float rateUnder();

    public float rateEqual();

    public String rateOverId();

    public String rateUnderId();

    public String rateEqualId();

    default public RateLine rateLine(TargetType t) {
        throw new UnsupportedOperationException();
    }

    default public boolean isAllowed(TargetType targetType) {
        PivotType pivotType = null;
        switch (targetType) {
            case GIVE: 
            case TAKE: 
            case HOME: 
            case AWAY: {
                pivotType = PivotType.HDP;
                break;
            }
            case OVER: 
            case UNDER: {
                pivotType = PivotType.TOTAL;
                break;
            }
            case ONE: 
            case TWO: 
            case DRAW: {
                pivotType = PivotType.ONE_TWO;
                break;
            }
        }
        return this.pivotType().equals((Object)pivotType);
    }
}

