/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.feed.tennis;

import java.util.Arrays;
import java.util.List;
import jayeson.lib.feed.api.IParticipantStats;
import jayeson.lib.feed.api.PartitionKey;
import jayeson.lib.feed.core.B2EventState;
import jayeson.lib.feed.tennis.TennisSegment;
import jayeson.lib.feed.tennis.TennisStats;

public class TennisEventState
extends B2EventState {
    private final int set;
    private final int game;
    private final TennisStats p1Stat;
    private final TennisStats p2Stat;
    private TennisSegment segment;
    public static final int INVALID = -1;

    public TennisEventState(IParticipantStats statsOne, IParticipantStats statsTwo, int duration, PartitionKey key, String matchId, String eventId, int set, int game, TennisSegment segment, int bookPriority) {
        super(statsOne, statsTwo, duration, key, matchId, eventId, bookPriority);
        this.set = set;
        this.game = game;
        this.segment = segment;
        this.p1Stat = (TennisStats)statsOne;
        this.p2Stat = (TennisStats)statsTwo;
    }

    public TennisEventState(IParticipantStats statsOne, IParticipantStats statsTwo, int duration, PartitionKey key, String matchId, String eventId, TennisSegment segment, int bookPriority) {
        this(statsOne, statsTwo, duration, key, matchId, eventId, -1, -1, segment, bookPriority);
    }

    public boolean hasSetCount() {
        return this.set != -1;
    }

    public boolean hasGameCount() {
        return this.game != -1;
    }

    public int set() {
        return this.set;
    }

    public int game() {
        return this.game;
    }

    public int getP1CurrentSetWon() {
        return this.p1Stat.getCurrentSetWon();
    }

    public int getP2CurrentSetWon() {
        return this.p2Stat.getCurrentSetWon();
    }

    public int getP1CurrentGameWon() {
        return this.p1Stat.getCurrentGameWon();
    }

    public int getP2CurrentGameWon() {
        return this.p2Stat.getCurrentGameWon();
    }

    public int getP1CurrentPointWon() {
        return this.p1Stat.getCurrentPointWon();
    }

    public int getP2CurrentPointWon() {
        return this.p2Stat.getCurrentPointWon();
    }

    public int getP1GameWon(int setNum) {
        return this.p1Stat.getGameWon(setNum);
    }

    public int getP2GameWon(int setNum) {
        return this.p2Stat.getGameWon(setNum);
    }

    @Override
    public TennisSegment segment() {
        return this.segment;
    }

    @Override
    public List<IParticipantStats> stats() {
        return Arrays.asList(this.statsOne(), this.statsTwo());
    }

    @Override
    public IParticipantStats statsOf(int idx) {
        switch (idx) {
            case 0: {
                return this.statsOne();
            }
            case 1: {
                return this.statsTwo();
            }
        }
        throw new IndexOutOfBoundsException();
    }
}

