/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.namefeed;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import jayeson.lib.delivery.api.IEndPoint;
import jayeson.lib.delivery.api.IEndPointListener;
import jayeson.lib.delivery.api.MetaInformationCode;
import jayeson.lib.delivery.api.events.EPEvent;
import jayeson.lib.delivery.api.messages.IMessageClass;
import jayeson.lib.delivery.api.messages.IMessageGroup;
import jayeson.lib.delivery.api.messages.MessageWrapper;
import jayeson.lib.delivery.core.metainfo.StreamNameCode;
import jayeson.lib.delivery.module.subscriber.StreamId;
import jayeson.lib.delivery.module.subscriber.events.ConsumptionErrorEvent;
import jayeson.lib.delivery.module.subscriber.events.ConsumptionStartEvent;
import jayeson.lib.feed.api.PartitionKey;
import jayeson.lib.namefeed.DeltaGenerator;
import jayeson.lib.namefeed.DeltaMessages;
import jayeson.lib.namefeed.NameFeedInProcessor;
import jayeson.lib.namefeed.NameFeedOutProcessor;
import jayeson.lib.namefeed.NameFeedStore;
import jayeson.lib.namefeed.NameRecord;
import jayeson.lib.namefeed.client.NameFeedClient;
import jayeson.lib.namefeed.config.NameFeedConfig;
import jayeson.lib.namefeed.datastructure.NameFeedSet;
import jayeson.lib.namefeed.datastructure.NameRefresh;
import jayeson.lib.namefeed.datastructure.NameReset;
import jayeson.lib.namefeed.message.NameFeedMessageGroup;
import jayeson.service.delivery.AbstractProcessingEngine;
import jayeson.service.delivery.IInProcessor;
import jayeson.service.delivery.IOutProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class NameFeedServer
extends AbstractProcessingEngine {
    Logger log;
    private NameFeedMessageGroup msgGroup;
    private NameFeedInProcessor inProcessor;
    private NameFeedOutProcessor outProcessor;
    private StreamNameCode streamNameCode;
    private DeltaGenerator deltaGen;
    final NameFeedStore serverStore;
    private ReentrantLock lock = new ReentrantLock(true);
    final NameFeedClient client;
    private NameFeedConfig nameFeedConf;

    @Inject
    public NameFeedServer(NameFeedMessageGroup msgGroup, NameFeedInProcessor inProcessor, NameFeedOutProcessor outProcessor, StreamNameCode code, DeltaGenerator deltaGen, NameFeedClient client, NameFeedConfig nameFeedConf, NameFeedStore store) {
        this.log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        this.msgGroup = msgGroup;
        this.inProcessor = inProcessor;
        this.outProcessor = outProcessor;
        this.streamNameCode = code;
        this.deltaGen = deltaGen;
        this.nameFeedConf = nameFeedConf;
        this.client = client;
        this.serverStore = store;
        if (this.client != null) {
            this.log.debug("Creating server with name feed client");
            this.client.onStreamFullNameFeed(this::handlerFullMessage);
            this.client.onStreamDeleteNameFeed(this::handlerDeleteMessage);
            this.client.onStreamResetNameFeed(this::handlerResetMessage);
            this.client.onStreamRefreshNameFeed(this::handlerRefreshMessage);
            this.client.start();
        } else {
            this.log.debug("Creating server without name feed client");
        }
    }

    private void doAdvertisement() {
        this.nameFeedConf.getStreamName().forEach(streamName -> this.getAdvertiser().advertise(this.msgGroup.id(), streamName, this.nameFeedConf.getLevel()));
        this.getSubscriber().attachListener(new IEndPointListener(){

            public void onEvent(EPEvent event) {
                NameFeedServer.this.reAdvertise(event);
            }
        });
    }

    private void reAdvertise(EPEvent event) {
        block3: {
            block2: {
                if (!(event instanceof ConsumptionStartEvent)) break block2;
                ConsumptionStartEvent castedEvent = (ConsumptionStartEvent)event;
                for (StreamId streamId : castedEvent.getStreams()) {
                    if (streamId.group.byteValue() != this.msgGroup.id()) continue;
                    int level = this.nameFeedConf.getLevel();
                    this.log.info("Adding advertisement {} {} {}", new Object[]{streamId.group, streamId.stream, level});
                    this.getAdvertiser().advertise(streamId.group.byteValue(), streamId.stream, level);
                }
                break block3;
            }
            if (!(event instanceof ConsumptionErrorEvent)) break block3;
            for (StreamId streamId : ((ConsumptionErrorEvent)event).getStreams()) {
                if (streamId.group.byteValue() != this.msgGroup.id()) continue;
                this.log.info("Removing advertisement {} {}", (Object)streamId.group, (Object)streamId.stream);
                this.getAdvertiser().remove(streamId.group.byteValue(), streamId.stream);
            }
        }
    }

    public void handlerFullMessage(String stream, Collection<NameRecord> nameFeed) {
        Set endpoints = this.getStreamRegistry().getConsumingEndPoints(this.getMessageGroup().id(), stream);
        if (this.serverStore.get(stream).isEmpty()) {
            this.serverStore.put(stream, nameFeed);
            nameFeed.stream().forEach(name -> this.log.debug("Server Inserting name feed {}_{}_{}_{}_{}_{} Stream : {}", new Object[]{name.getSource(), name.getOriginalEventId(), name.getLeague(), name.getHost(), name.getGuest(), name.getOddType(), stream}));
        } else {
            nameFeed.stream().forEach(name -> {
                this.serverStore.getStore(stream).put(name.getOriginalEventId(), (NameRecord)name);
                this.log.debug("Server Inserting name feed {}_{}_{}_{}_{}_{} Stream : {}", new Object[]{name.getSource(), name.getOriginalEventId(), name.getLeague(), name.getHost(), name.getGuest(), name.getOddType(), stream});
            });
        }
        endpoints.stream().forEach(socket -> this.sendFullMessage(nameFeed, stream, this.nameFeedConf.getLevel(), (IEndPoint)socket));
    }

    public void handlerDeleteMessage(String stream, Collection<NameRecord> nameFeed) {
        Set endpoints = this.getStreamRegistry().getConsumingEndPoints(this.getMessageGroup().id(), stream);
        nameFeed.stream().forEach(name -> {
            if (this.serverStore.getStore(stream).size() == 0) {
                this.log.error("Deleting name from a empty map!");
                return;
            }
            this.serverStore.getStore(stream).remove(name.getOriginalEventId());
            this.log.debug("Server Deleting name feed {}_{}_{}_{}_{}_{} Stream : {}", new Object[]{name.getSource(), name.getOriginalEventId(), name.getLeague(), name.getHost(), name.getGuest(), name.getOddType(), stream});
        });
        endpoints.stream().forEach(socket -> this.sendDeleteMessage(nameFeed, stream, this.nameFeedConf.getLevel(), (IEndPoint)socket));
    }

    public void handlerResetMessage(String stream, Collection<NameRecord> nameFeed) {
        this.log.debug("Server Reseting stream {}", (Object)stream);
        this.serverStore.reset(stream);
        Set endpoints = this.getStreamRegistry().getConsumingEndPoints(this.getMessageGroup().id(), stream);
        endpoints.stream().forEach(socket -> this.sendReset(stream, this.nameFeedConf.getLevel(), (IEndPoint)socket));
    }

    public void handlerRefreshMessage(String stream, Collection<NameRecord> nameFeed) {
        this.log.debug("Server Refreshing stream {}", (Object)stream);
        this.serverStore.updateTTLMap(stream);
        Set endpoints = this.getStreamRegistry().getConsumingEndPoints(this.getMessageGroup().id(), stream);
        endpoints.stream().forEach(socket -> this.sendRefresh(stream, this.nameFeedConf.getLevel(), (IEndPoint)socket));
    }

    public Collection<NameRecord> put(PartitionKey stream, Collection<NameRecord> namefeedrecord, int level) {
        String streamName;
        List<String> streams = this.nameFeedConf.getStreamName();
        if (!streams.contains((streamName = NameFeedSet.getStreamName(stream.toString())).toString())) {
            return new ArrayList<NameRecord>();
        }
        this.serverStore.updateTTLMap(streamName);
        this.freezeSnapshot("");
        if (level < 0) {
            throw new IllegalArgumentException("Stream level must be at least 0");
        }
        this.nameFeedConf.setLevel(level);
        this.log.debug("Number of name feed record : {} , Stream : {}", (Object)namefeedrecord.size(), (Object)streamName);
        Map<String, NameRecord> prev = this.serverStore.put(streamName, namefeedrecord);
        Map<String, NameRecord> curr = this.serverStore.get(streamName);
        Set endpoints = this.getStreamRegistry().getConsumingEndPoints(this.getMessageGroup().id(), streamName);
        this.log.debug("Endpoint size {}", (Object)endpoints.size());
        endpoints.stream().forEach(socket -> this.sendRefresh(streamName, this.nameFeedConf.getLevel(), (IEndPoint)socket));
        if (namefeedrecord.size() == 0) {
            this.log.debug("No more matches");
        }
        try {
            DeltaMessages msg = this.deltaGen.generateDelta(streamName, prev, curr);
            endpoints = this.getStreamRegistry().getConsumingEndPoints(this.getMessageGroup().id(), streamName);
            if (!msg.getFullDeltaMessage().isEmpty()) {
                endpoints.stream().forEach(socket -> this.sendFullMessage(msg.getFullDeltaMessage(), streamName, level, (IEndPoint)socket));
            }
            if (!msg.getDeleteMessage().isEmpty()) {
                endpoints.stream().forEach(socket -> this.sendDeleteMessage(msg.getDeleteMessage(), streamName, level, (IEndPoint)socket));
            }
        }
        catch (Exception e) {
            this.log.debug(e.getMessage() + " | " + Arrays.asList(e.getStackTrace()));
        }
        this.unFreezeSnapshot("");
        return prev.values();
    }

    public Collection<NameRecord> get(String stream) {
        return this.serverStore.get(stream).values();
    }

    public IInProcessor getInProcessor() {
        return this.inProcessor;
    }

    public IMessageGroup getMessageGroup() {
        return this.msgGroup;
    }

    public IOutProcessor getOutProcessor() {
        return this.outProcessor;
    }

    public void onStartUp() {
        this.doAdvertisement();
    }

    protected void actOnEndPointDiscontinued(IEndPoint arg0) {
    }

    protected boolean actOnStreamDeRegistrationRequest(IEndPoint ep, String stream) {
        return true;
    }

    protected boolean actOnStreamRegistrationRequest(IEndPoint ep, String stream) {
        return true;
    }

    protected void startPublishing(IEndPoint ep, String stream) {
        this.log.debug("Start publishing {}.. Available stream {}", (Object)stream, (Object)this.serverStore.getFullSnapshot().keySet().toString());
        this.freezeSnapshot("");
        this.sendReset(stream, this.nameFeedConf.getLevel(), ep);
        Collection<NameRecord> ori = this.get(stream);
        if (ori.isEmpty()) {
            this.log.debug("Cannot get full snapshot for stream {}.", (Object)stream);
        } else {
            this.sendFullMessage(ori, stream, this.nameFeedConf.getLevel(), ep);
        }
        this.unFreezeSnapshot("");
    }

    String formatMatchResults(Collection<NameRecord> results) {
        StringBuilder sb = new StringBuilder();
        for (NameRecord result : results) {
            sb.append(result.toString() + "\n");
        }
        return sb.toString().trim();
    }

    public void freezeSnapshot(String streamName) {
        if (this.lock.getHoldCount() > 0) {
            this.log.warn("Lock already got by this thread.Call unlock multiple times", (Object)streamName);
        }
        this.lock.lock();
    }

    public void unFreezeSnapshot(String streamName) {
        try {
            this.lock.unlock();
        }
        catch (IllegalMonitorStateException ex) {
            this.log.error("Error while unfreezing lock ", (Throwable)ex);
        }
    }

    void sendReset(String stream, int level, IEndPoint socket) {
        MessageWrapper msg = new MessageWrapper((Object)new NameReset(stream), (IMessageClass)this.msgGroup.EVENT_RESET_NAME);
        try {
            socket.send(msg);
        }
        catch (Exception e) {
            this.log.error("Failed to send reset " + stream + " name feed ", (Throwable)e);
        }
    }

    void sendRefresh(String stream, int level, IEndPoint socket) {
        this.log.error("Sending refresh " + stream);
        MessageWrapper msg = new MessageWrapper((Object)new NameRefresh(stream), (IMessageClass)this.msgGroup.EVENT_REFRESH_NAME);
        try {
            socket.send(msg);
        }
        catch (Exception e) {
            this.log.error("Failed to send refresh " + stream + " name feed ", (Throwable)e);
        }
    }

    void sendFullMessage(Collection<NameRecord> records, String stream, int level, IEndPoint socket) {
        NameFeedSet payload = new NameFeedSet(stream, records);
        MessageWrapper msg = new MessageWrapper((Object)payload, (IMessageClass)this.msgGroup.EVENT_FULL_NAME);
        msg.addMetaInformation((MetaInformationCode)this.streamNameCode, stream);
        if (records.isEmpty()) {
            this.log.info("Empty full snapshot {}", (Object)stream);
        } else {
            try {
                socket.send(msg);
            }
            catch (Exception e) {
                this.log.error("Failed to send full message " + stream + " name feed ", (Throwable)e);
            }
        }
    }

    void sendDeleteMessage(Collection<NameRecord> records, String stream, int level, IEndPoint socket) {
        NameFeedSet payload = new NameFeedSet(stream, records);
        MessageWrapper msg = new MessageWrapper((Object)payload, (IMessageClass)this.msgGroup.EVENT_DELETE_NAME);
        msg.addMetaInformation((MetaInformationCode)this.streamNameCode, stream);
        try {
            socket.send(msg);
        }
        catch (Exception e) {
            this.log.error("Failed to send delete message" + stream + " name feed ", (Throwable)e);
        }
    }
}

