/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.namefeed.datastructure;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import jayeson.lib.feed.api.OddType;
import jayeson.lib.feed.api.SportType;
import jayeson.lib.namefeed.NameRecord;
import jayeson.lib.namefeed.SourceSportType;

public class NameFeedSet {
    public static final String STREAM_SEPARATOR = "_";
    final Set<NameRecord> nameFeedRecord;
    final String source;
    final SportType sportType;
    final OddType oddType;

    public NameFeedSet(String streamName, Collection<NameRecord> results) {
        this(NameFeedSet.getSourceSportType(streamName).getSource(), NameFeedSet.getSourceSportType(streamName).getSportType(), NameFeedSet.getSourceSportType(streamName).getOddType(), results);
    }

    public NameFeedSet(String source, SportType sportType, OddType oddType, Collection<NameRecord> results) {
        this.source = source;
        this.sportType = sportType;
        this.oddType = oddType;
        this.nameFeedRecord = new HashSet<NameRecord>(results);
    }

    public static String getStreamName(String stream) {
        return "NF_" + stream;
    }

    public static SourceSportType getSourceSportType(String streamName) {
        String[] parts = streamName.split(STREAM_SEPARATOR);
        SportType sportType = SportType.valueOf((String)parts[1]);
        OddType oddType = OddType.valueOf((String)parts[3]);
        String sportbook = parts[2];
        return new SourceSportType(sportbook, sportType, oddType);
    }

    public Set<NameRecord> getNameFeedRecords() {
        return this.nameFeedRecord;
    }

    public String getSource() {
        return this.source;
    }

    public SportType getSportType() {
        return this.sportType;
    }

    public OddType getOddType() {
        return this.oddType;
    }

    public String getStreamName() {
        return NameFeedSet.getStreamName(this.getSportType() + STREAM_SEPARATOR + this.getSource() + STREAM_SEPARATOR + this.getOddType());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nameFeedRecord == null ? 0 : this.nameFeedRecord.hashCode());
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NameFeedSet other = (NameFeedSet)obj;
        if (this.nameFeedRecord == null ? other.nameFeedRecord != null : !this.nameFeedRecord.equals(other.nameFeedRecord)) {
            return false;
        }
        return !(this.source == null ? other.source != null : !this.source.equals(other.source));
    }

    public String toString() {
        return "ResultSet [source=" + this.source + ", results=" + this.nameFeedRecord + "]";
    }
}

