/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.client;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import jayeson.lib.feed.api.IBetEvent;
import jayeson.lib.feed.api.IBetMatch;
import jayeson.lib.feed.api.IBetRecord;
import jayeson.lib.feed.api.PartitionKey;
import jayeson.lib.feed.core.B2Record;
import jayeson.lib.sports.client.DeleteEvent;
import jayeson.lib.sports.client.DeleteMatch;
import jayeson.lib.sports.client.DeleteOdd;
import jayeson.lib.sports.client.DeltaEventHandler;
import jayeson.lib.sports.client.InsertEvent;
import jayeson.lib.sports.client.InsertMatch;
import jayeson.lib.sports.client.InsertOdd;
import jayeson.lib.sports.client.Reset;
import jayeson.lib.sports.client.UpdateEvent;
import jayeson.lib.sports.client.UpdateMatch;
import jayeson.lib.sports.client.UpdateOdd;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushModeHandler
implements DeltaEventHandler<IBetMatch, IBetEvent, IBetRecord> {
    private static Logger log = LoggerFactory.getLogger(PushModeHandler.class);
    private String identifier;

    public PushModeHandler(String identifier) {
        this.identifier = identifier;
    }

    public String convertEpochToReadable(long epoch) {
        long new_epoch = epoch * 1000L;
        Date date = new Date(new_epoch);
        return date.toString();
    }

    @Override
    public void onInsertMatch(InsertMatch<IBetMatch> event) {
        String identifier = "PUSH_INSERT_MATCH";
        this.printMatch(identifier, event.get());
    }

    @Override
    public void onUpdateMatch(UpdateMatch<IBetMatch> event) {
        String identifier = "PUSH_UPDATE_MATCH";
        this.printMatch(identifier, event.get());
    }

    @Override
    public void onDeleteMatch(DeleteMatch<IBetMatch> event) {
        String identifier = "PUSH_DELETE_MATCH";
        this.printMatch(identifier, event.get());
    }

    @Override
    public void onInsertEvent(InsertEvent<IBetEvent> event) {
        String identifier = "PUSH_INSERT_EVENT";
        this.printEvent(identifier, event.get());
    }

    @Override
    public void onUpdateEvent(UpdateEvent<IBetEvent> event) {
        String identifier = "PUSH_UPDATE_EVENT";
        this.printEvent(identifier, event.get());
    }

    @Override
    public void onDeleteEvent(DeleteEvent<IBetEvent> event) {
        String identifier = "PUSH_DELETE_EVENT";
        this.printEvent(identifier, event.get());
    }

    @Override
    public void onInsertOdd(InsertOdd<IBetRecord> event) {
        String identifier = "PUSH_INSERT_ODD";
        this.printRecord(identifier, event.get());
    }

    @Override
    public void onUpdateOdd(UpdateOdd<IBetRecord> event) {
        String identifier = "PUSH_UPDATE_ODD";
        this.printRecord(identifier, event.get());
    }

    @Override
    public void onDeleteOdd(DeleteOdd<IBetRecord> event) {
        String identifier = "PUSH_DELETE_ODD";
        this.printRecord(identifier, event.get());
    }

    @Override
    public void onReset(Reset resetKeys) {
        resetKeys.get().stream().forEach(key -> log.info("PUSH_RESET {}", key));
    }

    @Override
    public void onSwitchFilterStart() {
        log.info("SWITCH_FILTER_START");
    }

    @Override
    public void onSwitchFilterEnd() {
        log.info("SWITCH_FILTER_END");
    }

    @Override
    public void onFullSnapshotStart() {
        log.info("FULLSNAPSHOT_START");
    }

    @Override
    public void onFullSnapshotEnd() {
        log.info("FULLSNAPSHOT_END");
    }

    @Override
    public void onSwitchFilterFail() {
        log.info("SWITCH_FILTER_FAIL");
    }

    @Override
    public void onRefresh(List<PartitionKey> keys) {
        log.info("Refresh: {}", keys);
    }

    private void printRecord(String identifier, Collection<IBetRecord> collection) {
        collection.stream().forEach(r -> log.info(this.identifier + " " + identifier + " " + r.matchId() + "_" + r.eventId() + "_" + r.source() + "_" + r.oddType() + "_" + r.id() + "_" + ((B2Record)r).pivotType()));
    }

    private void printEvent(String identifier, Collection<IBetEvent> collection) {
        collection.stream().forEach(e -> {
            String keys = e.eventStates().stream().map(s -> s.partitionKey()).collect(Collectors.toList()).toString();
            log.info(this.identifier + " " + identifier + " " + e.matchId() + "_" + e.id() + "_" + keys);
        });
    }

    private void printMatch(String identifier, Collection<IBetMatch> collection) {
        for (IBetMatch iBetMatch : collection) {
        }
        collection.stream().forEach(m -> log.info(this.identifier + " " + identifier + " " + m.id() + " " + this.convertEpochToReadable(m.startTime())));
    }
}

