/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.codec;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jayeson.lib.delivery.api.exceptions.MessageCorruptedException;
import jayeson.lib.delivery.api.exceptions.PipelineException;
import jayeson.lib.delivery.api.messages.IMessageGroup;
import jayeson.lib.delivery.api.messages.IPipelineConstructor;
import jayeson.lib.delivery.core.messages.BaseMessageClass;
import jayeson.lib.sports.codec.FilterData;
import jayeson.lib.sports.codec.FilterRequest;
import jayeson.lib.sports.core.SportsFeedMessageGroup;
import jayeson.model.filterrules.js.DefaultFilterRuleDeserializer;
import jayeson.model.filterrules.js.DefaultFilterRuleTypeMap;
import jayeson.model.filterrules.js.JSonFilterRuleTypeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterMessageClass
extends BaseMessageClass<FilterRequest>
implements IPipelineConstructor {
    private static final Logger log = LoggerFactory.getLogger(FilterMessageClass.class);
    public static final String NAME_SPACE_FIELD_NAME = "namespace";
    public static final String FILTER_RULES_FIELD_NAME = "filterRules";
    public static final String CLASS_TYPE_FIELD_NAME = "ruleType";
    public static final String CLASS_PROPERTY_NAME = "__c__";
    public static final String CLASS_PROPERTY_FULL_NAME = "class";
    private List<ChannelHandler> decoders;
    private List<ChannelHandler> encoders;
    private DefaultFilterRuleDeserializer deserializer;
    private ObjectMapper mapper;

    public FilterMessageClass(SportsFeedMessageGroup group, int id, Map<String, JSonFilterRuleTypeMap> filterCodec) {
        super(FilterRequest.class, (IMessageGroup)group, (byte)id);
        if (filterCodec == null) {
            log.info("No RuleMap Specified. Using default RuleMap Only");
            filterCodec = new HashMap<String, JSonFilterRuleTypeMap>();
        }
        this.deserializer = new DefaultFilterRuleDeserializer((JSonFilterRuleTypeMap)DefaultFilterRuleTypeMap.instance());
        for (JSonFilterRuleTypeMap ruleMap : filterCodec.values()) {
            this.deserializer.addTypeMapper(ruleMap);
        }
        this.decoders = Arrays.asList(new ChannelHandler[]{new StringDecoder(Charset.defaultCharset()), new Decoder()});
        this.encoders = Arrays.asList(new ChannelHandler[]{new Encoder(), new StringEncoder(Charset.defaultCharset())});
        this.mapper = new ObjectMapper();
    }

    public FilterRequest read(Object msg) throws JsonProcessingException, IOException {
        if (msg instanceof String) {
            String jsonString = (String)msg;
            ObjectNode jsonNode = (ObjectNode)this.mapper.readTree(jsonString);
            int requestId = jsonNode.get("requestId").asInt();
            Collection rules = this.deserializer.parse(jsonString);
            FilterData filterData = new FilterData("", rules);
            FilterRequest filterRequest = new FilterRequest(requestId, filterData);
            return filterRequest;
        }
        log.error("Received message is {}", msg.getClass());
        PipelineException ex = new PipelineException("Received Message is not String");
        throw ex;
    }

    public String write(Object msg) throws Exception {
        if (msg instanceof FilterRequest) {
            FilterRequest data = (FilterRequest)msg;
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jNode = mapper.valueToTree((Object)data);
            JsonNode arrayNode = jNode.get(FILTER_RULES_FIELD_NAME);
            for (JsonNode node : arrayNode) {
                ((ObjectNode)node).remove(CLASS_PROPERTY_NAME);
                ((ObjectNode)node).remove(CLASS_PROPERTY_FULL_NAME);
            }
            return mapper.writeValueAsString((Object)jNode);
        }
        log.error("Received message is {}", msg.getClass());
        MessageCorruptedException ex = new MessageCorruptedException("Message is not SetFilterArguments");
        throw ex;
    }

    public List<ChannelHandler> inboundHandlers(Channel c) {
        return this.decoders;
    }

    public List<ChannelHandler> outboundHandlers(Channel c) {
        return this.encoders;
    }

    public IPipelineConstructor constructor() {
        return this;
    }

    public Class<FilterRequest> instanceClass() {
        return FilterRequest.class;
    }

    @ChannelHandler.Sharable
    private class Encoder
    extends ChannelOutboundHandlerAdapter {
        private Encoder() {
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            String json = FilterMessageClass.this.write(msg);
            ctx.write((Object)json, promise);
        }
    }

    @ChannelHandler.Sharable
    private class Decoder
    extends ChannelInboundHandlerAdapter {
        private Decoder() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws JsonProcessingException, IOException {
            FilterRequest data = FilterMessageClass.this.read(msg);
            ctx.fireChannelRead((Object)data);
        }
    }
}

