/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.codec;

import com.google.inject.Singleton;
import java.util.List;
import jayeson.lib.feed.api.OddType;
import jayeson.lib.feed.api.PartitionKey;
import jayeson.lib.feed.api.SportType;
import jayeson.lib.sports.codec.StringPool;
import jayeson.lib.sports.protobuf.Sports;

@Singleton
public class PartitionCodec {
    public Sports.PartitionKey encode(PartitionKey in, StringPool pool) {
        Sports.PartitionKey.Builder out = Sports.PartitionKey.newBuilder();
        out.setSource(pool.getIndexOf(in.source()));
        switch (in.oddType()) {
            case LIVE: {
                out.setOddType(Sports.OddType.LIVE);
                break;
            }
            case TODAY: {
                out.setOddType(Sports.OddType.TODAY);
                break;
            }
            case EARLY: {
                out.setOddType(Sports.OddType.EARLY);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown odd type");
            }
        }
        out.setSport(Sports.SportType.valueOf(in.sportType().name()));
        return out.build();
    }

    public PartitionKey decode(Sports.PartitionKey in, List<String> pool) {
        OddType type;
        switch (in.getOddType()) {
            case LIVE: {
                type = OddType.LIVE;
                break;
            }
            case TODAY: {
                type = OddType.TODAY;
                break;
            }
            case EARLY: {
                type = OddType.EARLY;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown odd type");
            }
        }
        SportType sportType = SportType.valueOf((String)in.getSport().name());
        return new PartitionKey(pool.get(in.getSource()), type, sportType);
    }
}

