/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.codec;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jayeson.lib.feed.api.IBetEvent;
import jayeson.lib.feed.api.IBetEventState;
import jayeson.lib.feed.api.IBetMatch;
import jayeson.lib.feed.api.IBetRecord;
import jayeson.lib.feed.api.IParticipantStats;
import jayeson.lib.feed.api.LBType;
import jayeson.lib.feed.api.OddFormat;
import jayeson.lib.feed.api.OddType;
import jayeson.lib.feed.api.PartitionKey;
import jayeson.lib.feed.api.TimeType;
import jayeson.lib.feed.api.twoside.PivotBias;
import jayeson.lib.feed.api.twoside.PivotType;
import jayeson.lib.feed.tennis.TennisEvent;
import jayeson.lib.feed.tennis.TennisEventImpl;
import jayeson.lib.feed.tennis.TennisEventState;
import jayeson.lib.feed.tennis.TennisEventType;
import jayeson.lib.feed.tennis.TennisGender;
import jayeson.lib.feed.tennis.TennisMatch;
import jayeson.lib.feed.tennis.TennisMatchImpl;
import jayeson.lib.feed.tennis.TennisRecord;
import jayeson.lib.feed.tennis.TennisRecordImpl;
import jayeson.lib.feed.tennis.TennisSegment;
import jayeson.lib.feed.tennis.TennisStats;
import jayeson.lib.feed.tennis.TennisTimeType;
import jayeson.lib.sports.codec.CodecHelper;
import jayeson.lib.sports.codec.EncodeAction;
import jayeson.lib.sports.codec.ICodec;
import jayeson.lib.sports.codec.StringPool;
import jayeson.lib.sports.protobuf.Sports;
import jayeson.lib.sports.protobuf.Tennis;

class TennisCodec
implements ICodec {
    private CodecHelper codecHelper;

    @Inject
    public TennisCodec(CodecHelper codecHelper) {
        this.codecHelper = codecHelper;
    }

    @Override
    public Sports.BaseMatch encodeMatch(IBetMatch in, StringPool pool, EncodeAction action, PartitionKey key) {
        if (!(in instanceof TennisMatch) || !this.codecHelper.verifyKey(in, key)) {
            return null;
        }
        return this.encodeMatch(in, pool);
    }

    @Override
    public Sports.BaseMatch encodeMatch(IBetMatch in, StringPool pool) {
        TennisMatch input = (TennisMatch)in;
        Sports.BaseMatch.Builder baseMatchBuilder = this.codecHelper.getTennisMatchBuilder(in, pool);
        Tennis.TennisMatch.Builder tennisMatchBuilder = Tennis.TennisMatch.newBuilder();
        if (input.gender() != null) {
            tennisMatchBuilder.setGender(Tennis.TennisMatch.Gender.valueOf(input.gender().name()));
        }
        baseMatchBuilder.setTennisMatch(tennisMatchBuilder);
        return baseMatchBuilder.build();
    }

    @Override
    public Sports.BaseEvent encodeEvent(IBetEvent in, StringPool pool, EncodeAction action, PartitionKey key) {
        if (!(in instanceof TennisEvent) || !this.codecHelper.verifyKey(in, key)) {
            return null;
        }
        TennisEvent input = (TennisEvent)in;
        Sports.BaseEvent.Builder baseEventBuilder = this.codecHelper.getTennisEventBuilder(in, pool);
        Sports.EventType.Builder eventTypeBuilder = Sports.EventType.newBuilder();
        eventTypeBuilder.setTennisEventType(Tennis.TennisEvent.Type.valueOf(input.eventType().name()));
        baseEventBuilder.setEventType(eventTypeBuilder);
        for (IBetEventState state : in.eventStates()) {
            Sports.BaseEventState pbufState = this.encodeState(state, pool, key);
            if (pbufState == null) continue;
            baseEventBuilder.setState(pbufState);
        }
        return baseEventBuilder.build();
    }

    @Override
    public Sports.BaseEvent encodeEvent(IBetEvent in, StringPool pool) {
        TennisEvent input = (TennisEvent)in;
        Sports.BaseEvent.Builder baseEventBuilder = this.codecHelper.getTennisEventBuilder(in, pool);
        Sports.EventType.Builder eventTypeBuilder = Sports.EventType.newBuilder();
        eventTypeBuilder.setTennisEventType(Tennis.TennisEvent.Type.valueOf(input.eventType().name()));
        baseEventBuilder.setEventType(eventTypeBuilder);
        for (IBetEventState state : in.eventStates()) {
            Sports.BaseEventState pbufState = this.encodeState(state, pool);
            if (pbufState == null) continue;
            baseEventBuilder.setState(pbufState);
        }
        return baseEventBuilder.build();
    }

    @Override
    public Sports.BaseRecord encodeRecord(IBetRecord in, StringPool pool, EncodeAction action, boolean excludeRateId, PartitionKey key) {
        if (!(in instanceof TennisRecord) || !this.codecHelper.verifyKey(in, key)) {
            return null;
        }
        return this.encodeRecord(in, pool, excludeRateId);
    }

    @Override
    public Sports.BaseRecord encodeRecord(IBetRecord in, StringPool pool, boolean excludeRateId) {
        Sports.BaseRecord.Builder baseRecordBuilder = this.codecHelper.getBaseRecordBuilder(in, pool, excludeRateId);
        Sports.TimeType encodedTimeType = this.encodeTimeType(in.timeType());
        baseRecordBuilder.setTimeType(encodedTimeType);
        TennisRecord tennisRecord = (TennisRecord)in;
        Tennis.TennisRecord.Builder tennisBuilder = Tennis.TennisRecord.newBuilder();
        tennisBuilder.setSwapped(tennisRecord.isSwapped());
        baseRecordBuilder.setTennisRecord(tennisBuilder.build());
        return baseRecordBuilder.build();
    }

    Sports.BaseEventState encodeState(IBetEventState in, StringPool pool, PartitionKey key) {
        if (!(in instanceof TennisEventState) || !this.codecHelper.verifyKey(in, key)) {
            return null;
        }
        return this.encodeState(in, pool);
    }

    Sports.BaseEventState encodeState(IBetEventState in, StringPool pool) {
        TennisEventState tennisEventState = (TennisEventState)in;
        Sports.BaseEventState.Builder baseEventStateBuilder = this.codecHelper.getBaseEventStateBuilder(in, pool);
        Tennis.TennisEventState.Builder tennisEventStateBuilder = Tennis.TennisEventState.newBuilder();
        tennisEventStateBuilder.setGame(tennisEventState.game());
        tennisEventStateBuilder.setSet(tennisEventState.set());
        tennisEventStateBuilder.setBookPriority(tennisEventState.bookPriority());
        tennisEventStateBuilder.setSegment(Tennis.TennisEventState.Segment.valueOf(tennisEventState.segment().name()));
        baseEventStateBuilder.setTennisEventState(tennisEventStateBuilder);
        return baseEventStateBuilder.build();
    }

    @Override
    public Collection<IBetMatch> decodeMatch(Collection<Sports.BaseMatch> in, List<String> pool, EncodeAction action, PartitionKey partition) {
        ArrayList<IBetMatch> result = new ArrayList<IBetMatch>(in.size());
        for (Sports.BaseMatch baseMatch : in) {
            String id = pool.get(baseMatch.getId());
            String p1 = null;
            String p2 = null;
            List<TennisEvent> events = Arrays.asList(new TennisEvent[0]);
            long startTime = 0L;
            String league = null;
            TennisGender gender = null;
            Map<String, String> meta = null;
            String country = null;
            p1 = pool.get(baseMatch.getParticipants(0));
            p2 = pool.get(baseMatch.getParticipants(1));
            startTime = baseMatch.getStartTime();
            league = pool.get(baseMatch.getLeague());
            if (baseMatch.getTennisMatch().getGender() != null) {
                gender = TennisGender.valueOf((String)baseMatch.getTennisMatch().getGender().name());
            }
            meta = new HashMap<String, String>(baseMatch.getMetaInfoMap());
            country = pool.get(baseMatch.getCountry());
            if (partition != null) {
                meta = CodecHelper.populatePKIntoMetaInfo(meta, partition);
            }
            IBetMatch curr = this.getMatch(id, events, p1, p2, startTime, league, gender, country, meta);
            result.add(curr);
        }
        return result;
    }

    private IBetMatch getMatch(String id, Collection<TennisEvent> events, String p1, String p2, long startTime, String league, TennisGender gender, String country, Map<String, String> meta) {
        return new TennisMatchImpl(p1, p2, startTime, events, id, league, gender, country, meta);
    }

    @Override
    public Collection<IBetMatch> decodeEvent(Collection<Sports.BaseEvent> in, List<String> pool, EncodeAction action, PartitionKey partition) {
        ArrayList<IBetMatch> result = new ArrayList<IBetMatch>(in.size());
        HashMap<String, List> matchIdToEvents = new HashMap<String, List>();
        for (Sports.BaseEvent baseEvent : in) {
            String id = pool.get(baseEvent.getId());
            List<TennisRecord> records = Arrays.asList(new TennisRecord[0]);
            String matchId = pool.get(baseEvent.getMatchId());
            TennisEventType type = null;
            HashMap<String, String> meta = null;
            type = TennisEventType.valueOf((String)baseEvent.getEventType().getTennisEventType().name());
            meta = new HashMap<String, String>(baseEvent.getMetaInfoMap());
            List<TennisEventState> states = Arrays.asList(this.decodeState(matchId, id, baseEvent.getState(), pool, action, partition));
            TennisEvent event = this.getEvent(id, records, states, matchId, type, meta);
            List events = matchIdToEvents.computeIfAbsent(matchId, currMatchId -> new ArrayList());
            events.add(event);
        }
        for (Map.Entry entry : matchIdToEvents.entrySet()) {
            String matchId = (String)entry.getKey();
            IBetMatch currMatch = this.getMatch(matchId, (Collection)entry.getValue(), null, null, 0L, null, null, null, new HashMap<String, String>());
            result.add(currMatch);
        }
        return result;
    }

    private TennisEvent getEvent(String id, Collection<TennisRecord> records, Collection<TennisEventState> states, String matchId, TennisEventType type, Map<String, String> meta) {
        return new TennisEventImpl(id, records, states, matchId, type, meta);
    }

    @Override
    public Collection<IBetMatch> decodeRecord(Collection<Sports.BaseRecord> in, List<String> pool, EncodeAction action, PartitionKey partition) {
        ArrayList<IBetMatch> result = new ArrayList<IBetMatch>(in.size());
        HashMap<String, Map> groupEventsByMatchIdAndEventId = new HashMap<String, Map>();
        HashMap<String, Map> matchEventIdToRecords = new HashMap<String, Map>();
        for (Sports.BaseRecord baseRecord : in) {
            long id = baseRecord.getId();
            OddType oddType = null;
            LBType lbType = null;
            TimeType timeType = null;
            String sportbook = pool.get(baseRecord.getSource());
            OddFormat oddFormat = null;
            Map<String, String> meta = null;
            float rateOver = 0.0f;
            float rateUnder = 0.0f;
            float rateEqual = 0.0f;
            String rateOverId = null;
            String rateUnderId = null;
            String rateEqualId = null;
            float pivotValue = 0.0f;
            PivotType pivotType = null;
            PivotBias pivotBias = null;
            oddType = OddType.valueOf((String)baseRecord.getOddType().name());
            lbType = LBType.valueOf((String)baseRecord.getLbType().name());
            timeType = this.decodeTimeType(baseRecord.getTimeType());
            oddFormat = OddFormat.valueOf((String)baseRecord.getFormat().name());
            meta = baseRecord.getMetaInfoMap();
            try {
                rateOver = baseRecord.getRates(0);
                rateUnder = baseRecord.getRates(1);
                rateEqual = baseRecord.getRates(2);
                pivotValue = baseRecord.getPivotValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            pivotType = PivotType.valueOf((String)baseRecord.getPivotType().name());
            pivotBias = PivotBias.valueOf((String)baseRecord.getPivotBias().name());
            try {
                rateOverId = pool.get(baseRecord.getRateIds(0));
                rateUnderId = pool.get(baseRecord.getRateIds(1));
                rateEqualId = pool.get(baseRecord.getRateIds(2));
            }
            catch (Exception exception) {
                // empty catch block
            }
            String matchId = pool.get(baseRecord.getMatchId());
            String eventId = pool.get(baseRecord.getEventId());
            boolean isSwapped = baseRecord.getTennisRecord().getSwapped();
            TennisRecordImpl tennisRecord = new TennisRecordImpl(matchId, eventId, id, oddType, lbType, timeType, sportbook, oddFormat, meta, rateOver, rateUnder, rateEqual, pivotValue, pivotType, pivotBias, rateOverId, rateUnderId, rateEqualId, isSwapped);
            Map eventMapping = matchEventIdToRecords.computeIfAbsent(matchId, key -> new HashMap());
            ArrayList recordsList = eventMapping.computeIfAbsent(eventId, key -> new ArrayList());
            recordsList.add(tennisRecord);
            Map tennisEventMap = groupEventsByMatchIdAndEventId.computeIfAbsent(matchId, key -> new HashMap());
            tennisEventMap.computeIfAbsent(eventId, key -> this.getEvent(eventId, recordsList, null, matchId, null, new HashMap<String, String>()));
        }
        for (Map.Entry entry : groupEventsByMatchIdAndEventId.entrySet()) {
            String matchId = (String)entry.getKey();
            result.add(this.getMatch(matchId, ((Map)entry.getValue()).values(), null, null, 0L, null, null, null, new HashMap<String, String>()));
        }
        return result;
    }

    TennisEventState decodeState(String matchId, String eventId, Sports.BaseEventState baseEventState, List<String> pool, EncodeAction action, PartitionKey partition) {
        TennisStats statsOne = null;
        TennisStats statsTwo = null;
        TennisSegment segment = null;
        int duration = 0;
        int bookPriority = 0;
        int set = -1;
        int game = -1;
        List<Integer> hostStat = baseEventState.getParticipantStats(0).getScoresList();
        List<Integer> guestStat = baseEventState.getParticipantStats(1).getScoresList();
        statsOne = new TennisStats(hostStat);
        statsTwo = new TennisStats(guestStat);
        duration = baseEventState.getDuration();
        Tennis.TennisEventState eventStateProto = baseEventState.getTennisEventState();
        set = eventStateProto.getSet();
        game = eventStateProto.getGame();
        segment = TennisSegment.valueOf((String)eventStateProto.getSegment().name());
        bookPriority = baseEventState.getTennisEventState().getBookPriority();
        TennisEventState tennisEventState = new TennisEventState((IParticipantStats)statsOne, (IParticipantStats)statsTwo, duration, partition, matchId, eventId, set, game, segment, bookPriority);
        return tennisEventState;
    }

    @Override
    public Sports.TimeType encodeTimeType(TimeType timeType) {
        Sports.TimeType.Builder timeTypeBuilder = Sports.TimeType.newBuilder();
        Tennis.TennisTimeType.Builder tennisTimeTypeBuilder = Tennis.TennisTimeType.newBuilder();
        TennisTimeType tennisTimeType = (TennisTimeType)timeType;
        tennisTimeTypeBuilder.setGame(tennisTimeType.game());
        tennisTimeTypeBuilder.setMatch(tennisTimeType.match());
        tennisTimeTypeBuilder.setSet(tennisTimeType.set());
        timeTypeBuilder.setTennisTimeType(tennisTimeTypeBuilder);
        return timeTypeBuilder.build();
    }

    @Override
    public TimeType decodeTimeType(Sports.TimeType timeType) {
        Tennis.TennisTimeType protoTimeType = timeType.getTennisTimeType();
        TennisTimeType decodedTimeType = new TennisTimeType(protoTimeType.getMatch(), protoTimeType.getSet(), protoTimeType.getGame());
        return decodedTimeType;
    }
}

