/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jayeson.lib.delivery.api.messages.IMessageClass;
import jayeson.lib.feed.api.IBetEvent;
import jayeson.lib.feed.api.IBetEventState;
import jayeson.lib.feed.api.IBetMatch;
import jayeson.lib.feed.api.IBetRecord;
import jayeson.lib.feed.api.PartitionKey;
import jayeson.lib.sports.codec.DeleteEventMessageClass;
import jayeson.lib.sports.codec.DeleteMatchMessageClass;
import jayeson.lib.sports.codec.DeleteOddMessageClass;
import jayeson.lib.sports.codec.InsertEventMessageClass;
import jayeson.lib.sports.codec.InsertMatchMessageClass;
import jayeson.lib.sports.codec.InsertOddMessageClass;
import jayeson.lib.sports.codec.RefreshMessageClass;
import jayeson.lib.sports.codec.ResetMessageClass;
import jayeson.lib.sports.codec.UpdateEventMessageClass;
import jayeson.lib.sports.codec.UpdateMatchMessageClass;
import jayeson.lib.sports.codec.UpdateOddMessageClass;
import jayeson.lib.sports.core.SportsFeedMessageGroup;
import jayeson.lib.sports.datastructure.DeltaOutgoingImpl;
import jayeson.lib.sports.datastructure.IndexedSnapshot;
import jayeson.lib.sports.datastructure.IndexedSnapshotImpl;
import jayeson.lib.sports.datastructure.MessageBeforeTransform;
import jayeson.lib.sports.datastructure.Outgoing;
import jayeson.lib.sports.mutable.BuilderProvider;
import jayeson.lib.sports.mutable.IBetEventBuilder;
import jayeson.lib.sports.mutable.IBetMatchBuilder;
import jayeson.lib.sports.mutable.IIndexedSnapshotBuilder;
import jayeson.model.IDataFilter;
import jayeson.model.filter.FilterableSnapshot;
import jayeson.model.filterrules.MatchEventId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotUtil {
    private static Logger log = LoggerFactory.getLogger(SnapshotUtil.class);

    public static MessageBeforeTransform combineSnapshots(IMessageClass<?> childMsgCls, IndexedSnapshot childSs, IndexedSnapshot parentSs) {
        if (childMsgCls instanceof InsertOddMessageClass || childMsgCls instanceof UpdateOddMessageClass || childMsgCls instanceof DeleteOddMessageClass) {
            return SnapshotUtil.processOdds(childMsgCls, childSs, parentSs);
        }
        if (childMsgCls instanceof InsertEventMessageClass || childMsgCls instanceof UpdateEventMessageClass || childMsgCls instanceof DeleteEventMessageClass) {
            return SnapshotUtil.processEvents(childMsgCls, childSs, parentSs);
        }
        if (childMsgCls instanceof InsertMatchMessageClass || childMsgCls instanceof UpdateMatchMessageClass || childMsgCls instanceof DeleteMatchMessageClass) {
            return SnapshotUtil.processMatches(childMsgCls, childSs, parentSs);
        }
        if (childMsgCls instanceof ResetMessageClass) {
            return SnapshotUtil.processReset(childMsgCls, childSs, parentSs);
        }
        if (childMsgCls instanceof RefreshMessageClass) {
            return SnapshotUtil.processRefresh(childMsgCls, childSs, parentSs);
        }
        log.error("FATAL: Received non feed message class {}.Shouldnt come here", childMsgCls);
        MessageBeforeTransform messageBefore = new MessageBeforeTransform();
        messageBefore.setAfterSs(parentSs);
        return messageBefore;
    }

    private static MessageBeforeTransform processRefresh(IMessageClass<?> childMsgCls, IndexedSnapshot childSs, IndexedSnapshot parentSs) {
        MessageBeforeTransform messageBefore = new MessageBeforeTransform();
        IIndexedSnapshotBuilder sBuilder = BuilderProvider.getSnapshotBuilder(parentSs);
        Set<PartitionKey> ps = childSs.getPartitions();
        for (PartitionKey key : ps) {
            Long time = childSs.getPartitionMap().get(key);
            sBuilder.markPartitionAsUpdated(key, time);
        }
        messageBefore.setAfterSs((IndexedSnapshot)sBuilder.build());
        return messageBefore;
    }

    private static MessageBeforeTransform processReset(IMessageClass<?> childMsgCls, IndexedSnapshot childSs, IndexedSnapshot parentSs) {
        IIndexedSnapshotBuilder sBuilder = BuilderProvider.getSnapshotBuilder(parentSs);
        MessageBeforeTransform messageBefore = new MessageBeforeTransform();
        Set<PartitionKey> ps = childSs.getPartitions();
        for (PartitionKey key : ps) {
            sBuilder.reset(key);
            Long time = childSs.getPartitionMap().get(key);
            sBuilder.markPartitionAsUpdated(key, time);
        }
        messageBefore.setAfterSs((IndexedSnapshot)sBuilder.build());
        return messageBefore;
    }

    private static MessageBeforeTransform processMatches(IMessageClass<?> childMsgCls, IndexedSnapshot childSs, IndexedSnapshot parentSs) {
        IIndexedSnapshotBuilder sBuilder = BuilderProvider.getSnapshotBuilder(parentSs);
        String suppressId = null;
        Iterator childMatchIt = childSs.matches().iterator();
        MessageBeforeTransform messageBefore = new MessageBeforeTransform();
        while (childMatchIt.hasNext()) {
            suppressId = null;
            IBetMatch childMatch = (IBetMatch)childMatchIt.next();
            if (childMsgCls instanceof InsertMatchMessageClass) {
                suppressId = sBuilder.insertChild(childMatch);
                if (suppressId != null) {
                    messageBefore.addSuppressMatch(suppressId);
                    continue;
                }
                messageBefore.addInsertMatch(childMatch.id());
                continue;
            }
            if (childMsgCls instanceof UpdateMatchMessageClass) {
                sBuilder.updateChild(childMatch);
                continue;
            }
            if (!(childMsgCls instanceof DeleteMatchMessageClass)) continue;
            suppressId = sBuilder.deleteChild(childMatch);
            if (suppressId != null) {
                messageBefore.addSuppressMatch(suppressId);
                continue;
            }
            messageBefore.addDeleteMatch(childMatch.id());
        }
        Set<PartitionKey> ps = childSs.getPartitions();
        for (PartitionKey key : ps) {
            Long time = childSs.getPartitionMap().get(key);
            sBuilder.markPartitionAsUpdated(key, time);
        }
        messageBefore.setAfterSs((IndexedSnapshot)sBuilder.build());
        return messageBefore;
    }

    private static MessageBeforeTransform processEvents(IMessageClass<?> childMsgCls, IndexedSnapshot childSs, IndexedSnapshot parentSs) {
        IIndexedSnapshotBuilder sBuilder = BuilderProvider.getSnapshotBuilder(parentSs);
        String suppressId = null;
        Iterator childMatchIt = childSs.matches().iterator();
        MessageBeforeTransform messageBefore = new MessageBeforeTransform();
        while (childMatchIt.hasNext()) {
            IBetMatch childMatch = (IBetMatch)childMatchIt.next();
            IBetMatch parentMatch = parentSs.match(childMatch.id());
            if (parentMatch == null) {
                log.error("Cannot find Match {} while processing {}", (Object)childMatch.id(), childMsgCls);
                continue;
            }
            IBetMatchBuilder matchBuilder = BuilderProvider.getBuilder(parentMatch);
            for (IBetEvent childEvent : childMatch.events()) {
                if (childMsgCls instanceof InsertEventMessageClass) {
                    suppressId = matchBuilder.insertChild(childEvent);
                    if (suppressId != null) {
                        messageBefore.addTransformEvent(new MatchEventId(childEvent.matchId(), childEvent.id()));
                        continue;
                    }
                    messageBefore.addInsertEvent(new MatchEventId(childEvent.matchId(), childEvent.id()));
                    continue;
                }
                if (childMsgCls instanceof UpdateEventMessageClass) {
                    matchBuilder.updateChild(childEvent);
                    continue;
                }
                if (!(childMsgCls instanceof DeleteEventMessageClass)) continue;
                suppressId = matchBuilder.deleteChild(childEvent);
                if (suppressId != null) {
                    messageBefore.addTransformEvent(new MatchEventId(childEvent.matchId(), childEvent.id()));
                    continue;
                }
                messageBefore.addDeleteEvent(new MatchEventId(childEvent.matchId(), childEvent.id()));
            }
            sBuilder.replaceMatch((IBetMatch)matchBuilder.build());
        }
        Set<PartitionKey> ps = childSs.getPartitions();
        for (PartitionKey key : ps) {
            Long time = childSs.getPartitionMap().get(key);
            sBuilder.markPartitionAsUpdated(key, time);
        }
        messageBefore.setAfterSs((IndexedSnapshot)sBuilder.build());
        messageBefore.setBeforeSs(parentSs);
        return messageBefore;
    }

    private static MessageBeforeTransform processOdds(IMessageClass<?> childMsgCls, IndexedSnapshot childSs, IndexedSnapshot parentSs) {
        IIndexedSnapshotBuilder sBuilder = BuilderProvider.getSnapshotBuilder(parentSs);
        MessageBeforeTransform messageBefore = new MessageBeforeTransform();
        for (IBetMatch childMatch : childSs.matches()) {
            IBetMatch parentMatch = parentSs.match(childMatch.id());
            if (parentMatch == null) {
                log.error("Cannot find Match {} while processing {}", (Object)childMatch.id(), childMsgCls);
                continue;
            }
            IBetMatchBuilder matchBuilder = BuilderProvider.getBuilder(parentMatch);
            for (IBetEvent childEvent : childMatch.events()) {
                IBetEvent parentEvent = parentMatch.event(childEvent.id());
                if (parentEvent == null) {
                    log.error("Cannot find Event {}_{} while processing {}", new Object[]{childMatch.id(), childEvent.id(), childMsgCls});
                    continue;
                }
                IBetEventBuilder clonedparentEvent = BuilderProvider.getBuilder(parentEvent);
                for (IBetRecord rec : childEvent.records()) {
                    if (childMsgCls instanceof InsertOddMessageClass) {
                        clonedparentEvent.insertChild(rec);
                        continue;
                    }
                    if (childMsgCls instanceof UpdateOddMessageClass) {
                        clonedparentEvent.updateChild(rec);
                        continue;
                    }
                    if (!(childMsgCls instanceof DeleteOddMessageClass)) continue;
                    clonedparentEvent.deleteChild(rec);
                }
                matchBuilder.replaceEvent((IBetEvent)clonedparentEvent.build());
            }
            sBuilder.replaceMatch((IBetMatch)matchBuilder.build());
        }
        Set<PartitionKey> ps = childSs.getPartitions();
        for (PartitionKey key : ps) {
            Long time = childSs.getPartitionMap().get(key);
            sBuilder.markPartitionAsUpdated(key, time);
        }
        messageBefore.setAfterSs((IndexedSnapshot)sBuilder.build());
        return messageBefore;
    }

    public static _DiffResult getDiffSnapshots(IndexedSnapshot full, IDataFilter oldFilter, IDataFilter newFilter, SportsFeedMessageGroup grp) {
        IndexedSnapshot oldFull = null;
        IndexedSnapshot newFull = null;
        oldFull = oldFilter == null ? full : new IndexedSnapshotImpl(new FilterableSnapshot(full.matches(), oldFilter).matches(), full.getPartitionMap());
        oldFull = SnapshotUtil.constructFilteredSnapshot(oldFull);
        newFull = newFilter == null ? full : new IndexedSnapshotImpl(new FilterableSnapshot(full.matches(), newFilter).matches(), full.getPartitionMap());
        newFull = SnapshotUtil.constructFilteredSnapshot(newFull);
        List<_Pair<IIndexedSnapshotBuilder>> builderPair = SnapshotUtil._manipulateMatches(oldFull, newFull);
        IndexedSnapshot deleteOddSnapshot = (IndexedSnapshot)((IIndexedSnapshotBuilder)builderPair.get((int)2).delete).build();
        IndexedSnapshot insertOddSnapshot = (IndexedSnapshot)((IIndexedSnapshotBuilder)builderPair.get((int)2).insert).build();
        IndexedSnapshot deleteEventSnapshot = (IndexedSnapshot)((IIndexedSnapshotBuilder)builderPair.get((int)1).delete).build();
        IndexedSnapshot insertEventSnapshot = (IndexedSnapshot)((IIndexedSnapshotBuilder)builderPair.get((int)1).insert).build();
        IndexedSnapshot deleteMatchSnapshot = (IndexedSnapshot)((IIndexedSnapshotBuilder)builderPair.get((int)0).delete).build();
        IndexedSnapshot insertMatchSnapshot = (IndexedSnapshot)((IIndexedSnapshotBuilder)builderPair.get((int)0).insert).build();
        ArrayList<Outgoing> messages = new ArrayList<Outgoing>();
        if (!deleteOddSnapshot.matches().isEmpty()) {
            DeltaOutgoingImpl deleteOdd = new DeltaOutgoingImpl((IMessageClass<?>)grp.DATA_DELETE_ODD, deleteOddSnapshot);
            messages.add(deleteOdd);
        }
        if (!deleteEventSnapshot.matches().isEmpty()) {
            DeltaOutgoingImpl deleteEvent = new DeltaOutgoingImpl((IMessageClass<?>)grp.DATA_DELETE_EVENT, deleteEventSnapshot);
            messages.add(deleteEvent);
        }
        if (!deleteMatchSnapshot.matches().isEmpty()) {
            DeltaOutgoingImpl deleteMatch = new DeltaOutgoingImpl((IMessageClass<?>)grp.DATA_DELETE_MATCH, deleteMatchSnapshot);
            messages.add(deleteMatch);
        }
        if (!insertMatchSnapshot.matches().isEmpty()) {
            DeltaOutgoingImpl inesrtMatch = new DeltaOutgoingImpl((IMessageClass<?>)grp.DATA_INSERT_MATCH, insertMatchSnapshot);
            messages.add(inesrtMatch);
        }
        if (!insertEventSnapshot.matches().isEmpty()) {
            DeltaOutgoingImpl insertEvent = new DeltaOutgoingImpl((IMessageClass<?>)grp.DATA_INSERT_EVENT, insertEventSnapshot);
            messages.add(insertEvent);
        }
        if (!insertOddSnapshot.matches().isEmpty()) {
            DeltaOutgoingImpl insertOdd = new DeltaOutgoingImpl((IMessageClass<?>)grp.DATA_INSERT_ODD, insertOddSnapshot);
            messages.add(insertOdd);
        }
        _DiffResult result = new _DiffResult();
        result.messages = messages;
        result.fullSnapshot = newFull;
        return result;
    }

    static _Pair<IBetEventBuilder> _manipulateOdds(IBetEvent oldEvent, IBetEvent newEvent) {
        IBetEventBuilder eventBuilderForDeleteOddMsg = BuilderProvider.getBuilder(oldEvent);
        IBetEventBuilder eventBuilderForInsertOddMsg = BuilderProvider.getBuilder(newEvent);
        for (IBetRecord oldRec : oldEvent.records()) {
            IBetRecord newRec = newEvent.record(oldRec.source(), oldRec.id());
            if (newRec == null) continue;
            eventBuilderForDeleteOddMsg.deleteChild(oldRec);
            eventBuilderForInsertOddMsg.deleteChild(newRec);
        }
        return new _Pair<IBetEventBuilder>(eventBuilderForDeleteOddMsg, eventBuilderForInsertOddMsg);
    }

    static List<_Pair<IBetMatchBuilder>> _manipulateEvents(IBetMatch oldMatch, IBetMatch newMatch) {
        IBetMatchBuilder matchBuilderForDeleteEventMsg = BuilderProvider.getBuilder(oldMatch);
        IBetMatchBuilder matchBuilderForInsertEventMsg = BuilderProvider.getBuilder(newMatch);
        IBetMatchBuilder matchBuilderForDeleteOddMsg = BuilderProvider.getBuilder(oldMatch);
        IBetMatchBuilder matchBuilderForInsertOddMsg = BuilderProvider.getBuilder(newMatch);
        for (IBetEvent oldEvent : oldMatch.events()) {
            IBetEvent newEvent = newMatch.event(oldEvent.id());
            if (newEvent == null) continue;
            matchBuilderForDeleteEventMsg.deleteChild(oldEvent);
            matchBuilderForInsertEventMsg.deleteChild(newEvent);
            _Pair<IBetEventBuilder> builderPair = SnapshotUtil._manipulateOdds(oldEvent, newEvent);
            IBetEvent manipulatedDeleteEvent = (IBetEvent)((IBetEventBuilder)builderPair.delete).build();
            IBetEvent manipulatedInsertEvent = (IBetEvent)((IBetEventBuilder)builderPair.insert).build();
            if (manipulatedDeleteEvent.records().isEmpty()) {
                matchBuilderForDeleteOddMsg.deleteChild(manipulatedDeleteEvent);
            } else {
                matchBuilderForDeleteOddMsg.replaceEvent(manipulatedDeleteEvent);
            }
            if (manipulatedInsertEvent.records().isEmpty()) {
                matchBuilderForInsertOddMsg.deleteChild(manipulatedInsertEvent);
                continue;
            }
            matchBuilderForInsertOddMsg.replaceEvent(manipulatedInsertEvent);
        }
        return Arrays.asList(new _Pair<IBetMatchBuilder>(matchBuilderForDeleteEventMsg, matchBuilderForInsertEventMsg), new _Pair<IBetMatchBuilder>(matchBuilderForDeleteOddMsg, matchBuilderForInsertOddMsg));
    }

    static List<_Pair<IIndexedSnapshotBuilder>> _manipulateMatches(IndexedSnapshot oldFull, IndexedSnapshot newFull) {
        IIndexedSnapshotBuilder snapshotBuilderForDeleteMatchMsg = BuilderProvider.getSnapshotBuilder(oldFull);
        IIndexedSnapshotBuilder snapshotBuilderForDeleteEventMsg = BuilderProvider.getSnapshotBuilder(oldFull);
        IIndexedSnapshotBuilder snapshotBuilderForDeleteOddMsg = BuilderProvider.getSnapshotBuilder(oldFull);
        IIndexedSnapshotBuilder snapshotBuilderForInsertMatchMsg = BuilderProvider.getSnapshotBuilder(newFull);
        IIndexedSnapshotBuilder snapshotBuilderForInsertEventMsg = BuilderProvider.getSnapshotBuilder(newFull);
        IIndexedSnapshotBuilder snapshotBuilderForInsertOddMsg = BuilderProvider.getSnapshotBuilder(newFull);
        for (IBetMatch oldMatch : oldFull.matches()) {
            IBetMatch newMatch = newFull.match(oldMatch.id());
            if (newMatch == null) continue;
            snapshotBuilderForDeleteMatchMsg.deleteChild(oldMatch);
            snapshotBuilderForInsertMatchMsg.deleteChild(newMatch);
            List<_Pair<IBetMatchBuilder>> builders = SnapshotUtil._manipulateEvents(oldMatch, newMatch);
            IBetMatch manipulatdMatchForDeleteEvent = (IBetMatch)((IBetMatchBuilder)builders.get((int)0).delete).build();
            IBetMatch manipulatedMatchForInsertEvent = (IBetMatch)((IBetMatchBuilder)builders.get((int)0).insert).build();
            IBetMatch manipulatedMatchForDeleteOdd = (IBetMatch)((IBetMatchBuilder)builders.get((int)1).delete).build();
            IBetMatch manipulatedMatchForInsertOdd = (IBetMatch)((IBetMatchBuilder)builders.get((int)1).insert).build();
            if (manipulatdMatchForDeleteEvent.events().isEmpty()) {
                snapshotBuilderForDeleteEventMsg.deleteChild(manipulatdMatchForDeleteEvent);
            } else {
                snapshotBuilderForDeleteEventMsg.replaceMatch(manipulatdMatchForDeleteEvent);
            }
            if (manipulatedMatchForInsertEvent.events().isEmpty()) {
                snapshotBuilderForInsertEventMsg.deleteChild(manipulatedMatchForInsertEvent);
            } else {
                snapshotBuilderForInsertEventMsg.replaceMatch(manipulatedMatchForInsertEvent);
            }
            if (manipulatedMatchForDeleteOdd.events().isEmpty()) {
                snapshotBuilderForDeleteOddMsg.deleteChild(manipulatedMatchForDeleteOdd);
            } else {
                snapshotBuilderForDeleteOddMsg.replaceMatch(manipulatedMatchForDeleteOdd);
            }
            if (manipulatedMatchForInsertOdd.events().isEmpty()) {
                snapshotBuilderForInsertOddMsg.deleteChild(manipulatedMatchForInsertOdd);
                continue;
            }
            snapshotBuilderForInsertOddMsg.replaceMatch(manipulatedMatchForInsertOdd);
        }
        return Arrays.asList(new _Pair<IIndexedSnapshotBuilder>(snapshotBuilderForDeleteMatchMsg, snapshotBuilderForInsertMatchMsg), new _Pair<IIndexedSnapshotBuilder>(snapshotBuilderForDeleteEventMsg, snapshotBuilderForInsertEventMsg), new _Pair<IIndexedSnapshotBuilder>(snapshotBuilderForDeleteOddMsg, snapshotBuilderForInsertOddMsg));
    }

    public static IndexedSnapshot constructFilteredSnapshot(IndexedSnapshot nonfilteredSs) {
        IIndexedSnapshotBuilder filteredSsBuilder = BuilderProvider.getSnapshotBuilder(IndexedSnapshotImpl.EMPTY_SNAPSHOT);
        for (IBetMatch m : nonfilteredSs.matches()) {
            IBetMatchBuilder matchBuilder = BuilderProvider.getBuilder(m, false);
            for (IBetEvent e : m.events()) {
                if (e.records().isEmpty()) continue;
                matchBuilder.insertChild(e);
                for (IBetEventState state : e.eventStates()) {
                    filteredSsBuilder.markPartitionAsUpdated(state.partitionKey());
                }
            }
            IBetMatch match = (IBetMatch)matchBuilder.build();
            if (match.events().size() <= 0) continue;
            filteredSsBuilder.insertChild(match);
        }
        IndexedSnapshot filteredSs = (IndexedSnapshot)filteredSsBuilder.build();
        return filteredSs;
    }

    static class _Pair<T> {
        T delete;
        T insert;

        public _Pair(T delete, T insert) {
            this.delete = delete;
            this.insert = insert;
        }
    }

    public static class _DiffResult {
        public Collection<Outgoing> messages;
        public IndexedSnapshot fullSnapshot;
    }
}

