/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.List;
import jayeson.lib.delivery.api.messages.IMessageClass;
import jayeson.lib.delivery.api.messages.IMessageGroup;
import jayeson.lib.delivery.core.messages.EmptyMessageClass;
import jayeson.lib.delivery.core.messages.StringMessageClass;
import jayeson.lib.sports.codec.DeleteEventMessageClass;
import jayeson.lib.sports.codec.DeleteMatchMessageClass;
import jayeson.lib.sports.codec.DeleteOddMessageClass;
import jayeson.lib.sports.codec.FilterMessageClass;
import jayeson.lib.sports.codec.InsertEventMessageClass;
import jayeson.lib.sports.codec.InsertMatchMessageClass;
import jayeson.lib.sports.codec.InsertOddMessageClass;
import jayeson.lib.sports.codec.PartitionCodec;
import jayeson.lib.sports.codec.RefreshMessageClass;
import jayeson.lib.sports.codec.ResetMessageClass;
import jayeson.lib.sports.codec.SportCodecs;
import jayeson.lib.sports.codec.StartSubscribeFeedMessageCls;
import jayeson.lib.sports.codec.TTLRemoveMessageClass;
import jayeson.lib.sports.codec.TTLRestoreMessageClass;
import jayeson.lib.sports.codec.UpdateEventMessageClass;
import jayeson.lib.sports.codec.UpdateMatchMessageClass;
import jayeson.lib.sports.codec.UpdateOddMessageClass;

@Singleton
public class SportsFeedMessageGroup
implements IMessageGroup {
    public final ResetMessageClass DATA_RESET;
    public final TTLRestoreMessageClass TTL_RESTORE;
    public final TTLRemoveMessageClass TTL_REMOVE;
    public final InsertOddMessageClass DATA_INSERT_ODD;
    public final UpdateOddMessageClass DATA_UPDATE_ODD;
    public final DeleteOddMessageClass DATA_DELETE_ODD;
    public final InsertEventMessageClass DATA_INSERT_EVENT;
    public final UpdateEventMessageClass DATA_UPDATE_EVENT;
    public final DeleteEventMessageClass DATA_DELETE_EVENT;
    public final InsertMatchMessageClass DATA_INSERT_MATCH;
    public final UpdateMatchMessageClass DATA_UPDATE_MATCH;
    public final DeleteMatchMessageClass DATA_DELETE_MATCH;
    public final StartSubscribeFeedMessageCls ADMIN_START_SUBSCRIBE_FEED;
    public final RefreshMessageClass ADMIN_REFRESH;
    public final FilterMessageClass FILTER_SET;
    public final StringMessageClass FILTER_REMOVE;
    public final StringMessageClass SWITCH_FILTER_START;
    public final EmptyMessageClass SWITCH_FILTER_END;
    public final EmptyMessageClass FULLSNAPSHOT_START;
    public final EmptyMessageClass FULLSNAPSHOT_END;
    public final StringMessageClass SWITCH_FILTER_FAIL;
    public final TTLRestoreMessageClass TTL_RESTORE_START;
    public final EmptyMessageClass TTL_RESTORE_END;
    final IMessageClass<?>[] mClasses;

    @Inject
    public SportsFeedMessageGroup(PartitionCodec partitionCodec, SportCodecs sportCodec) {
        ObjectMapper mapper = new ObjectMapper();
        this.DATA_RESET = new ResetMessageClass(this, 0, partitionCodec, sportCodec);
        this.DATA_INSERT_ODD = new InsertOddMessageClass(this, 1, partitionCodec, sportCodec);
        this.DATA_UPDATE_ODD = new UpdateOddMessageClass(this, 2, partitionCodec, sportCodec);
        this.DATA_DELETE_ODD = new DeleteOddMessageClass(this, 3, partitionCodec, sportCodec);
        this.DATA_INSERT_EVENT = new InsertEventMessageClass(this, 4, partitionCodec, sportCodec);
        this.DATA_UPDATE_EVENT = new UpdateEventMessageClass(this, 5, partitionCodec, sportCodec);
        this.DATA_DELETE_EVENT = new DeleteEventMessageClass(this, 6, partitionCodec, sportCodec);
        this.DATA_INSERT_MATCH = new InsertMatchMessageClass(this, 7, partitionCodec, sportCodec);
        this.DATA_UPDATE_MATCH = new UpdateMatchMessageClass(this, 8, partitionCodec, sportCodec);
        this.DATA_DELETE_MATCH = new DeleteMatchMessageClass(this, 9, partitionCodec, sportCodec);
        this.TTL_RESTORE = new TTLRestoreMessageClass(this, 10, partitionCodec, sportCodec);
        this.TTL_REMOVE = new TTLRemoveMessageClass(this, 11, partitionCodec, sportCodec);
        this.FILTER_REMOVE = new StringMessageClass((IMessageGroup)this, 13);
        this.FILTER_SET = new FilterMessageClass(this, 14, null);
        this.ADMIN_START_SUBSCRIBE_FEED = new StartSubscribeFeedMessageCls(this, 16, mapper);
        this.ADMIN_REFRESH = new RefreshMessageClass(this, 17, mapper);
        this.SWITCH_FILTER_START = new StringMessageClass((IMessageGroup)this, 18);
        this.SWITCH_FILTER_END = new EmptyMessageClass((IMessageGroup)this, 19);
        this.FULLSNAPSHOT_START = new EmptyMessageClass((IMessageGroup)this, 20);
        this.FULLSNAPSHOT_END = new EmptyMessageClass((IMessageGroup)this, 21);
        this.SWITCH_FILTER_FAIL = new StringMessageClass((IMessageGroup)this, 22);
        this.TTL_RESTORE_START = new TTLRestoreMessageClass(this, 23, partitionCodec, sportCodec);
        this.TTL_RESTORE_END = new EmptyMessageClass((IMessageGroup)this, 24);
        List<IMessageClass> allClasses = Arrays.asList(new IMessageClass[]{this.DATA_RESET, this.DATA_INSERT_ODD, this.DATA_UPDATE_ODD, this.DATA_DELETE_ODD, this.DATA_INSERT_EVENT, this.DATA_UPDATE_EVENT, this.DATA_DELETE_EVENT, this.DATA_INSERT_MATCH, this.DATA_UPDATE_MATCH, this.DATA_DELETE_MATCH, this.TTL_RESTORE, this.TTL_REMOVE, this.ADMIN_START_SUBSCRIBE_FEED, this.ADMIN_REFRESH, this.FILTER_SET, this.FILTER_REMOVE, this.SWITCH_FILTER_START, this.SWITCH_FILTER_END, this.FULLSNAPSHOT_START, this.FULLSNAPSHOT_END, this.SWITCH_FILTER_FAIL, this.TTL_RESTORE_START, this.TTL_RESTORE_END});
        int largestId = allClasses.stream().map(IMessageClass::id).mapToInt(Byte::intValue).reduce(Integer::max).getAsInt();
        this.mClasses = new IMessageClass[largestId + 1];
        allClasses.stream().forEach(mc -> {
            this.mClasses[mc.id()] = mc;
        });
    }

    public boolean isIndicatorMessage(IMessageClass<?> messageClass) {
        return messageClass == this.SWITCH_FILTER_START || messageClass == this.SWITCH_FILTER_END || messageClass == this.FULLSNAPSHOT_START || messageClass == this.FULLSNAPSHOT_END || messageClass == this.SWITCH_FILTER_FAIL || messageClass == this.TTL_RESTORE_START || messageClass == this.TTL_RESTORE_END;
    }

    public boolean isSwitchFilterStatusMsg(IMessageClass<?> msgClass) {
        return msgClass == this.SWITCH_FILTER_START || msgClass == this.SWITCH_FILTER_FAIL;
    }

    public List<IMessageClass<?>> allClasses() {
        return Arrays.asList(this.mClasses);
    }

    public IMessageClass<?> classById(byte id) {
        return this.mClasses[id];
    }

    public byte id() {
        return 70;
    }
}

