/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.dispatch;

import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.concurrent.ScheduledExecutorService;
import jayeson.lib.sports.codec.FilterData;
import jayeson.lib.sports.codec.FilterRequest;
import jayeson.lib.sports.core.FSRepo;
import jayeson.lib.sports.datastructure.IndexedSnapshot;
import jayeson.lib.sports.dispatch.EPGCache;
import jayeson.lib.sports.dispatch.IEndPointDispatcher;
import jayeson.lib.sports.dispatch.IEndPointGroup;
import jayeson.lib.sports.dispatch.IEndPointGroupManager;
import jayeson.lib.sports.dispatch.UpdateFilterSnapshotWrapper;
import jayeson.lib.sports.receive.StreamCommandProcessor;
import jayeson.model.IDataFilter;
import jayeson.model.IFilterEvent;
import jayeson.model.IFilterEventListener;
import jayeson.model.filter.GeneralDataFilter;
import jayeson.model.filter.event.FilterRequestUpdateEvent;
import jayeson.utility.concurrent.worker.single.SharedExecutorWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterListenerImpl
implements IFilterEventListener {
    private static Logger log = LoggerFactory.getLogger(FilterListenerImpl.class);
    private SharedExecutorWorker<IFilterEvent, Void> filterEventWorker;
    private ScheduledExecutorService ses;
    private EPGCache epgCache;
    private StreamCommandProcessor scp;
    private IEndPointGroupManager epgm;

    @Inject
    public FilterListenerImpl(ScheduledExecutorService es, StreamCommandProcessor streamCommandProcessor) {
        this.filterEventWorker = new SharedExecutorWorker(es, this::handleFilterUpdatingEvent);
        this.ses = es;
        this.scp = streamCommandProcessor;
    }

    public void setEPGM(IEndPointGroupManager endPointGroupManager) {
        this.epgm = endPointGroupManager;
    }

    private Void handleFilterUpdatingEvent(IFilterEvent event) {
        if (!(event instanceof FilterRequestUpdateEvent)) {
            return null;
        }
        FilterRequestUpdateEvent filterRequestUpdateEvent = (FilterRequestUpdateEvent)event;
        GeneralDataFilter oldFilter = filterRequestUpdateEvent.getOldFilter();
        GeneralDataFilter newFilter = filterRequestUpdateEvent.getNewFilter();
        IEndPointGroup tepg = this.epgCache.getEPG((IDataFilter)oldFilter);
        Collection<IEndPointDispatcher> epds = tepg.getEPDs();
        FilterRequest req = new FilterRequest(new FilterData("", (IDataFilter)newFilter));
        tepg.submitForProcessing(v -> {
            this.epgm.switchFilter(epds, req);
            return true;
        });
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addWrapper(String stream, IEndPointGroup epg, IDataFilter oldFilter) {
        FSRepo fsRepo = this.scp.getFSRepo(stream);
        try {
            fsRepo.freezeSnapshot(stream);
            IndexedSnapshot rawSnapshot = fsRepo.getSnapshot(stream);
            UpdateFilterSnapshotWrapper sw = new UpdateFilterSnapshotWrapper(epg, stream, oldFilter, rawSnapshot);
            epg.submitForProcess(sw);
        }
        finally {
            fsRepo.unFreezeSnapshot(stream);
        }
    }

    public void setupFilter(IEndPointGroup epg, IDataFilter filter) {
        this.teardownFilter(epg);
        epg.setupFilter(filter, this, this.ses);
    }

    public void teardownFilter(IEndPointGroup epg) {
        epg.teardownFilter();
    }

    @Subscribe
    public void handlerFilterEvent(IFilterEvent event) {
        this.filterEventWorker.submit((Object)event).exceptionally(this::onException);
    }

    public Void onException(Throwable e) {
        log.error("Exception when handling FilterEvent. ", e);
        return null;
    }

    void setEpgCache(EPGCache epgCache) {
        this.epgCache = epgCache;
    }

    public SharedExecutorWorker<IFilterEvent, Void> getFilterEventWorker() {
        return this.filterEventWorker;
    }

    public ScheduledExecutorService getSes() {
        return this.ses;
    }

    public EPGCache getEpgCache() {
        return this.epgCache;
    }
}

