/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.dispatch.network;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import jayeson.database.soccer.SoccerFeedUserConfig;
import jayeson.lib.delivery.core.server.ServerEndPoint;
import jayeson.lib.sports.dispatch.network.IpFilter;
import jayeson.lib.sports.dispatch.network.SocketCounter;
import jayeson.lib.sports.util.InjectLogger;
import org.slf4j.Logger;

public class FeedAccessChecker {
    final SocketCounter userSockets;
    @InjectLogger
    Logger log;

    @Inject
    public FeedAccessChecker(SocketCounter counter) {
        this.userSockets = counter;
    }

    public boolean canConnect(ServerEndPoint socket) {
        SoccerFeedUserConfig config = (SoccerFeedUserConfig)socket.getData("config");
        String scope = (String)socket.getData("scope");
        String username = (String)socket.getData("username");
        return this.isIpAllowed(config, socket) && this.canAddSockets(scope, username, config);
    }

    boolean canAddSockets(String scope, String username, SoccerFeedUserConfig config) {
        boolean isAllowed;
        int socketCount;
        try {
            socketCount = this.userSockets.count(scope, username).toCompletableFuture().get();
        }
        catch (InterruptedException | ExecutionException e) {
            this.log.warn("Cannot retrieve socket count for " + scope + " " + username + ": " + e.getMessage() + " | " + Arrays.asList(e.getStackTrace()));
            return false;
        }
        boolean bl = isAllowed = socketCount < config.getMaxConnections();
        if (!isAllowed) {
            this.log.debug(scope + ":" + username + " denied access to soccer feed. Too many connections: " + socketCount + "/" + config.getMaxConnections());
        }
        return isAllowed;
    }

    boolean isIpAllowed(SoccerFeedUserConfig config, ServerEndPoint socket) {
        try {
            IpFilter allowedIp = new IpFilter(config.getAllowedIp());
            boolean isAllowed = allowedIp.includes(socket.getPeerIp());
            if (!isAllowed) {
                this.log.debug(socket.getIdentifier() + " denied access to soccer feed. Ip disallowed.");
            }
            return isAllowed;
        }
        catch (IllegalArgumentException e) {
            this.log.warn("Cannot parse IP. Caused by " + e.getMessage() + " | " + Arrays.asList(e.getStackTrace()));
            return false;
        }
    }

    public void setLogger(Logger log) {
        this.log = log;
    }
}

