/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.dispatch.network;

import java.net.InetAddress;
import java.net.UnknownHostException;

class IpRange {
    final long start;
    final long end;

    public IpRange(String start, String end) throws UnknownHostException {
        long first = IpRange.parseIp(start);
        long last = IpRange.parseIp(end);
        if (first > last) {
            long temp = first;
            first = last;
            last = temp;
        }
        this.start = first;
        this.end = last;
    }

    public IpRange(String ip) throws UnknownHostException {
        this(ip, ip);
    }

    public boolean includes(long ip) {
        return this.start <= ip && ip <= this.end;
    }

    public static long parseIp(String address) throws UnknownHostException {
        byte[] buffer = InetAddress.getByName(address).getAddress();
        long result = 0L;
        for (byte octet : buffer) {
            result <<= 8;
            result |= (long)(octet & 0xFF);
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.end ^ this.end >>> 32);
        result = 31 * result + (int)(this.start ^ this.start >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IpRange other = (IpRange)obj;
        if (this.end != other.end) {
            return false;
        }
        return this.start == other.start;
    }
}

