/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.dispatch.transform;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import jayeson.lib.feed.api.PartitionKey;
import jayeson.lib.sports.dispatch.transform.Cache;
import jayeson.lib.sports.dispatch.transform.EventCache;

class MatchCache
extends Cache {
    String matchId;
    Map<String, EventCache> eventCache;

    public MatchCache(String matchId) {
        this.matchId = matchId;
        this.eventCache = new HashMap<String, EventCache>();
    }

    public void clear(PartitionKey pk) {
        this.keys.remove(pk);
        Iterator<EventCache> it = this.eventCache.values().iterator();
        while (it.hasNext()) {
            EventCache event = it.next();
            event.removeKey(pk);
            if (!event.isEmpty()) continue;
            it.remove();
        }
    }

    public Collection<PartitionKey> getEventPartitionKeys(Set<String> eventIds) {
        HashSet<PartitionKey> partitionKeys = new HashSet<PartitionKey>();
        this.eventCache.forEach((eventId, cache) -> {
            if (eventIds.contains(eventId)) {
                partitionKeys.addAll(cache.getKeys());
            }
        });
        return partitionKeys;
    }

    public void addEvent(String eventId, EventCache eventCache) {
        this.eventCache.put(eventId, eventCache);
    }

    public void removeEvent(String eventId) {
        this.eventCache.remove(eventId);
    }

    public boolean hasEvent(String eventId) {
        return this.eventCache.containsKey(eventId);
    }

    public EventCache getEventCache(String eventId) {
        return this.eventCache.get(eventId);
    }
}

