/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.filter;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import jayeson.lib.delivery.api.messages.IMessageClass;
import jayeson.lib.feed.api.IBetEvent;
import jayeson.lib.feed.api.IBetMatch;
import jayeson.lib.feed.api.IBetRecord;
import jayeson.lib.feed.api.ISnapshot;
import jayeson.lib.sports.core.SportsFeedMessageGroup;
import jayeson.lib.sports.datastructure.DeltaOutgoing;

class FilterContext {
    private final DeltaOutgoing delta;
    private final SportsFeedMessageGroup grp;
    private final boolean isDeleteMsg;

    public DeltaOutgoing getDelta() {
        return this.delta;
    }

    public FilterContext(DeltaOutgoing delta, SportsFeedMessageGroup sportsGrp) {
        this.delta = delta;
        this.grp = sportsGrp;
        this.isDeleteMsg = delta.msgType() == this.grp.DATA_DELETE_MATCH || delta.msgType() == this.grp.DATA_DELETE_EVENT || delta.msgType() == this.grp.DATA_DELETE_ODD;
    }

    public IBetMatch getMatch(String matchId) {
        if (this.isDeleteMsg) {
            return this.delta.before().match(matchId);
        }
        IBetMatch match = this.delta.after().match(matchId);
        if (match != null) {
            return match;
        }
        return this.delta.before().match(matchId);
    }

    public IBetEvent getEvent(String matchId, String eventId) {
        IBetMatch match = this.getMatch(matchId);
        IBetEvent event = null;
        if (match != null) {
            event = match.event(eventId);
        }
        return event;
    }

    public IBetRecord getRecord(String matchId, String eventId, String source, long oddId) {
        IBetEvent event;
        ISnapshot curr;
        IBetMatch match;
        List<ISnapshot> checkSequence = null;
        IMessageClass<?> cls = this.delta.msgType();
        checkSequence = cls.isSameFormat((IMessageClass)this.grp.DATA_INSERT_ODD) || cls.isSameFormat((IMessageClass)this.grp.DATA_UPDATE_ODD) || cls.isSameFormat((IMessageClass)this.grp.DATA_DELETE_ODD) ? Arrays.asList(this.delta.delta(), this.delta.after(), this.delta.before()) : Arrays.asList(this.delta.after(), this.delta.before());
        IBetRecord record = null;
        Iterator<ISnapshot> iterator = checkSequence.iterator();
        while (iterator.hasNext() && ((match = (curr = iterator.next()).match(matchId)) == null || (event = match.event(eventId)) == null || (record = event.record(source, oddId)) == null)) {
        }
        return record;
    }
}

