/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.mutable;

import jayeson.lib.feed.api.IBetEventState;
import jayeson.lib.feed.api.IParticipantStats;
import jayeson.lib.feed.api.PartitionKey;
import jayeson.lib.feed.api.twoside.IB2EventState;
import jayeson.lib.sports.mutable.IBetEventStateBuilder;

public abstract class B2EventStateBuilder
implements IBetEventStateBuilder {
    protected IParticipantStats statsOne;
    protected IParticipantStats statsTwo;
    protected int duration;
    protected PartitionKey key;
    protected String matchId;
    protected String eventId;
    protected long createdTime;

    public void mergeFrom(IBetEventState state) {
        if (!(state instanceof IB2EventState)) {
            throw new IllegalArgumentException("State passed to B2EventStateBuilder is not B2EventState " + state.getClass());
        }
        IB2EventState b2State = (IB2EventState)state;
        this.statsOne = b2State.statsOne();
        this.statsTwo = b2State.statsTwo();
        this.duration = b2State.duration();
        this.key = b2State.partitionKey();
        this.matchId = b2State.matchId();
        this.eventId = b2State.eventId();
        this.createdTime = System.currentTimeMillis();
    }

    public void setStatsOne(IParticipantStats statsOne) {
        this.statsOne = statsOne;
    }

    public void setStatsTwo(IParticipantStats statsTwo) {
        this.statsTwo = statsTwo;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public void setKey(PartitionKey key) {
        this.key = key;
    }

    public void setMatchId(String matchId) {
        this.matchId = matchId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public void setCreatedTime(long createdTime) {
        this.createdTime = createdTime;
    }

    public B2EventStateBuilder(IBetEventState state) {
        this.mergeFrom(state);
    }

    @Override
    public void merge(IBetEventState state) {
        this.setStatsOne(state.statsOf(0));
        this.setStatsTwo(state.statsOf(1));
        this.setDuration(state.duration());
        this.setEventId(state.eventId());
        this.setMatchId(state.matchId());
        this.setKey(state.partitionKey());
    }
}

