/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.receive;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import jayeson.lib.delivery.api.IEndPoint;
import jayeson.lib.delivery.api.MetaInformationCode;
import jayeson.lib.delivery.api.messages.IMessageClass;
import jayeson.lib.delivery.api.messages.IMessageGroup;
import jayeson.lib.delivery.api.messages.MessageWrapper;
import jayeson.lib.delivery.core.metainfo.StreamNameCode;
import jayeson.lib.feed.api.PartitionKey;
import jayeson.lib.sports.codec.DeleteEventMessageClass;
import jayeson.lib.sports.codec.DeleteMatchMessageClass;
import jayeson.lib.sports.codec.DeleteOddMessageClass;
import jayeson.lib.sports.codec.InsertEventMessageClass;
import jayeson.lib.sports.codec.InsertMatchMessageClass;
import jayeson.lib.sports.codec.InsertOddMessageClass;
import jayeson.lib.sports.codec.TTLRemoveMessageClass;
import jayeson.lib.sports.codec.TTLRestoreMessageClass;
import jayeson.lib.sports.codec.UpdateEventMessageClass;
import jayeson.lib.sports.codec.UpdateMatchMessageClass;
import jayeson.lib.sports.codec.UpdateOddMessageClass;
import jayeson.lib.sports.core.DeltaTransformingLogic;
import jayeson.lib.sports.core.RecycleBin;
import jayeson.lib.sports.core.SportsFeedMessageGroup;
import jayeson.lib.sports.core.TTLRemoveCheck;
import jayeson.lib.sports.core.TTLRestoreCheck;
import jayeson.lib.sports.datastructure.Incoming;
import jayeson.lib.sports.datastructure.IndexedSnapshot;
import jayeson.lib.sports.datastructure.Outgoing;
import jayeson.lib.sports.datastructure.OutgoingImpl;
import jayeson.lib.sports.receive.MergeableIncoming;
import jayeson.lib.sports.receive.StreamCommandProcessor;
import jayeson.service.delivery.IInProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SportsFeedInProcessor
implements IInProcessor {
    private static Logger log = LoggerFactory.getLogger(SportsFeedInProcessor.class);
    private StreamCommandProcessor streamCommandProcessor;
    private SportsFeedMessageGroup sportsGroup;
    private RecycleBin recycleBin;
    private StreamNameCode snCode;
    private DeltaTransformingLogic transformingLogic;

    @Inject
    public SportsFeedInProcessor(StreamCommandProcessor scp, SportsFeedMessageGroup sportsFeedMessageGroup, StreamNameCode snCode, RecycleBin recycleBin, DeltaTransformingLogic transformingLogic) {
        this.streamCommandProcessor = scp;
        this.sportsGroup = sportsFeedMessageGroup;
        this.snCode = snCode;
        this.recycleBin = recycleBin;
        this.transformingLogic = transformingLogic;
    }

    public void process(MessageWrapper mw) {
        String stream = mw.getMetaInformation((MetaInformationCode)this.snCode);
        if (stream == null || stream.isEmpty()) {
            log.error("Sports Feed Message from {} doesn't have stream name.Ignoring", (Object)mw.getEndpoint().getIdentifier());
            return;
        }
        if (!this.isFeedMessage(mw)) {
            log.warn("SportsFeedInProcessor received {}.Ignoring", (Object)mw.getMessageClass());
            return;
        }
        if (this.sportsGroup.isIndicatorMessage(mw.getMessageClass())) {
            Outgoing outgoing = this.processIndicatorMessage(mw);
            this.streamCommandProcessor.process(stream, outgoing);
        } else {
            MergeableIncoming incoming = new MergeableIncoming(this.sportsGroup, mw.getMessageClass(), stream, (IndexedSnapshot)mw.msg(), this.transformingLogic, this.recycleBin);
            if (!(mw.getMessageClass() instanceof TTLRemoveMessageClass)) {
                this.triggerTtlRestoreIfApplicable(incoming);
            }
            this.streamCommandProcessor.process(incoming.stream(), incoming);
        }
    }

    private Outgoing processIndicatorMessage(MessageWrapper mw) {
        if (mw.getMessageClass() == this.sportsGroup.TTL_RESTORE_START) {
            for (PartitionKey key : ((IndexedSnapshot)mw.msg()).getPartitions()) {
                this.recycleBin.clearBin(key);
            }
        }
        OutgoingImpl outgoing = new OutgoingImpl(mw.getMessageClass(), mw.msg());
        return outgoing;
    }

    private void triggerTtlRestoreIfApplicable(Incoming incomingMsg) {
        TTLRestoreCheck ttlRestore;
        if (this.getRecycleBin() != null && (ttlRestore = this.getRecycleBin().getTtlRestoreSnapshot(incomingMsg)) != null) {
            this.streamCommandProcessor.process(ttlRestore.getStream(), ttlRestore);
        }
    }

    void triggerTtlRemove() {
        if (this.getRecycleBin() != null) {
            List<TTLRemoveCheck> removeSnapshotList = this.getRecycleBin().getTtlRemoveSnapshot(this.streamCommandProcessor.getAllFSRepos());
            for (TTLRemoveCheck removeSS : removeSnapshotList) {
                this.streamCommandProcessor.process(removeSS.getStream(), removeSS);
            }
        }
    }

    public void startTTlVerification(ScheduledExecutorService ses) {
        if (this.getRecycleBin() != null) {
            if (this.getRecycleBin().getTtlConfig() != null && this.getRecycleBin().getTtlConfig().isEnableTtl()) {
                long runInterval = this.getRecycleBin().getTtlConfig().getRunInterval();
                ses.scheduleWithFixedDelay(this::triggerTtlRemove, runInterval, runInterval, TimeUnit.MILLISECONDS);
                log.info("Scheduled TTLCheck with interval of {}", (Object)runInterval);
            } else {
                log.info("No TTL Set.Not scheduling any ttl");
            }
        }
    }

    public void onRegistered(IEndPoint endpoint) {
        log.info("SoccerFeedInProcessor registered to {}", (Object)endpoint.getIdentifier());
    }

    public void onDeregistered(IEndPoint endpoint) {
        log.info("SoccerFeedInProcessor is deregistered from {}", (Object)endpoint.getIdentifier());
    }

    public IMessageGroup messageGroup() {
        return this.sportsGroup;
    }

    public StreamCommandProcessor getScp() {
        return this.streamCommandProcessor;
    }

    public SportsFeedMessageGroup getSoccerGroup() {
        return this.sportsGroup;
    }

    public final boolean isFeedMessage(MessageWrapper mw) {
        IMessageClass msgCls = mw.getMessageClass();
        return msgCls instanceof InsertOddMessageClass || msgCls instanceof UpdateOddMessageClass || msgCls instanceof DeleteOddMessageClass || msgCls instanceof InsertEventMessageClass || msgCls instanceof UpdateEventMessageClass || msgCls instanceof DeleteEventMessageClass || msgCls instanceof InsertMatchMessageClass || msgCls instanceof UpdateMatchMessageClass || msgCls instanceof DeleteMatchMessageClass || msgCls instanceof TTLRemoveMessageClass || msgCls instanceof TTLRestoreMessageClass || msgCls.id() == this.sportsGroup.ADMIN_REFRESH.id() || msgCls.id() == this.sportsGroup.DATA_RESET.id() || msgCls.id() == this.sportsGroup.SWITCH_FILTER_START.id() || msgCls.id() == this.sportsGroup.SWITCH_FILTER_END.id() || msgCls.id() == this.sportsGroup.FULLSNAPSHOT_START.id() || msgCls.id() == this.sportsGroup.FULLSNAPSHOT_END.id() || msgCls.id() == this.sportsGroup.SWITCH_FILTER_FAIL.id() || msgCls.id() == this.sportsGroup.TTL_RESTORE_START.id() || msgCls.id() == this.sportsGroup.TTL_RESTORE_END.id();
    }

    public RecycleBin getRecycleBin() {
        return this.recycleBin;
    }
}

