/*
 * Decompiled with CFR 0.152.
 */
package play.data;

import com.fasterxml.jackson.databind.JsonNode;
import com.typesafe.config.Config;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.validation.ValidatorFactory;
import play.api.data.FormUtils;
import play.api.libs.json.JsValue;
import play.data.Form;
import play.data.format.Formatters;
import play.data.validation.ValidationError;
import play.i18n.Lang;
import play.i18n.MessagesApi;
import play.libs.Json;
import play.libs.Scala;
import play.libs.typedmap.TypedMap;
import play.mvc.Http;
import scala.collection.Map;

public class DynamicForm
extends Form<Dynamic> {
    private static final Pattern MATCHES_DATA = Pattern.compile("^data\\[.+\\]$");

    public DynamicForm(MessagesApi messagesApi, Formatters formatters, ValidatorFactory validatorFactory, Config config) {
        super(Dynamic.class, messagesApi, formatters, validatorFactory, config);
    }

    public DynamicForm(java.util.Map<String, String> map, List<ValidationError> list, Optional<Dynamic> optional, MessagesApi messagesApi, Formatters formatters, ValidatorFactory validatorFactory, Config config) {
        this(map, Collections.emptyMap(), list, optional, messagesApi, formatters, validatorFactory, config);
    }

    public DynamicForm(java.util.Map<String, String> map, java.util.Map<String, Http.MultipartFormData.FilePart<?>> map2, List<ValidationError> list, Optional<Dynamic> optional, MessagesApi messagesApi, Formatters formatters, ValidatorFactory validatorFactory, Config config) {
        this(map, map2, list, optional, messagesApi, formatters, validatorFactory, config, null);
    }

    public DynamicForm(java.util.Map<String, String> map, List<ValidationError> list, Optional<Dynamic> optional, MessagesApi messagesApi, Formatters formatters, ValidatorFactory validatorFactory, Config config, Lang lang) {
        this(map, Collections.emptyMap(), list, optional, messagesApi, formatters, validatorFactory, config, lang);
    }

    public DynamicForm(java.util.Map<String, String> map, java.util.Map<String, Http.MultipartFormData.FilePart<?>> map2, List<ValidationError> list, Optional<Dynamic> optional, MessagesApi messagesApi, Formatters formatters, ValidatorFactory validatorFactory, Config config, Lang lang) {
        super(null, Dynamic.class, map, map2, list, optional, null, messagesApi, formatters, validatorFactory, config, lang);
    }

    public String get(String string) {
        try {
            return (String)((Dynamic)this.get()).getData().get(DynamicForm.asNormalKey(string));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public <A> Http.MultipartFormData.FilePart<A> file(String string) {
        try {
            return (Http.MultipartFormData.FilePart)((Dynamic)this.get()).getData().get(DynamicForm.asNormalKey(string));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Optional<Object> value(String string) {
        return super.value().map(dynamic -> dynamic.getData().get(DynamicForm.asNormalKey(string)));
    }

    @Override
    public java.util.Map<String, String> rawData() {
        return Collections.unmodifiableMap(super.rawData().entrySet().stream().collect(Collectors.toMap(entry -> DynamicForm.asNormalKey((String)entry.getKey()), entry -> (String)entry.getValue())));
    }

    @Override
    public java.util.Map<String, Http.MultipartFormData.FilePart<?>> files() {
        return Collections.unmodifiableMap(super.files().entrySet().stream().collect(Collectors.toMap(entry -> DynamicForm.asNormalKey((String)entry.getKey()), entry -> (Http.MultipartFormData.FilePart)entry.getValue())));
    }

    public DynamicForm fill(java.util.Map<String, Object> map) {
        Form<Dynamic> form = super.fill(new Dynamic(map));
        return new DynamicForm(form.rawData(), form.files(), form.errors(), form.value(), this.messagesApi, this.formatters, this.validatorFactory, this.config, this.lang().orElse(null));
    }

    public DynamicForm bindFromRequest(Http.Request request, String ... stringArray) {
        return this.bind(this.messagesApi.preferred((Http.RequestHeader)request).lang(), request.attrs(), (java.util.Map)this.requestData(request), (java.util.Map)this.requestFileData(request), stringArray);
    }

    public DynamicForm bindFromRequestData(Lang lang, TypedMap typedMap, java.util.Map<String, String[]> map, java.util.Map<String, Http.MultipartFormData.FilePart<?>> map2, String ... stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.fillDataWith(hashMap, map);
        return this.bind(lang, typedMap, hashMap, (java.util.Map)map2, stringArray);
    }

    @Deprecated
    public DynamicForm bind(Lang lang, TypedMap typedMap, JsonNode jsonNode, String ... stringArray) {
        this.logger.warn("Binding json field from form with a hardcoded max size of {} bytes. This is deprecated. Use bind(Lang, TypedMap, JsonNode, Long, String...) instead.", (Object)this.maxJsonChars());
        return this.bind(lang, typedMap, jsonNode, this.maxJsonChars(), stringArray);
    }

    public DynamicForm bind(Lang lang, TypedMap typedMap, JsonNode jsonNode, long l, String ... stringArray) {
        return this.bind(lang, typedMap, Scala.asJava((Map)FormUtils.fromJson((JsValue)play.api.libs.json.Json.parse((String)Json.stringify((JsonNode)jsonNode)), (long)l, (int)this.maxJsonDepth())), stringArray);
    }

    public DynamicForm bind(Lang lang, TypedMap typedMap, java.util.Map<String, String> map, String ... stringArray) {
        return this.bind(lang, typedMap, (java.util.Map)map, Collections.emptyMap(), stringArray);
    }

    public DynamicForm bind(Lang lang, TypedMap typedMap, java.util.Map<String, String> map, java.util.Map<String, Http.MultipartFormData.FilePart<?>> map2, String ... stringArray) {
        Form form = super.bind(lang, typedMap, map.entrySet().stream().collect(Collectors.toMap(entry -> DynamicForm.asDynamicKey((String)entry.getKey()), entry -> (String)entry.getValue())), map2.entrySet().stream().collect(Collectors.toMap(entry -> DynamicForm.asDynamicKey((String)entry.getKey()), entry -> (Http.MultipartFormData.FilePart)entry.getValue())), stringArray);
        return new DynamicForm(form.rawData(), form.files(), form.errors(), form.value(), this.messagesApi, this.formatters, this.validatorFactory, this.config, lang);
    }

    @Override
    public Form.Field field(String string, Lang lang) {
        Form.Field field = super.field(DynamicForm.asDynamicKey(string), lang);
        return new Form.Field(this, string, field.constraints(), field.format(), field.errors(), field.value().orElse(this.value(string).filter(object -> object instanceof String).orElse(null)), this.fieldFile(string, field));
    }

    private <A> Http.MultipartFormData.FilePart<A> fieldFile(String string, Form.Field field) {
        return field.file().orElse(this.value(string).filter(object -> object instanceof Http.MultipartFormData.FilePart).orElse(null));
    }

    @Override
    public Optional<ValidationError> error(String string) {
        return super.error(DynamicForm.asDynamicKey(string));
    }

    public DynamicForm withError(ValidationError validationError) {
        Form form = super.withError(new ValidationError(DynamicForm.asDynamicKey(validationError.key()), validationError.messages(), validationError.arguments()));
        return new DynamicForm(super.rawData(), super.files(), form.errors(), form.value(), this.messagesApi, this.formatters, this.validatorFactory, this.config, this.lang().orElse(null));
    }

    public DynamicForm withError(String string, String string2, List<Object> list) {
        Form form = super.withError(DynamicForm.asDynamicKey(string), string2, list);
        return new DynamicForm(super.rawData(), super.files(), form.errors(), form.value(), this.messagesApi, this.formatters, this.validatorFactory, this.config, this.lang().orElse(null));
    }

    public DynamicForm withError(String string, String string2) {
        return this.withError(string, string2, (List)new ArrayList());
    }

    public DynamicForm withGlobalError(String string, List<Object> list) {
        Form form = super.withGlobalError(string, list);
        return new DynamicForm(super.rawData(), super.files(), form.errors(), form.value(), this.messagesApi, this.formatters, this.validatorFactory, this.config, this.lang().orElse(null));
    }

    public DynamicForm withGlobalError(String string) {
        return this.withGlobalError(string, (List)new ArrayList());
    }

    public DynamicForm discardingErrors() {
        Form form = super.discardingErrors();
        return new DynamicForm(super.rawData(), super.files(), form.errors(), form.value(), this.messagesApi, this.formatters, this.validatorFactory, this.config, this.lang().orElse(null));
    }

    public DynamicForm withLang(Lang lang) {
        return new DynamicForm(super.rawData(), super.files(), this.errors(), this.value(), this.messagesApi, this.formatters, this.validatorFactory, this.config, lang);
    }

    public DynamicForm withDirectFieldAccess(boolean bl) {
        if (!bl) {
            return this;
        }
        throw new RuntimeException("Not possible to enable direct field access for dynamic forms.");
    }

    static String asDynamicKey(String string) {
        if (string.isEmpty() || MATCHES_DATA.matcher(string).matches()) {
            return string;
        }
        return "data[" + string + "]";
    }

    static String asNormalKey(String string) {
        if (MATCHES_DATA.matcher(string).matches()) {
            return string.substring(5, string.length() - 1);
        }
        return string;
    }

    public static class Dynamic {
        private java.util.Map<String, Object> data = new HashMap<String, Object>();

        public Dynamic() {
        }

        public Dynamic(java.util.Map<String, Object> map) {
            this.data = map;
        }

        public java.util.Map<String, Object> getData() {
            return this.data;
        }

        public void setData(java.util.Map<String, Object> map) {
            this.data = map;
        }

        public String toString() {
            return "Form.Dynamic(" + this.data.toString() + ")";
        }
    }
}

