/*
 * Decompiled with CFR 0.152.
 */
package play.data.format;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.format.Formatter;
import org.springframework.format.support.FormattingConversionService;
import play.data.format.Formats;
import play.i18n.MessagesApi;

@Singleton
public class Formatters {
    public final FormattingConversionService conversion = new FormattingConversionService();

    @Inject
    public Formatters(MessagesApi messagesApi) {
        this.register(Date.class, new Formats.DateFormatter(messagesApi));
        this.register(Date.class, new Formats.AnnotationDateFormatter(messagesApi));
        this.register(String.class, new Formats.AnnotationNonEmptyFormatter());
        this.registerOptional();
    }

    public <T> T parse(String string, Class<T> clazz) {
        return (T)this.conversion.convert((Object)string, clazz);
    }

    public <T> T parse(Field field, String string) {
        return (T)this.conversion.convert((Object)string, new TypeDescriptor(field));
    }

    public <T> String print(T t) {
        if (t == null) {
            return "";
        }
        if (this.conversion.canConvert(t.getClass(), String.class)) {
            return (String)this.conversion.convert(t, String.class);
        }
        return t.toString();
    }

    public <T> String print(Field field, T t) {
        return this.print(new TypeDescriptor(field), t);
    }

    public <T> String print(TypeDescriptor typeDescriptor, T t) {
        if (t == null) {
            return "";
        }
        if (typeDescriptor != null && this.conversion.canConvert(typeDescriptor, TypeDescriptor.valueOf(String.class))) {
            return (String)this.conversion.convert(t, typeDescriptor, TypeDescriptor.valueOf(String.class));
        }
        if (this.conversion.canConvert(t.getClass(), String.class)) {
            return (String)this.conversion.convert(t, String.class);
        }
        return t.toString();
    }

    private Formatters registerOptional() {
        this.conversion.addConverter(new GenericConverter(){

            public Object convert(Object object, TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
                if (typeDescriptor.getObjectType().equals(String.class)) {
                    Object object3 = Formatters.this.conversion.convert(object, typeDescriptor, typeDescriptor2.elementTypeDescriptor(object));
                    return Optional.ofNullable(object3);
                }
                if (typeDescriptor2.getObjectType().equals(String.class)) {
                    if (object == null) {
                        return "";
                    }
                    Optional optional = (Optional)object;
                    return optional.map(object2 -> Formatters.this.conversion.convert(object, typeDescriptor.getElementTypeDescriptor(), typeDescriptor2)).orElse("");
                }
                return null;
            }

            public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
                HashSet<GenericConverter.ConvertiblePair> hashSet = new HashSet<GenericConverter.ConvertiblePair>();
                hashSet.add(new GenericConverter.ConvertiblePair(Optional.class, String.class));
                hashSet.add(new GenericConverter.ConvertiblePair(String.class, Optional.class));
                return hashSet;
            }
        });
        return this;
    }

    public <T> Formatters register(Class<T> clazz, final SimpleFormatter<T> simpleFormatter) {
        this.conversion.addFormatterForFieldType(clazz, new Formatter<T>(){

            public T parse(String string, Locale locale) throws ParseException {
                return simpleFormatter.parse(string, locale);
            }

            public String print(T t, Locale locale) {
                return simpleFormatter.print(t, locale);
            }

            public String toString() {
                return simpleFormatter.toString();
            }
        });
        return this;
    }

    public <A extends Annotation, T> Formatters register(final Class<T> clazz, final AnnotationFormatter<A, T> annotationFormatter) {
        final Class clazz2 = GenericTypeResolver.resolveTypeArguments(annotationFormatter.getClass(), AnnotationFormatter.class)[0];
        this.conversion.addConverter((GenericConverter)new ConditionalGenericConverter(){

            public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
                HashSet<GenericConverter.ConvertiblePair> hashSet = new HashSet<GenericConverter.ConvertiblePair>();
                hashSet.add(new GenericConverter.ConvertiblePair(clazz, String.class));
                return hashSet;
            }

            public boolean matches(TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
                return typeDescriptor.getAnnotation(clazz2) != null;
            }

            public Object convert(Object object, TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
                Annotation annotation = typeDescriptor.getAnnotation(clazz2);
                Locale locale = LocaleContextHolder.getLocale();
                try {
                    return annotationFormatter.print(annotation, object, locale);
                }
                catch (Exception exception) {
                    throw new ConversionFailedException(typeDescriptor, typeDescriptor2, object, (Throwable)exception);
                }
            }

            public String toString() {
                return "@" + clazz2.getName() + " " + clazz.getName() + " -> " + String.class.getName() + ": " + annotationFormatter;
            }
        });
        this.conversion.addConverter((GenericConverter)new ConditionalGenericConverter(){

            public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
                HashSet<GenericConverter.ConvertiblePair> hashSet = new HashSet<GenericConverter.ConvertiblePair>();
                hashSet.add(new GenericConverter.ConvertiblePair(String.class, clazz));
                return hashSet;
            }

            public boolean matches(TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
                return typeDescriptor2.getAnnotation(clazz2) != null;
            }

            public Object convert(Object object, TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
                Annotation annotation = typeDescriptor2.getAnnotation(clazz2);
                Locale locale = LocaleContextHolder.getLocale();
                try {
                    return annotationFormatter.parse(annotation, (String)object, locale);
                }
                catch (Exception exception) {
                    throw new ConversionFailedException(typeDescriptor, typeDescriptor2, object, (Throwable)exception);
                }
            }

            public String toString() {
                return String.class.getName() + " -> @" + clazz2.getName() + " " + clazz.getName() + ": " + annotationFormatter;
            }
        });
        return this;
    }

    public static abstract class AnnotationFormatter<A extends Annotation, T> {
        public abstract T parse(A var1, String var2, Locale var3) throws ParseException;

        public abstract String print(A var1, T var2, Locale var3);
    }

    public static abstract class SimpleFormatter<T> {
        public abstract T parse(String var1, Locale var2) throws ParseException;

        public abstract String print(T var1, Locale var2);
    }
}

