/*
 * Decompiled with CFR 0.152.
 */
package play.data.validation;

import com.typesafe.config.Config;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import javax.validation.metadata.ConstraintDescriptor;
import org.hibernate.validator.constraintvalidation.HibernateConstraintValidatorContext;
import play.data.Form;
import play.i18n.Lang;
import play.i18n.Messages;
import play.libs.F;
import play.libs.typedmap.TypedMap;

public class Constraints {
    public static List<F.Tuple<String, List<Object>>> displayableConstraint(Set<ConstraintDescriptor<?>> set) {
        return set.parallelStream().filter(constraintDescriptor -> constraintDescriptor.getAnnotation().annotationType().isAnnotationPresent(Form.Display.class)).map(constraintDescriptor -> Constraints.displayableConstraint(constraintDescriptor)).collect(Collectors.toList());
    }

    public static List<F.Tuple<String, List<Object>>> displayableConstraint(Set<ConstraintDescriptor<?>> set, Annotation[] annotationArray) {
        List list = set.stream().map(constraintDescriptor -> constraintDescriptor.getAnnotation()).collect(Collectors.toList());
        return Stream.of(annotationArray).filter(list::contains).filter(annotation -> annotation.annotationType().isAnnotationPresent(Form.Display.class)).map(annotation -> Constraints.displayableConstraint(set.parallelStream().filter(constraintDescriptor -> constraintDescriptor.getAnnotation().equals(annotation)).findFirst().get())).collect(Collectors.toList());
    }

    public static F.Tuple<String, List<Object>> displayableConstraint(ConstraintDescriptor<?> constraintDescriptor) {
        Form.Display display = constraintDescriptor.getAnnotation().annotationType().getAnnotation(Form.Display.class);
        return F.Tuple((Object)display.name(), Collections.unmodifiableList(Stream.of(display.attributes()).map(string -> constraintDescriptor.getAttributes().get(string)).collect(Collectors.toList())));
    }

    public static Validator<Object> required() {
        return new RequiredValidator();
    }

    public static Validator<Number> min(long l) {
        return new MinValidator(l);
    }

    public static Validator<Number> max(long l) {
        return new MaxValidator(l);
    }

    public static Validator<String> minLength(long l) {
        return new MinLengthValidator(l);
    }

    public static Validator<String> maxLength(long l) {
        return new MaxLengthValidator(l);
    }

    public static Validator<String> email() {
        return new EmailValidator();
    }

    public static Validator<String> pattern(String string) {
        return new PatternValidator(string);
    }

    public static interface PlayConstraintValidatorWithPayload<A extends Annotation, T>
    extends PlayConstraintValidator<A, T> {
        default public boolean isValid(T t, ConstraintValidatorContext constraintValidatorContext) {
            return this.isValid(t, (ValidationPayload)((HibernateConstraintValidatorContext)constraintValidatorContext.unwrap(HibernateConstraintValidatorContext.class)).getConstraintValidatorPayload(ValidationPayload.class), constraintValidatorContext);
        }

        public boolean isValid(T var1, ValidationPayload var2, ConstraintValidatorContext var3);
    }

    public static interface PlayConstraintValidator<A extends Annotation, T>
    extends ConstraintValidator<A, T> {
        default public boolean validationSuccessful(Object object) {
            return object == null || object instanceof List && ((List)object).isEmpty();
        }

        default public boolean reportValidationStatus(Object object, ConstraintValidatorContext constraintValidatorContext) {
            if (this.validationSuccessful(object)) {
                return true;
            }
            ((HibernateConstraintValidatorContext)constraintValidatorContext.unwrap(HibernateConstraintValidatorContext.class)).withDynamicPayload(object);
            return false;
        }
    }

    public static class ValidateValidatorWithPayload
    implements PlayConstraintValidatorWithPayload<ValidateWithPayload, ValidatableWithPayload<?>> {
        public void initialize(ValidateWithPayload validateWithPayload) {
        }

        @Override
        public boolean isValid(ValidatableWithPayload<?> validatableWithPayload, ValidationPayload validationPayload, ConstraintValidatorContext constraintValidatorContext) {
            return this.reportValidationStatus(validatableWithPayload.validate(validationPayload), constraintValidatorContext);
        }
    }

    public static class ValidateValidator
    implements PlayConstraintValidator<Validate, Validatable<?>> {
        public void initialize(Validate validate) {
        }

        public boolean isValid(Validatable<?> validatable, ConstraintValidatorContext constraintValidatorContext) {
            return this.reportValidationStatus(validatable.validate(), constraintValidatorContext);
        }
    }

    public static interface ValidatableWithPayload<T> {
        public T validate(ValidationPayload var1);
    }

    @Target(value={ElementType.TYPE, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Constraint(validatedBy={ValidateValidatorWithPayload.class})
    @Repeatable(value=List.class)
    public static @interface ValidateWithPayload {
        public String message() default "error.invalid";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};

        @Target(value={ElementType.TYPE, ElementType.ANNOTATION_TYPE})
        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface List {
            public ValidateWithPayload[] value();
        }
    }

    public static interface Validatable<T> {
        public T validate();
    }

    @Target(value={ElementType.TYPE, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Constraint(validatedBy={ValidateValidator.class})
    @Repeatable(value=List.class)
    public static @interface Validate {
        public String message() default "error.invalid";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};

        @Target(value={ElementType.TYPE, ElementType.ANNOTATION_TYPE})
        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface List {
            public Validate[] value();
        }
    }

    public static class ValidatePayloadWithValidator
    extends ValidatorWithPayload<Object>
    implements ConstraintValidator<ValidatePayloadWith, Object> {
        public static final String defaultMessage = "error.invalid";
        Class<?> clazz = null;
        ValidatorWithPayload validator = null;

        public ValidatePayloadWithValidator() {
        }

        public ValidatePayloadWithValidator(Class clazz) {
            this.clazz = clazz;
        }

        public void initialize(ValidatePayloadWith validatePayloadWith) {
            this.clazz = validatePayloadWith.value();
            try {
                Constructor<?> constructor = this.clazz.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                this.validator = (ValidatorWithPayload)constructor.newInstance(new Object[0]);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public boolean isValid(Object object, ValidationPayload validationPayload) {
            try {
                return this.validator.isValid(object, validationPayload);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public F.Tuple<String, Object[]> getErrorMessageKey() {
            F.Tuple tuple = null;
            try {
                tuple = this.validator.getErrorMessageKey();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            return tuple != null ? tuple : F.Tuple((Object)defaultMessage, (Object)new Object[0]);
        }
    }

    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER, ElementType.TYPE_USE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Constraint(validatedBy={ValidatePayloadWithValidator.class})
    @Repeatable(value=List.class)
    @Form.Display(name="constraint.validatewith", attributes={})
    public static @interface ValidatePayloadWith {
        public String message() default "error.invalid";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};

        public Class<? extends ValidatorWithPayload> value();

        @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER, ElementType.TYPE_USE})
        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface List {
            public ValidatePayloadWith[] value();
        }
    }

    public static class ValidateWithValidator
    extends Validator<Object>
    implements ConstraintValidator<ValidateWith, Object> {
        public static final String defaultMessage = "error.invalid";
        Class<?> clazz = null;
        Validator validator = null;

        public ValidateWithValidator() {
        }

        public ValidateWithValidator(Class clazz) {
            this.clazz = clazz;
        }

        public void initialize(ValidateWith validateWith) {
            this.clazz = validateWith.value();
            try {
                Constructor<?> constructor = this.clazz.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                this.validator = (Validator)constructor.newInstance(new Object[0]);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public boolean isValid(Object object) {
            try {
                return this.validator.isValid(object);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public F.Tuple<String, Object[]> getErrorMessageKey() {
            F.Tuple tuple = null;
            try {
                tuple = this.validator.getErrorMessageKey();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            return tuple != null ? tuple : F.Tuple((Object)defaultMessage, (Object)new Object[0]);
        }
    }

    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER, ElementType.TYPE_USE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Constraint(validatedBy={ValidateWithValidator.class})
    @Repeatable(value=List.class)
    @Form.Display(name="constraint.validatewith", attributes={})
    public static @interface ValidateWith {
        public String message() default "error.invalid";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};

        public Class<? extends Validator> value();

        @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER, ElementType.TYPE_USE})
        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface List {
            public ValidateWith[] value();
        }
    }

    public static class PatternValidator
    extends Validator<String>
    implements ConstraintValidator<Pattern, String> {
        public static final String message = "error.pattern";
        java.util.regex.Pattern regex = null;

        public PatternValidator() {
        }

        public PatternValidator(String string) {
            this.regex = java.util.regex.Pattern.compile(string);
        }

        public void initialize(Pattern pattern) {
            this.regex = java.util.regex.Pattern.compile(pattern.value());
        }

        @Override
        public boolean isValid(String string) {
            if (string == null || string.isEmpty()) {
                return true;
            }
            return this.regex.matcher(string).matches();
        }

        @Override
        public F.Tuple<String, Object[]> getErrorMessageKey() {
            return F.Tuple((Object)message, (Object)new Object[]{this.regex});
        }
    }

    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER, ElementType.TYPE_USE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Constraint(validatedBy={PatternValidator.class})
    @Repeatable(value=List.class)
    @Form.Display(name="constraint.pattern", attributes={"value"})
    public static @interface Pattern {
        public String message() default "error.pattern";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};

        public String value();

        @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER, ElementType.TYPE_USE})
        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface List {
            public Pattern[] value();
        }
    }

    public static class EmailValidator
    extends Validator<String>
    implements ConstraintValidator<Email, String> {
        public static final String message = "error.email";
        static final java.util.regex.Pattern regex = java.util.regex.Pattern.compile("\\b[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*\\b");

        public void initialize(Email email) {
        }

        @Override
        public boolean isValid(String string) {
            if (string == null || string.isEmpty()) {
                return true;
            }
            return regex.matcher(string).matches();
        }

        @Override
        public F.Tuple<String, Object[]> getErrorMessageKey() {
            return F.Tuple((Object)message, (Object)new Object[0]);
        }
    }

    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER, ElementType.TYPE_USE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Constraint(validatedBy={EmailValidator.class})
    @Repeatable(value=List.class)
    @Form.Display(name="constraint.email", attributes={})
    public static @interface Email {
        public String message() default "error.email";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};

        @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER, ElementType.TYPE_USE})
        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface List {
            public Email[] value();
        }
    }

    public static class MaxLengthValidator
    extends Validator<String>
    implements ConstraintValidator<MaxLength, String> {
        public static final String message = "error.maxLength";
        private long max;

        public MaxLengthValidator() {
        }

        public MaxLengthValidator(long l) {
            this.max = l;
        }

        public void initialize(MaxLength maxLength) {
            this.max = maxLength.value();
        }

        @Override
        public boolean isValid(String string) {
            if (string == null || string.isEmpty()) {
                return true;
            }
            return (long)string.length() <= this.max;
        }

        @Override
        public F.Tuple<String, Object[]> getErrorMessageKey() {
            return F.Tuple((Object)message, (Object)new Object[]{this.max});
        }
    }

    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER, ElementType.TYPE_USE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Constraint(validatedBy={MaxLengthValidator.class})
    @Repeatable(value=List.class)
    @Form.Display(name="constraint.maxLength", attributes={"value"})
    public static @interface MaxLength {
        public String message() default "error.maxLength";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};

        public long value();

        @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER, ElementType.TYPE_USE})
        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface List {
            public MaxLength[] value();
        }
    }

    public static class MinLengthValidator
    extends Validator<String>
    implements ConstraintValidator<MinLength, String> {
        public static final String message = "error.minLength";
        private long min;

        public MinLengthValidator() {
        }

        public MinLengthValidator(long l) {
            this.min = l;
        }

        public void initialize(MinLength minLength) {
            this.min = minLength.value();
        }

        @Override
        public boolean isValid(String string) {
            if (string == null || string.isEmpty()) {
                return true;
            }
            return (long)string.length() >= this.min;
        }

        @Override
        public F.Tuple<String, Object[]> getErrorMessageKey() {
            return F.Tuple((Object)message, (Object)new Object[]{this.min});
        }
    }

    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER, ElementType.TYPE_USE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Constraint(validatedBy={MinLengthValidator.class})
    @Repeatable(value=List.class)
    @Form.Display(name="constraint.minLength", attributes={"value"})
    public static @interface MinLength {
        public String message() default "error.minLength";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};

        public long value();

        @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER, ElementType.TYPE_USE})
        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface List {
            public MinLength[] value();
        }
    }

    public static class MaxValidator
    extends Validator<Number>
    implements ConstraintValidator<Max, Number> {
        public static final String message = "error.max";
        private long max;

        public MaxValidator() {
        }

        public MaxValidator(long l) {
            this.max = l;
        }

        public void initialize(Max max) {
            this.max = max.value();
        }

        @Override
        public boolean isValid(Number number) {
            if (number == null) {
                return true;
            }
            return number.longValue() <= this.max;
        }

        @Override
        public F.Tuple<String, Object[]> getErrorMessageKey() {
            return F.Tuple((Object)message, (Object)new Object[]{this.max});
        }
    }

    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER, ElementType.TYPE_USE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Constraint(validatedBy={MaxValidator.class})
    @Repeatable(value=List.class)
    @Form.Display(name="constraint.max", attributes={"value"})
    public static @interface Max {
        public String message() default "error.max";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};

        public long value();

        @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER, ElementType.TYPE_USE})
        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface List {
            public Max[] value();
        }
    }

    public static class MinValidator
    extends Validator<Number>
    implements ConstraintValidator<Min, Number> {
        public static final String message = "error.min";
        private long min;

        public MinValidator() {
        }

        public MinValidator(long l) {
            this.min = l;
        }

        public void initialize(Min min) {
            this.min = min.value();
        }

        @Override
        public boolean isValid(Number number) {
            if (number == null) {
                return true;
            }
            return number.longValue() >= this.min;
        }

        @Override
        public F.Tuple<String, Object[]> getErrorMessageKey() {
            return F.Tuple((Object)message, (Object)new Object[]{this.min});
        }
    }

    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER, ElementType.TYPE_USE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Constraint(validatedBy={MinValidator.class})
    @Repeatable(value=List.class)
    @Form.Display(name="constraint.min", attributes={"value"})
    public static @interface Min {
        public String message() default "error.min";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};

        public long value();

        @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER, ElementType.TYPE_USE})
        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface List {
            public Min[] value();
        }
    }

    public static class RequiredValidator
    extends Validator<Object>
    implements ConstraintValidator<Required, Object> {
        public static final String message = "error.required";

        public void initialize(Required required) {
        }

        @Override
        public boolean isValid(Object object) {
            if (object == null) {
                return false;
            }
            if (object instanceof String) {
                return !((String)object).isEmpty();
            }
            if (object instanceof Collection) {
                return !((Collection)object).isEmpty();
            }
            return true;
        }

        @Override
        public F.Tuple<String, Object[]> getErrorMessageKey() {
            return F.Tuple((Object)message, (Object)new Object[0]);
        }
    }

    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER, ElementType.TYPE_USE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Constraint(validatedBy={RequiredValidator.class})
    @Repeatable(value=List.class)
    @Form.Display(name="constraint.required")
    public static @interface Required {
        public String message() default "error.required";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};

        @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER, ElementType.TYPE_USE})
        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface List {
            public Required[] value();
        }
    }

    public static class ValidationPayload {
        private final Lang lang;
        private final Messages messages;
        private final TypedMap attrs;
        private final Config config;

        public ValidationPayload(Lang lang, Messages messages, TypedMap typedMap, Config config) {
            this.lang = lang;
            this.messages = messages;
            this.attrs = typedMap;
            this.config = config;
        }

        public Lang getLang() {
            return this.lang;
        }

        public Messages getMessages() {
            return this.messages;
        }

        public TypedMap getAttrs() {
            return this.attrs;
        }

        public Config getConfig() {
            return this.config;
        }
    }

    public static abstract class ValidatorWithPayload<T> {
        public abstract boolean isValid(T var1, ValidationPayload var2);

        public boolean isValid(T t, ConstraintValidatorContext constraintValidatorContext) {
            return this.isValid(t, (ValidationPayload)((HibernateConstraintValidatorContext)constraintValidatorContext.unwrap(HibernateConstraintValidatorContext.class)).getConstraintValidatorPayload(ValidationPayload.class));
        }

        public abstract F.Tuple<String, Object[]> getErrorMessageKey();
    }

    public static abstract class Validator<T> {
        public abstract boolean isValid(T var1);

        public boolean isValid(T t, ConstraintValidatorContext constraintValidatorContext) {
            return this.isValid(t);
        }

        public abstract F.Tuple<String, Object[]> getErrorMessageKey();
    }
}

