/*
 * Decompiled with CFR 0.152.
 */
package play.data.validation;

import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import org.hibernate.validator.messageinterpolation.ParameterMessageInterpolator;
import play.inject.ApplicationLifecycle;

@Singleton
public class ValidatorFactoryProvider
implements Provider<ValidatorFactory> {
    private ValidatorFactory validatorFactory;

    @Inject
    public ValidatorFactoryProvider(ConstraintValidatorFactory constraintValidatorFactory, ApplicationLifecycle applicationLifecycle) {
        this.validatorFactory = Validation.byDefaultProvider().configure().constraintValidatorFactory(constraintValidatorFactory).messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory();
        applicationLifecycle.addStopHook(() -> {
            this.validatorFactory.close();
            return CompletableFuture.completedFuture(null);
        });
    }

    public ValidatorFactory get() {
        return this.validatorFactory;
    }
}

