/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.play.cachecontrol;

import com.typesafe.play.cachecontrol.CacheControlException;
import com.typesafe.play.cachecontrol.CacheRequest;
import com.typesafe.play.cachecontrol.CurrentAgeCalculator$;
import com.typesafe.play.cachecontrol.HeaderName;
import com.typesafe.play.cachecontrol.HeaderNames$;
import com.typesafe.play.cachecontrol.HttpDate$;
import com.typesafe.play.cachecontrol.Seconds;
import com.typesafe.play.cachecontrol.Seconds$;
import com.typesafe.play.cachecontrol.StoredResponse;
import java.io.Serializable;
import java.time.ZonedDateTime;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005E4Aa\u0003\u0007\u0001+!)A\u0004\u0001C\u0001;!)\u0001\u0005\u0001C\u0001C!)\u0001\u0005\u0001C\u0001w!)A\f\u0001C\u0001;\")q\f\u0001C\u0001A\u001e)!\r\u0004E\u0001G\u001a)1\u0002\u0004E\u0001I\")Ad\u0002C\u0001K\"9am\u0002b\u0001\n\u00139\u0007B\u00029\bA\u0003%\u0001N\u0001\u000bDkJ\u0014XM\u001c;BO\u0016\u001c\u0015\r\\2vY\u0006$xN\u001d\u0006\u0003\u001b9\tAbY1dQ\u0016\u001cwN\u001c;s_2T!a\u0004\t\u0002\tAd\u0017-\u001f\u0006\u0003#I\t\u0001\u0002^=qKN\fg-\u001a\u0006\u0002'\u0005\u00191m\\7\u0004\u0001M\u0011\u0001A\u0006\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005q\u0002CA\u0010\u0001\u001b\u0005a\u0011aE2bY\u000e,H.\u0019;f\u0007V\u0014(/\u001a8u\u0003\u001e,G#\u0002\u0012&U=J\u0004CA\u0010$\u0013\t!CBA\u0004TK\u000e|g\u000eZ:\t\u000b\u0019\u0012\u0001\u0019A\u0014\u0002\u000fI,\u0017/^3tiB\u0011q\u0004K\u0005\u0003S1\u0011AbQ1dQ\u0016\u0014V-];fgRDQa\u000b\u0002A\u00021\n\u0001B]3ta>t7/\u001a\t\u0003?5J!A\f\u0007\u0003\u001dM#xN]3e%\u0016\u001c\bo\u001c8tK\")\u0001G\u0001a\u0001c\u0005Y!/Z9vKN$H+[7f!\t\u0011t'D\u00014\u0015\t!T'\u0001\u0003uS6,'\"\u0001\u001c\u0002\t)\fg/Y\u0005\u0003qM\u0012QBW8oK\u0012$\u0015\r^3US6,\u0007\"\u0002\u001e\u0003\u0001\u0004\t\u0014\u0001\u0004:fgB|gn]3US6,G#\u0002\u0012=1j[\u0006\"B\u001f\u0004\u0001\u0004q\u0014a\u00025fC\u0012,'o\u001d\t\u0005\u007f\u0019KEJ\u0004\u0002A\tB\u0011\u0011\tG\u0007\u0002\u0005*\u00111\tF\u0001\u0007yI|w\u000e\u001e \n\u0005\u0015C\u0012A\u0002)sK\u0012,g-\u0003\u0002H\u0011\n\u0019Q*\u00199\u000b\u0005\u0015C\u0002CA\u0010K\u0013\tYEB\u0001\u0006IK\u0006$WM\u001d(b[\u0016\u00042!\u0014*V\u001d\tq\u0005K\u0004\u0002B\u001f&\t\u0011$\u0003\u0002R1\u00059\u0001/Y2lC\u001e,\u0017BA*U\u0005\r\u0019V-\u001d\u0006\u0003#b\u0001\"a\u0010,\n\u0005]C%AB*ue&tw\rC\u0003Z\u0007\u0001\u0007\u0011'A\u0002o_^DQ\u0001M\u0002A\u0002EBQAO\u0002A\u0002E\n\u0011cY1mGVd\u0017\r^3BO\u00164\u0016\r\\;f)\t\u0011c\fC\u0003>\t\u0001\u0007a(\u0001\ndC2\u001cW\u000f\\1uK\u0012\u000bG/\u001a,bYV,GCA\u0019b\u0011\u0015iT\u00011\u0001?\u0003Q\u0019UO\u001d:f]R\fu-Z\"bY\u000e,H.\u0019;peB\u0011qdB\n\u0003\u000fY!\u0012aY\u0001\u0007Y><w-\u001a:\u0016\u0003!\u0004\"!\u001b8\u000e\u0003)T!a\u001b7\u0002\u000bMdg\r\u000e6\u000b\u00035\f1a\u001c:h\u0013\ty'N\u0001\u0004M_\u001e<WM]\u0001\bY><w-\u001a:!\u0001")
public class CurrentAgeCalculator {
    public Seconds calculateCurrentAge(CacheRequest request, StoredResponse response, ZonedDateTime requestTime, ZonedDateTime responseTime) {
        return this.calculateCurrentAge(response.headers(), HttpDate$.MODULE$.now(), requestTime, responseTime);
    }

    public Seconds calculateCurrentAge(Map<HeaderName, Seq<String>> headers, ZonedDateTime now, ZonedDateTime requestTime, ZonedDateTime responseTime) {
        Seconds currentAge;
        block1: {
            if (CurrentAgeCalculator$.MODULE$.com$typesafe$play$cachecontrol$CurrentAgeCalculator$$logger().isTraceEnabled()) {
                CurrentAgeCalculator$.MODULE$.com$typesafe$play$cachecontrol$CurrentAgeCalculator$$logger().trace(new StringBuilder(68).append("calculateCurrentAge(headers: ").append(headers).append(", now: ").append(now).append(", requestTime: ").append(requestTime).append(", responseTime: ").append(responseTime).append(")").toString());
            }
            Seconds ageValue = this.calculateAgeValue(headers);
            ZonedDateTime dateValue = this.calculateDateValue(headers);
            Seconds apparentAge = responseTime.isAfter(dateValue) ? Seconds$.MODULE$.between(dateValue, responseTime) : Seconds$.MODULE$.ZERO();
            Seconds responseDelay = Seconds$.MODULE$.between(requestTime, responseTime);
            Seconds correctedAgeValue = ageValue.plus(responseDelay);
            long a = Math.max(apparentAge.seconds(), correctedAgeValue.seconds());
            Seconds correctedInitialAge = Seconds$.MODULE$.seconds(a);
            Seconds residentTime = Seconds$.MODULE$.between(responseTime, now);
            currentAge = correctedInitialAge.plus(residentTime);
            if (!CurrentAgeCalculator$.MODULE$.com$typesafe$play$cachecontrol$CurrentAgeCalculator$$logger().isTraceEnabled()) break block1;
            CurrentAgeCalculator$.MODULE$.com$typesafe$play$cachecontrol$CurrentAgeCalculator$$logger().trace(new StringBuilder(34).append("calculateCurrentAge: currentAge = ").append(currentAge).toString());
        }
        return currentAge;
    }

    public Seconds calculateAgeValue(Map<HeaderName, Seq<String>> headers) {
        return (Seconds)headers.get((Object)HeaderNames$.MODULE$.Age()).flatMap((Function1 & Serializable)x$1 -> x$1.headOption()).map((Function1 & Serializable)age -> Seconds$.MODULE$.seconds(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(age)))).getOrElse((Function0 & Serializable)() -> Seconds$.MODULE$.ZERO());
    }

    public ZonedDateTime calculateDateValue(Map<HeaderName, Seq<String>> headers) {
        Option result = headers.get((Object)HeaderNames$.MODULE$.Date()).flatMap((Function1 & Serializable)dateValues -> dateValues.headOption().map((Function1 & Serializable)firstDateValue -> HttpDate$.MODULE$.parse((String)firstDateValue)));
        return (ZonedDateTime)result.getOrElse((Function0 & Serializable)() -> {
            String msg = "Date header is required for age calculation! (see RFC7231, 7.1.1.2)";
            throw new CacheControlException(msg);
        });
    }
}

