/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.play.cachecontrol;

import com.typesafe.play.cachecontrol.Cache;
import com.typesafe.play.cachecontrol.CacheDirective;
import com.typesafe.play.cachecontrol.CacheDirectives;
import com.typesafe.play.cachecontrol.CacheDirectives$;
import com.typesafe.play.cachecontrol.CacheRequest;
import com.typesafe.play.cachecontrol.CacheResponse;
import com.typesafe.play.cachecontrol.HeaderName;
import com.typesafe.play.cachecontrol.HeaderNames$;
import com.typesafe.play.cachecontrol.HttpDate$;
import com.typesafe.play.cachecontrol.Seconds;
import com.typesafe.play.cachecontrol.Seconds$;
import java.io.Serializable;
import java.time.ZonedDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\rc\u0001\u0002\b\u0010\u0001aA\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\u0006I\u0001!\t!\n\u0005\bQ\u0001\u0011\r\u0011\"\u0003*\u0011\u0019\u0011\u0004\u0001)A\u0005U!)1\u0007\u0001C\u0001i!)!\t\u0001C\u0001\u0007\")\u0011\n\u0001C\u0005\u0015\"9A\u0010AI\u0001\n\u0013i\bbBA\f\u0001\u0011\u0005\u0011\u0011\u0004\u0005\b\u0003K\u0001A\u0011AA\u0014\u0011\u001d\ti\u0003\u0001C\u0001\u0003_Aq!!\u000e\u0001\t\u0003\t9\u0004C\u0004\u0002>\u0001!\t!a\u0010\u0003'\u0019\u0013Xm\u001d5oKN\u001c8)\u00197dk2\fGo\u001c:\u000b\u0005A\t\u0012\u0001D2bG\",7m\u001c8ue>d'B\u0001\n\u0014\u0003\u0011\u0001H.Y=\u000b\u0005Q)\u0012\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003Y\t1aY8n\u0007\u0001\u0019\"\u0001A\r\u0011\u0005iiR\"A\u000e\u000b\u0003q\tQa]2bY\u0006L!AH\u000e\u0003\r\u0005s\u0017PU3g\u0003\u0015\u0019\u0017m\u00195f!\t\t#%D\u0001\u0010\u0013\t\u0019sBA\u0003DC\u000eDW-\u0001\u0004=S:LGO\u0010\u000b\u0003M\u001d\u0002\"!\t\u0001\t\u000b}\u0011\u0001\u0019\u0001\u0011\u0002\r1|wmZ3s+\u0005Q\u0003CA\u00161\u001b\u0005a#BA\u0017/\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005y\u0013aA8sO&\u0011\u0011\u0007\f\u0002\u0007\u0019><w-\u001a:\u0002\u000f1|wmZ3sA\u0005Q2-\u00197dk2\fG/\u001a$sKNDg.Z:t\u0019&4W\r^5nKR\u0019Q\u0007O\u001f\u0011\u0005\u00052\u0014BA\u001c\u0010\u0005\u001d\u0019VmY8oINDQ!O\u0003A\u0002i\nqA]3rk\u0016\u001cH\u000f\u0005\u0002\"w%\u0011Ah\u0004\u0002\r\u0007\u0006\u001c\u0007.\u001a*fcV,7\u000f\u001e\u0005\u0006}\u0015\u0001\raP\u0001\te\u0016\u001c\bo\u001c8tKB\u0011\u0011\u0005Q\u0005\u0003\u0003>\u0011QbQ1dQ\u0016\u0014Vm\u001d9p]N,\u0017!H5t\rJ,7\u000f\u001b8fgNLeNZ8s[\u0006$\u0018n\u001c8J]Z\fG.\u001b3\u0015\u0007\u0011;\u0005\n\u0005\u0002\u001b\u000b&\u0011ai\u0007\u0002\b\u0005>|G.Z1o\u0011\u0015Id\u00011\u0001;\u0011\u0015qd\u00011\u0001@\u0003I\u0019wN\u001c;bS:\u001cH)\u001e9mS\u000e\fG/Z:\u0015\u0007\u0011[E\fC\u0003M\u000f\u0001\u0007Q*\u0001\u0006eSJ,7\r^5wKN\u00042A\u0014,Z\u001d\tyEK\u0004\u0002Q'6\t\u0011K\u0003\u0002S/\u00051AH]8pizJ\u0011\u0001H\u0005\u0003+n\tq\u0001]1dW\u0006<W-\u0003\u0002X1\n\u00191+Z9\u000b\u0005U[\u0002CA\u0011[\u0013\tYvB\u0001\bDC\u000eDW\rR5sK\u000e$\u0018N^3\t\u000fu;\u0001\u0013!a\u0001=\u0006!1/Z3o!\ry6M\u001a\b\u0003A\u0006\u0004\"\u0001U\u000e\n\u0005\t\\\u0012A\u0002)sK\u0012,g-\u0003\u0002eK\n\u00191+\u001a;\u000b\u0005\t\\\u0002GA4m!\ry\u0006N[\u0005\u0003S\u0016\u0014Qa\u00117bgN\u0004\"a\u001b7\r\u0001\u0011IQ\u000eXA\u0001\u0002\u0003\u0015\tA\u001c\u0002\u0004?\u0012\n\u0014CA8s!\tQ\u0002/\u0003\u0002r7\t9aj\u001c;iS:<\u0007C\u0001\u000et\u0013\t!8DA\u0002B]fD#a\u0002<\u0011\u0005]TX\"\u0001=\u000b\u0005e\\\u0012AC1o]>$\u0018\r^5p]&\u00111\u0010\u001f\u0002\bi\u0006LGN]3d\u0003q\u0019wN\u001c;bS:\u001cH)\u001e9mS\u000e\fG/Z:%I\u00164\u0017-\u001e7uII*\u0012A \u0016\u0004\u007f\u0006%\u0001\u0003B0d\u0003\u0003\u0001D!a\u0001\u0002\bA!q\f[A\u0003!\rY\u0017q\u0001\u0003\n[\"\t\t\u0011!A\u0003\u00029\\#!a\u0003\u0011\t\u00055\u00111C\u0007\u0003\u0003\u001fQ1!!\u0005y\u0003%)hn\u00195fG.,G-\u0003\u0003\u0002\u0016\u0005=!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006i2-\u00197dk2\fG/\u001a$sKNDg.Z:t\rJ|WnU'bq\u0006;W\r\u0006\u0004\u0002\u001c\u0005\u0005\u00121\u0005\t\u00055\u0005uQ'C\u0002\u0002 m\u0011aa\u00149uS>t\u0007\"B\u001d\n\u0001\u0004Q\u0004\"\u0002 \n\u0001\u0004y\u0014\u0001H2bY\u000e,H.\u0019;f\rJ,7\u000f\u001b8fgN4%o\\7NCb\fu-\u001a\u000b\u0007\u00037\tI#a\u000b\t\u000beR\u0001\u0019\u0001\u001e\t\u000byR\u0001\u0019A \u0002;\r\fGnY;mCR,gI]3tQ:,7o\u001d$s_6,\u0005\u0010]5sKN$b!a\u0007\u00022\u0005M\u0002\"B\u001d\f\u0001\u0004Q\u0004\"\u0002 \f\u0001\u0004y\u0014aH2bY\u000e,H.\u0019;f\rJ,7\u000f\u001b8fgN4%o\\7IKV\u0014\u0018n\u001d;jGR1\u00111DA\u001d\u0003wAQ!\u000f\u0007A\u0002iBQA\u0010\u0007A\u0002}\n!\"\u001e8baBd\u0017pU3r)\u0011\tY\"!\u0011\t\u000b1k\u0001\u0019A'")
public class FreshnessCalculator {
    private final Cache cache;
    private final Logger logger;

    private Logger logger() {
        return this.logger;
    }

    public Seconds calculateFreshnessLifetime(CacheRequest request, CacheResponse response) {
        None$ none$;
        if (this.logger().isTraceEnabled()) {
            this.logger().trace("calculateFreshnessLifetime: ");
        }
        if (this.isFreshnessInformationInvalid(request, response)) {
            none$ = None$.MODULE$;
        } else {
            Option freshnessLifetime = this.calculateFreshnessFromSMaxAge(request, response).orElse((Function0 & Serializable)() -> this.calculateFreshnessFromMaxAge(request, response)).orElse((Function0 & Serializable)() -> this.calculateFreshnessFromExpires(request, response)).orElse((Function0 & Serializable)() -> this.calculateFreshnessFromHeuristic(request, response));
            this.logger().debug(new StringBuilder(48).append("calculateFreshnessLifetime: freshnessLifetime = ").append(freshnessLifetime).toString());
            none$ = freshnessLifetime;
        }
        None$ maybeResult = none$;
        Seconds result = (Seconds)maybeResult.getOrElse((Function0 & Serializable)() -> Seconds$.MODULE$.ZERO());
        this.logger().debug(new StringBuilder(37).append("calculateFreshnessLifetime: result = ").append(result).toString());
        return result;
    }

    public boolean isFreshnessInformationInvalid(CacheRequest request, CacheResponse response) {
        boolean bl;
        Map<HeaderName, Seq<String>> responseHeaders = response.headers();
        Seq<CacheDirective> directives = response.directives();
        if (responseHeaders.get((Object)HeaderNames$.MODULE$.Expires()).exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FreshnessCalculator.$anonfun$isFreshnessInformationInvalid$1(x$1)))) {
            this.logger().debug("isFreshnessInformationInvalid: duplicate Expires headers found, returning true");
            bl = true;
        } else if (this.containsDuplicates(directives, this.containsDuplicates$default$2())) {
            this.logger().debug(new StringBuilder(77).append("isFreshnessInformationInvalid: duplicate directives found in ").append(directives).append(", returning true").toString());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean containsDuplicates(Seq<CacheDirective> directives, Set<Class<?>> seen) {
        boolean bl;
        block2: {
            List list;
            while ((list = directives) instanceof .colon.colon) {
                .colon.colon colon2 = (.colon.colon)list;
                CacheDirective x = (CacheDirective)colon2.head();
                List xs = colon2.next$access$1();
                if (!seen.contains(x.getClass())) {
                    seen = (Set)seen.$plus(x.getClass());
                    directives = xs;
                    continue;
                }
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    private Set<Class<?>> containsDuplicates$default$2() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
    }

    public Option<Seconds> calculateFreshnessFromSMaxAge(CacheRequest request, CacheResponse response) {
        return this.cache.isShared() ? CacheDirectives$.MODULE$.sMaxAge(response.directives()).map((Function1 & Serializable)x$2 -> x$2.delta()) : None$.MODULE$;
    }

    public Option<Seconds> calculateFreshnessFromMaxAge(CacheRequest request, CacheResponse response) {
        return CacheDirectives$.MODULE$.maxAge(response.directives()).map((Function1 & Serializable)x$3 -> x$3.delta());
    }

    public Option<Seconds> calculateFreshnessFromExpires(CacheRequest request, CacheResponse response) {
        Map<HeaderName, Seq<String>> headers = response.headers();
        return headers.get((Object)HeaderNames$.MODULE$.Expires()).flatMap((Function1 & Serializable)expiresList -> {
            None$ none$;
            String dateString = (String)((IterableOps)headers.getOrElse((Object)HeaderNames$.MODULE$.Date(), (Function0 & Serializable)() -> {
                throw new RuntimeException("No Date header found!");
            })).head();
            try {
                ZonedDateTime expires = HttpDate$.MODULE$.parse((String)expiresList.head());
                ZonedDateTime date = HttpDate$.MODULE$.parse(dateString);
                Seconds expiresDuration = HttpDate$.MODULE$.diff(date, expires);
                this.logger().debug(new StringBuilder(49).append("calculateFreshnessFromExpires: expiresDuration = ").append(expiresDuration).toString());
                none$ = new Some((Object)expiresDuration);
            }
            catch (Exception e) {
                this.logger().error("calculateFreshnessFromExpires: HTTP date parsing failed", (Throwable)e);
                none$ = None$.MODULE$;
            }
            return none$;
        });
    }

    public Option<Seconds> calculateFreshnessFromHeuristic(CacheRequest request, CacheResponse response) {
        return this.cache.calculateFreshnessFromHeuristic(request, response);
    }

    public Option<Seconds> unapplySeq(Seq<CacheDirective> directives) {
        None$ none$;
        .colon.colon colon2;
        CacheDirective cacheDirective;
        Seq<CacheDirective> seq = directives;
        if (seq instanceof .colon.colon && (cacheDirective = (CacheDirective)(colon2 = (.colon.colon)seq).head()) instanceof CacheDirectives.SMaxAge) {
            CacheDirectives.SMaxAge sMaxAge2 = (CacheDirectives.SMaxAge)cacheDirective;
            Seconds delta = sMaxAge2.delta();
            none$ = new Some((Object)delta);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public static final /* synthetic */ boolean $anonfun$isFreshnessInformationInvalid$1(Seq x$1) {
        return x$1.size() > 1;
    }

    public FreshnessCalculator(Cache cache) {
        this.cache = cache;
        this.logger = LoggerFactory.getLogger((String)"com.typesafe.cachecontrol.FreshnessCalculator");
    }
}

