/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.play.cachecontrol;

import com.typesafe.play.cachecontrol.Cache;
import com.typesafe.play.cachecontrol.CacheDirectives;
import com.typesafe.play.cachecontrol.CacheDirectives$;
import com.typesafe.play.cachecontrol.CacheDirectives$MustRevalidate$;
import com.typesafe.play.cachecontrol.CacheDirectives$NoStore$;
import com.typesafe.play.cachecontrol.CacheDirectives$Public$;
import com.typesafe.play.cachecontrol.CacheRequest;
import com.typesafe.play.cachecontrol.HeaderNames$;
import com.typesafe.play.cachecontrol.OriginResponse;
import com.typesafe.play.cachecontrol.ResponseCachingAction;
import com.typesafe.play.cachecontrol.ResponseCachingActions;
import com.typesafe.play.cachecontrol.ResponseCachingCalculator$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Eb\u0001\u0002\r\u001a\u0001\tB\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\u0006]\u0001!\ta\f\u0005\u0006e\u0001!\ta\r\u0005\u0006\u0003\u0002!\tB\u0011\u0005\u0006\u000b\u0002!\tB\u0012\u0005\u0006'\u0002!\t\u0002\u0016\u0005\u0006/\u0002!\t\u0002\u0017\u0005\u00067\u0002!\t\u0002\u0018\u0005\u0006?\u0002!\t\u0002\u0019\u0005\u0006G\u0002!\t\u0002\u001a\u0005\u0006c\u0002!\tB\u001d\u0005\u0006i\u0002!\t\"\u001e\u0005\u0006o\u0002!\t\u0002\u001f\u0005\u0006u\u0002!\tb\u001f\u0005\u0006{\u0002!\tB \u0005\b\u0003\u0003\u0001A\u0011CA\u0002\u0011\u001d\t9\u0001\u0001C\t\u0003\u0013Aq!!\u0004\u0001\t#\tyaB\u0004\u0002\u0014eA\t!!\u0006\u0007\raI\u0002\u0012AA\f\u0011\u0019qC\u0003\"\u0001\u0002\u001a!I\u00111\u0004\u000bC\u0002\u0013%\u0011Q\u0004\u0005\t\u0003_!\u0002\u0015!\u0003\u0002 \tI\"+Z:q_:\u001cXmQ1dQ&twmQ1mGVd\u0017\r^8s\u0015\tQ2$\u0001\u0007dC\u000eDWmY8oiJ|GN\u0003\u0002\u001d;\u0005!\u0001\u000f\\1z\u0015\tqr$\u0001\u0005usB,7/\u00194f\u0015\u0005\u0001\u0013aA2p[\u000e\u00011C\u0001\u0001$!\t!s%D\u0001&\u0015\u00051\u0013!B:dC2\f\u0017B\u0001\u0015&\u0005\u0019\te.\u001f*fM\u0006)1-Y2iKB\u00111\u0006L\u0007\u00023%\u0011Q&\u0007\u0002\u0006\u0007\u0006\u001c\u0007.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005A\n\u0004CA\u0016\u0001\u0011\u0015I#\u00011\u0001+\u0003-I7oQ1dQ\u0016\f'\r\\3\u0015\u0007Q:D\b\u0005\u0002,k%\u0011a'\u0007\u0002\u0016%\u0016\u001c\bo\u001c8tK\u000e\u000b7\r[5oO\u0006\u001bG/[8o\u0011\u0015A4\u00011\u0001:\u0003\u001d\u0011X-];fgR\u0004\"a\u000b\u001e\n\u0005mJ\"\u0001D\"bG\",'+Z9vKN$\b\"B\u001f\u0004\u0001\u0004q\u0014\u0001\u0003:fgB|gn]3\u0011\u0005-z\u0014B\u0001!\u001a\u00059y%/[4j]J+7\u000f]8og\u0016\f1C]3ta>t7/Z%t\u0007\u0006\u001c\u0007.Z1cY\u0016$2\u0001N\"E\u0011\u0015AD\u00011\u0001:\u0011\u0015iD\u00011\u0001?\u0003Iqw\u000e^\"bG\",\u0017M\u00197f\u001b\u0016$\bn\u001c3\u0015\u0007\u001d\u000b&\u000bE\u0002%\u0011*K!!S\u0013\u0003\r=\u0003H/[8o!\tYeJ\u0004\u0002,\u0019&\u0011Q*G\u0001\u0017%\u0016\u001c\bo\u001c8tK\u000e\u000b7\r[5oO\u0006\u001bG/[8og&\u0011q\n\u0015\u0002\u0013\t>tu\u000e^\"bG\",'+Z:q_:\u001cXM\u0003\u0002N3!)\u0001(\u0002a\u0001s!)Q(\u0002a\u0001}\u00051\u0012N\\3mS\u001eL'\r\\3SKN\u0004xN\\:f\u0007>$W\rF\u0002H+ZCQ\u0001\u000f\u0004A\u0002eBQ!\u0010\u0004A\u0002y\n\u0001dY8oi\u0006Lgn\u001d(p'R|'/\u001a#je\u0016\u001cG/\u001b<f)\r9\u0015L\u0017\u0005\u0006q\u001d\u0001\r!\u000f\u0005\u0006{\u001d\u0001\rAP\u0001.G>tG/Y5ogB\u0013\u0018N^1uKJ+7\u000f]8og\u0016$\u0015N]3di&4X-\u00138TQ\u0006\u0014X\rZ\"bG\",GcA$^=\")\u0001\b\u0003a\u0001s!)Q\b\u0003a\u0001}\u0005q3m\u001c8uC&t7/\u00138d_6\u0004\u0018\r^5cY\u0016\fU\u000f\u001e5pe&T\u0018\r^5p]&s7\u000b[1sK\u0012\u001c\u0015m\u00195f)\r9\u0015M\u0019\u0005\u0006q%\u0001\r!\u000f\u0005\u0006{%\u0001\rAP\u0001\u0015SN\u001c\u0015m\u00195fC\ndW-\u0012=uK:\u001c\u0018n\u001c8\u0015\u0005\u0015D\u0007C\u0001\u0013g\u0013\t9WEA\u0004C_>dW-\u00198\t\u000b%T\u0001\u0019\u00016\u0002\u0013\u0015DH/\u001a8tS>t\u0007CA6o\u001d\tYC.\u0003\u0002n3\u0005y1)Y2iK\u0012K'/Z2uSZ,7/\u0003\u0002pa\n92)Y2iK\u0012K'/Z2uSZ,W\t\u001f;f]NLwN\u001c\u0006\u0003[f\tA\u0004Z5sK\u000e$\u0018N^3BY2|wo]!vi\"|'/\u001b>bi&|g\u000e\u0006\u0002fg\")Qh\u0003a\u0001}\u0005Y2m\u001c8uC&t7/Q;uQ>\u0014\u0018N_1uS>t\u0007*Z1eKJ$\"!\u001a<\t\u000bab\u0001\u0019A\u001d\u0002+\r|g\u000e^1j]N,\u0005\u0010]5sKNDU-\u00193feR\u0011Q-\u001f\u0005\u0006{5\u0001\rAP\u0001\u0018G>tG/Y5ogB+(\r\\5d\t&\u0014Xm\u0019;jm\u0016$\"!\u001a?\t\u000bur\u0001\u0019\u0001 \u0002/\r|g\u000e^1j]Nl\u0015\r_!hK\u0012K'/Z2uSZ,GCA3\u0000\u0011\u0015it\u00021\u0001?\u0003a\u0019wN\u001c;bS:\u001c8+T1y\u0003\u001e,G)\u001b:fGRLg/\u001a\u000b\u0004K\u0006\u0015\u0001\"B\u001f\u0011\u0001\u0004q\u0014aH2p]R\f\u0017N\\:NkN$(+\u001a<bY&$\u0017\r^3ESJ,7\r^5wKR\u0019Q-a\u0003\t\u000bu\n\u0002\u0019\u0001 \u00023\r|g\u000e^1j]N\u001c\u0015m\u00195bE2,W\t\u001f;f]NLwN\u001c\u000b\u0004K\u0006E\u0001\"B\u001f\u0013\u0001\u0004q\u0014!\u0007*fgB|gn]3DC\u000eD\u0017N\\4DC2\u001cW\u000f\\1u_J\u0004\"a\u000b\u000b\u0014\u0005Q\u0019CCAA\u000b\u0003\u0019awnZ4feV\u0011\u0011q\u0004\t\u0005\u0003C\tY#\u0004\u0002\u0002$)!\u0011QEA\u0014\u0003\u0015\u0019HN\u001a\u001bk\u0015\t\tI#A\u0002pe\u001eLA!!\f\u0002$\t1Aj\\4hKJ\fq\u0001\\8hO\u0016\u0014\b\u0005")
public class ResponseCachingCalculator {
    private final Cache cache;

    /*
     * WARNING - void declaration
     */
    public ResponseCachingAction isCacheable(CacheRequest request, OriginResponse response) {
        void var3_3;
        if (ResponseCachingCalculator$.MODULE$.com$typesafe$play$cachecontrol$ResponseCachingCalculator$$logger().isTraceEnabled()) {
            ResponseCachingCalculator$.MODULE$.com$typesafe$play$cachecontrol$ResponseCachingCalculator$$logger().trace(new StringBuilder(35).append("isCacheable: request: ").append(request).append(", response = ").append(response).toString());
        }
        ResponseCachingAction result = (ResponseCachingAction)this.notCacheableMethod(request, response).orElse((Function0 & Serializable)() -> this.ineligibleResponseCode(request, response)).orElse((Function0 & Serializable)() -> this.containsNoStoreDirective(request, response)).orElse((Function0 & Serializable)() -> this.containsPrivateResponseDirectiveInSharedCache(request, response)).orElse((Function0 & Serializable)() -> this.containsIncompatibleAuthorizationInSharedCache(request, response)).getOrElse((Function0 & Serializable)() -> this.responseIsCacheable(request, response));
        ResponseCachingCalculator$.MODULE$.com$typesafe$play$cachecontrol$ResponseCachingCalculator$$logger().trace(new StringBuilder(22).append("isCacheable: result = ").append(result).toString());
        return var3_3;
    }

    public ResponseCachingAction responseIsCacheable(CacheRequest request, OriginResponse response) {
        if (ResponseCachingCalculator$.MODULE$.com$typesafe$play$cachecontrol$ResponseCachingCalculator$$logger().isTraceEnabled()) {
            ResponseCachingCalculator$.MODULE$.com$typesafe$play$cachecontrol$ResponseCachingCalculator$$logger().trace(new StringBuilder(32).append("responseIsCacheable: response = ").append(response).toString());
        }
        return this.containsExpiresHeader(response) ? new ResponseCachingActions.DoCacheResponse("Response contains expires header") : (this.containsMaxAgeDirective(response) ? new ResponseCachingActions.DoCacheResponse("Response contains max-age response directive") : (this.cache.isShared() && this.containsSMaxAgeDirective(response) ? new ResponseCachingActions.DoCacheResponse("Response contains s-maxage and the cache is shared") : (this.containsCachableExtension(response) ? new ResponseCachingActions.DoCacheResponse("Response contains a cache control extension that allows it to be cached") : (this.cache.isDefaultCacheable(response.status()) ? new ResponseCachingActions.DoCacheResponse(new StringBuilder(45).append("Response status code ").append(response.status()).append(" is cacheable by default").toString()) : (this.containsPublicDirective(response) ? new ResponseCachingActions.DoCacheResponse("Response contains public response directive") : new ResponseCachingActions.DoNotCacheResponse("Response is not cacheable by default, and there are no explicit overrides"))))));
    }

    public Option<ResponseCachingActions.DoNotCacheResponse> notCacheableMethod(CacheRequest request, OriginResponse response) {
        return this.cache.isCacheableMethod(request.method()) ? None$.MODULE$ : new Some((Object)new ResponseCachingActions.DoNotCacheResponse(new StringBuilder(32).append("Request method ").append(request.method()).append(" is not cacheable").toString()));
    }

    public Option<ResponseCachingActions.DoNotCacheResponse> ineligibleResponseCode(CacheRequest request, OriginResponse response) {
        int statusCode = response.status();
        return this.cache.isUnderstoodStatusCode(statusCode) ? None$.MODULE$ : new Some((Object)new ResponseCachingActions.DoNotCacheResponse(new StringBuilder(45).append("Response code ").append(statusCode).append(" is not understood by the cache").toString()));
    }

    public Option<ResponseCachingActions.DoNotCacheResponse> containsNoStoreDirective(CacheRequest request, OriginResponse response) {
        return request.directives().contains((Object)CacheDirectives$NoStore$.MODULE$) ? new Some((Object)new ResponseCachingActions.DoNotCacheResponse("Request Cache-Control header contains no-store cache directive")) : (response.directives().contains((Object)CacheDirectives$NoStore$.MODULE$) ? new Some((Object)new ResponseCachingActions.DoNotCacheResponse("Response Cache-Control header contains no-store cache directive")) : None$.MODULE$);
    }

    public Option<ResponseCachingActions.DoNotCacheResponse> containsPrivateResponseDirectiveInSharedCache(CacheRequest request, OriginResponse response) {
        return this.cache.isShared() ? CacheDirectives$.MODULE$.private(response.directives()).flatMap((Function1 & Serializable)privateDirective -> {
            Some some;
            if (privateDirective.headerNames().isDefined()) {
                ResponseCachingCalculator$.MODULE$.com$typesafe$play$cachecontrol$ResponseCachingCalculator$$logger().debug("qualified private response directive found, returning None");
                some = None$.MODULE$;
            } else {
                some = new Some((Object)new ResponseCachingActions.DoNotCacheResponse("Cache is shared, and private directive found in response"));
            }
            return some;
        }) : None$.MODULE$;
    }

    public Option<ResponseCachingActions.DoNotCacheResponse> containsIncompatibleAuthorizationInSharedCache(CacheRequest request, OriginResponse response) {
        None$ none$;
        if (this.cache.isShared()) {
            if (this.containsAuthorizationHeader(request) && !this.directiveAllowsAuthorization(response)) {
                String msg = "Cache is shared, authorization header found, no cache directives allow authorization";
                none$ = new Some((Object)new ResponseCachingActions.DoNotCacheResponse(msg));
            } else {
                none$ = None$.MODULE$;
            }
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public boolean isCacheableExtension(CacheDirectives.CacheDirectiveExtension extension) {
        return this.cache.isCacheableExtension(extension);
    }

    public boolean directiveAllowsAuthorization(OriginResponse response) {
        return this.containsMustRevalidateDirective(response) || this.containsPublicDirective(response) || this.containsSMaxAgeDirective(response);
    }

    public boolean containsAuthorizationHeader(CacheRequest request) {
        return request.headers().contains((Object)HeaderNames$.MODULE$.Authorization());
    }

    public boolean containsExpiresHeader(OriginResponse response) {
        return response.headers().contains((Object)HeaderNames$.MODULE$.Expires());
    }

    public boolean containsPublicDirective(OriginResponse response) {
        return response.directives().contains((Object)CacheDirectives$Public$.MODULE$);
    }

    public boolean containsMaxAgeDirective(OriginResponse response) {
        return CacheDirectives$.MODULE$.maxAge(response.directives()).isDefined();
    }

    public boolean containsSMaxAgeDirective(OriginResponse response) {
        return CacheDirectives$.MODULE$.sMaxAge(response.directives()).isDefined();
    }

    public boolean containsMustRevalidateDirective(OriginResponse response) {
        return response.directives().contains((Object)CacheDirectives$MustRevalidate$.MODULE$);
    }

    public boolean containsCachableExtension(OriginResponse response) {
        return CacheDirectives$.MODULE$.extensions(response.directives()).exists((Function1 & Serializable)extension -> BoxesRunTime.boxToBoolean((boolean)this.isCacheableExtension(extension)));
    }

    public ResponseCachingCalculator(Cache cache) {
        this.cache = cache;
    }
}

