/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.codec;

import com.google.protobuf.MessageLite;
import com.google.protobuf.ProtocolStringList;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.protobuf.ProtobufDecoder;
import io.netty.handler.codec.protobuf.ProtobufEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import jayeson.lib.delivery.api.messages.IMessageGroup;
import jayeson.lib.delivery.core.messages.BaseMessageClass;
import jayeson.lib.feed.api.IBetMatch;
import jayeson.lib.feed.api.PartitionKey;
import jayeson.lib.feed.api.SportType;
import jayeson.lib.sports.codec.ICodec;
import jayeson.lib.sports.codec.PartitionCodec;
import jayeson.lib.sports.codec.SportCodecs;
import jayeson.lib.sports.codec.StringPool;
import jayeson.lib.sports.codec.Util;
import jayeson.lib.sports.datastructure.DataMessageWrapper;
import jayeson.lib.sports.datastructure.IndexedSnapshot;
import jayeson.lib.sports.datastructure.IndexedSnapshotImpl;
import jayeson.lib.sports.protobuf.Sports;
import jayeson.lib.sports.util.PbufToApiConverter;
import jayeson.lib.sports.util.SportsFeedChannelUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMessageClass
extends BaseMessageClass<IndexedSnapshot> {
    private static Logger log = LoggerFactory.getLogger(AbstractMessageClass.class);
    private final List<ChannelHandler> decoders;
    private final List<ChannelHandler> encoders;
    private final SportCodecs sportCodecs;
    private final PartitionCodec partitionCodec;

    public AbstractMessageClass(IMessageGroup group, int id, PartitionCodec partitionCodec, SportCodecs sportCodecs) {
        super(IndexedSnapshot.class, group, (byte)id);
        this.sportCodecs = sportCodecs;
        this.partitionCodec = partitionCodec;
        this.decoders = new ArrayList<ChannelInboundHandlerAdapter>(Arrays.asList(new ChannelInboundHandlerAdapter[]{new ProtobufDecoder((MessageLite)Sports.DataMessage.getDefaultInstance()), new Decoder()}));
        this.encoders = new ArrayList<ChannelOutboundHandlerAdapter>(Arrays.asList(new ChannelOutboundHandlerAdapter[]{new Encoder(), new ProtobufEncoder()}));
    }

    public abstract Sports.DataMessage.Builder write(IndexedSnapshot var1, ICodec var2, StringPool var3, Boolean var4, PartitionKey var5) throws Exception;

    public Sports.DataMessage write(WritableIndexedSnapshot input, boolean encodeOddId) throws Exception {
        StringPool pool = Util.createStringPool();
        SportType sport = input.key.sportType();
        ICodec codec = this.getCodecOf(sport);
        Sports.DataMessage.Builder output = this.write(input.data, codec, pool, encodeOddId, input.key);
        Sports.PartitionKey partition = this.getPartitionCodec().encode(input.key, pool);
        output.addAllStringPool(pool.getAll());
        output.setFeedKey(partition);
        return output.build();
    }

    public abstract Collection<IBetMatch> read(Sports.DataMessage var1, ICodec var2, List<String> var3, PartitionKey var4);

    public IndexedSnapshot read(Object pbuf, Channel ch) {
        Sports.DataMessage input = (Sports.DataMessage)pbuf;
        ProtocolStringList pool = input.getStringPoolList();
        Sports.PartitionKey pBufKey = input.getFeedKey();
        SportType sport = PbufToApiConverter.asSportType(pBufKey.getSport());
        ICodec codec = this.getCodecOf(sport);
        if (codec == null) {
            log.error("Cannot find codec for sport {}", (Object)sport);
            return new IndexedSnapshotImpl(Collections.emptyMap(), Collections.emptyMap());
        }
        PartitionKey partition = this.getPartitionCodec().decode(pBufKey, (List<String>)pool);
        Collection<IBetMatch> delta = this.read(input, codec, (List<String>)pool, partition);
        HashMap<SportType, Collection<IBetMatch>> sportDelta = new HashMap<SportType, Collection<IBetMatch>>();
        sportDelta.put(sport, delta);
        List<PartitionKey> part = Arrays.asList(partition);
        return new IndexedSnapshotImpl(sportDelta, part);
    }

    public List<ChannelHandler> inboundHandlers(Channel c) {
        return this.decoders;
    }

    public List<ChannelHandler> outboundHandlers(Channel c) {
        return this.encoders;
    }

    PartitionCodec getPartitionCodec() {
        return this.partitionCodec;
    }

    ICodec getCodecOf(SportType sport) {
        return this.sportCodecs.get(sport);
    }

    public static class WritableIndexedSnapshot {
        private final PartitionKey key;
        private final IndexedSnapshot data;

        public WritableIndexedSnapshot(PartitionKey key, IndexedSnapshot data) {
            this.key = key;
            this.data = data;
        }

        public PartitionKey getKey() {
            return this.key;
        }

        public IndexedSnapshot getData() {
            return this.data;
        }
    }

    @ChannelHandler.Sharable
    private class Decoder
    extends ChannelInboundHandlerAdapter {
        private Decoder() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            IndexedSnapshot output = AbstractMessageClass.this.read(msg, ctx.channel());
            ctx.fireChannelRead((Object)output);
        }
    }

    @ChannelHandler.Sharable
    private class Encoder
    extends ChannelOutboundHandlerAdapter {
        private Encoder() {
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            DataMessageWrapper msgWrapper = (DataMessageWrapper)msg;
            if (msgWrapper.getDataMessage() != null && msgWrapper.getDataMessage().size() != 0 || msgWrapper.getCheckId()) {
                Sports.DataMessage dataMsg = msgWrapper.getCheckId() ? (SportsFeedChannelUtil.getRateIdExclusionStatus(ctx.channel()) ? msgWrapper.getSerializedwithoutId() : msgWrapper.getSerializedwithId()) : msgWrapper.getDataMessage().get(0);
                ctx.write((Object)dataMsg, promise);
            } else {
                Sports.DataMessage pBuf = AbstractMessageClass.this.write((WritableIndexedSnapshot)msg, SportsFeedChannelUtil.getRateIdExclusionStatus(ctx.channel()));
                ctx.write((Object)pBuf, promise);
            }
        }
    }
}

