/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.codec;

import com.google.common.collect.BiMap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jayeson.lib.feed.api.IBetEvent;
import jayeson.lib.feed.api.IBetEventState;
import jayeson.lib.feed.api.IBetMatch;
import jayeson.lib.feed.api.IBetRecord;
import jayeson.lib.feed.api.LBType;
import jayeson.lib.feed.api.OddFormat;
import jayeson.lib.feed.api.OddType;
import jayeson.lib.feed.api.PartitionKey;
import jayeson.lib.feed.api.TimeType;
import jayeson.lib.feed.api.twoside.PivotBias;
import jayeson.lib.feed.api.twoside.PivotType;
import jayeson.lib.feed.soccer.LeagueType;
import jayeson.lib.feed.soccer.SoccerEvent;
import jayeson.lib.feed.soccer.SoccerEventImpl;
import jayeson.lib.feed.soccer.SoccerEventState;
import jayeson.lib.feed.soccer.SoccerEventType;
import jayeson.lib.feed.soccer.SoccerGender;
import jayeson.lib.feed.soccer.SoccerMatch;
import jayeson.lib.feed.soccer.SoccerMatchImpl;
import jayeson.lib.feed.soccer.SoccerRecord;
import jayeson.lib.feed.soccer.SoccerRecordImpl;
import jayeson.lib.feed.soccer.SoccerSegment;
import jayeson.lib.feed.soccer.SoccerTimeType;
import jayeson.lib.sports.codec.CodecHelper;
import jayeson.lib.sports.codec.EncodeAction;
import jayeson.lib.sports.codec.ICodec;
import jayeson.lib.sports.codec.StringPool;
import jayeson.lib.sports.protobuf.Soccer;
import jayeson.lib.sports.protobuf.Sports;

@Singleton
class SoccerCodec
implements ICodec {
    private CodecHelper codecHelper;
    private BiMap<SoccerGender, Soccer.SoccerMatch.Gender> genderMap;
    private BiMap<LeagueType, Soccer.SoccerMatch.LeagueType> leagueTypeMap;
    private BiMap<SoccerEventType, Soccer.SoccerEvent.Type> eventTypeMap;
    private BiMap<SoccerTimeType, Soccer.SoccerTimeType.SettleOn> timeTypeMap;
    private BiMap<SoccerSegment, Soccer.SoccerEventState.Segment> segmentMap;
    private BiMap<OddType, Sports.OddType> oddTypeMap;
    private BiMap<LBType, Sports.LBType> lbTypeMap;
    private BiMap<OddFormat, Sports.OddFormat> oddFormatMap;
    private BiMap<PivotBias, Sports.PivotBias> pivotBiasMap;
    private BiMap<PivotType, Sports.PivotType> pivotTypeMap;

    @Inject
    public SoccerCodec(CodecHelper codecHelper) {
        this.codecHelper = codecHelper;
        this.genderMap = codecHelper.getMap(SoccerGender.values(), Soccer.SoccerMatch.Gender.values());
        this.leagueTypeMap = codecHelper.getMap(LeagueType.values(), Soccer.SoccerMatch.LeagueType.values());
        this.eventTypeMap = codecHelper.getMap(SoccerEventType.values(), Soccer.SoccerEvent.Type.values());
        this.timeTypeMap = codecHelper.getMap(SoccerTimeType.values(), Soccer.SoccerTimeType.SettleOn.values());
        this.segmentMap = codecHelper.getMap(SoccerSegment.values(), Soccer.SoccerEventState.Segment.values());
        this.oddTypeMap = codecHelper.getMap(OddType.values(), Sports.OddType.values());
        this.lbTypeMap = codecHelper.getMap(LBType.values(), Sports.LBType.values());
        this.oddFormatMap = codecHelper.getMap(OddFormat.values(), Sports.OddFormat.values());
        this.pivotBiasMap = codecHelper.getMap(PivotBias.values(), Sports.PivotBias.values());
        this.pivotTypeMap = codecHelper.getMap(PivotType.values(), Sports.PivotType.values());
    }

    @Override
    public Sports.BaseMatch encodeMatch(IBetMatch in, StringPool pool, EncodeAction action, PartitionKey key) {
        if (!(in instanceof SoccerMatch) || !this.codecHelper.verifyKey(in, key)) {
            return null;
        }
        return this.encodeMatch(in, pool);
    }

    @Override
    public Sports.BaseMatch encodeMatch(IBetMatch in, StringPool pool) {
        SoccerMatch soccerMatch = (SoccerMatch)in;
        Sports.BaseMatch.Builder baseMatchBuilder = this.codecHelper.getSoccerMatchBuilder(in, pool);
        Soccer.SoccerMatch.Builder soccerMatchBuilder = Soccer.SoccerMatch.newBuilder();
        if (soccerMatch.gender() != null) {
            soccerMatchBuilder.setGender((Soccer.SoccerMatch.Gender)((Object)this.genderMap.get((Object)soccerMatch.gender())));
        }
        if (soccerMatch.leagueType() != null) {
            soccerMatchBuilder.setLeagueType((Soccer.SoccerMatch.LeagueType)((Object)this.leagueTypeMap.get((Object)soccerMatch.leagueType())));
        }
        baseMatchBuilder.setSoccerMatch(soccerMatchBuilder);
        return baseMatchBuilder.build();
    }

    @Override
    public Sports.BaseEvent encodeEvent(IBetEvent in, StringPool pool, EncodeAction action, PartitionKey key) {
        if (!(in instanceof SoccerEvent) || !this.codecHelper.verifyKey(in, key)) {
            return null;
        }
        SoccerEvent soccerEvent = (SoccerEvent)in;
        Sports.BaseEvent.Builder baseEventBuilder = this.codecHelper.getSoccerEventBuilder(in, pool);
        Soccer.SoccerEvent.Builder soccerEventBuilder = Soccer.SoccerEvent.newBuilder();
        baseEventBuilder.setSoccerEvent(soccerEventBuilder);
        Sports.EventType.Builder eventTypeBuilder = Sports.EventType.newBuilder();
        eventTypeBuilder.setSoccerEventType((Soccer.SoccerEvent.Type)((Object)this.eventTypeMap.get((Object)soccerEvent.eventType())));
        baseEventBuilder.setEventType(eventTypeBuilder);
        for (IBetEventState state : in.eventStates()) {
            Sports.BaseEventState pbufState = this.encodeState(state, pool, key);
            if (pbufState == null) continue;
            baseEventBuilder.setState(pbufState);
        }
        return baseEventBuilder.build();
    }

    @Override
    public Sports.BaseEvent encodeEvent(IBetEvent in, StringPool pool) {
        SoccerEvent soccerEvent = (SoccerEvent)in;
        Sports.BaseEvent.Builder baseEventBuilder = this.codecHelper.getSoccerEventBuilder(in, pool);
        Soccer.SoccerEvent.Builder soccerEventBuilder = Soccer.SoccerEvent.newBuilder();
        baseEventBuilder.setSoccerEvent(soccerEventBuilder);
        Sports.EventType.Builder eventTypeBuilder = Sports.EventType.newBuilder();
        eventTypeBuilder.setSoccerEventType((Soccer.SoccerEvent.Type)((Object)this.eventTypeMap.get((Object)soccerEvent.eventType())));
        baseEventBuilder.setEventType(eventTypeBuilder);
        for (IBetEventState state : in.eventStates()) {
            Sports.BaseEventState pbufState = this.encodeState(state, pool);
            if (pbufState == null) continue;
            baseEventBuilder.setState(pbufState);
        }
        return baseEventBuilder.build();
    }

    @Override
    public Sports.BaseRecord encodeRecord(IBetRecord in, StringPool pool, EncodeAction action, boolean excludeRateId, PartitionKey key) {
        if (!(in instanceof SoccerRecord) || !this.codecHelper.verifyKey(in, key)) {
            return null;
        }
        return this.encodeRecord(in, pool, excludeRateId);
    }

    @Override
    public Sports.BaseRecord encodeRecord(IBetRecord in, StringPool pool, boolean excludeRateId) {
        SoccerRecord soccerRecord = (SoccerRecord)in;
        Sports.BaseRecord.Builder baseRecordBuilder = this.codecHelper.getBaseRecordBuilder(in, pool, excludeRateId);
        Sports.TimeType encodedTimeType = this.encodeTimeType(in.timeType());
        baseRecordBuilder.setTimeType(encodedTimeType);
        Soccer.SoccerRecord.Builder soccerBuidler = Soccer.SoccerRecord.newBuilder();
        soccerBuidler.setSwapped(soccerRecord.isSwapped());
        baseRecordBuilder.setSoccerRecord(soccerBuidler.build());
        return baseRecordBuilder.build();
    }

    private Sports.BaseEventState encodeState(IBetEventState in, StringPool pool, PartitionKey key) {
        if (!(in instanceof SoccerEventState) || !this.codecHelper.verifyKey(in, key)) {
            return null;
        }
        return this.encodeState(in, pool);
    }

    private Sports.BaseEventState encodeState(IBetEventState in, StringPool pool) {
        SoccerEventState soccerEventState = (SoccerEventState)in;
        Sports.BaseEventState.Builder baseEventStateBuilder = this.codecHelper.getBaseEventStateBuilder(in, pool);
        Soccer.SoccerEventState.Builder soccerEventStateBuilder = Soccer.SoccerEventState.newBuilder();
        soccerEventStateBuilder.setBookPriority(soccerEventState.bookPriority());
        soccerEventStateBuilder.setSegment((Soccer.SoccerEventState.Segment)((Object)this.segmentMap.get((Object)soccerEventState.segment())));
        baseEventStateBuilder.setSoccerEventState(soccerEventStateBuilder);
        return baseEventStateBuilder.build();
    }

    @Override
    public Collection<IBetMatch> decodeMatch(Collection<Sports.BaseMatch> in, List<String> pool, EncodeAction action, PartitionKey pk) {
        ArrayList<IBetMatch> result = new ArrayList<IBetMatch>();
        for (Sports.BaseMatch baseMatch : in) {
            String id = pool.get(baseMatch.getId());
            String p1 = null;
            String p2 = null;
            long startTime = 0L;
            ArrayList events = new ArrayList();
            String league = null;
            Map<Object, Object> meta = new HashMap();
            LeagueType leagueType = null;
            SoccerGender gender = null;
            String country = null;
            p1 = pool.get(baseMatch.getParticipants(0));
            p2 = pool.get(baseMatch.getParticipants(1));
            startTime = baseMatch.getStartTime();
            league = pool.get(baseMatch.getLeague());
            if (baseMatch.getSoccerMatch().getLeagueType() != null) {
                leagueType = (LeagueType)this.leagueTypeMap.inverse().get((Object)baseMatch.getSoccerMatch().getLeagueType());
            }
            if (baseMatch.getSoccerMatch().getGender() != null) {
                gender = (SoccerGender)this.genderMap.inverse().get((Object)baseMatch.getSoccerMatch().getGender());
            }
            meta = new HashMap<String, String>(baseMatch.getMetaInfoMap());
            country = pool.get(baseMatch.getCountry());
            if (pk != null) {
                meta = CodecHelper.populatePKIntoMetaInfo(meta, pk);
            }
            SoccerMatchImpl soccerMatch = new SoccerMatchImpl(p1, p2, startTime, events, id, league, meta, leagueType, gender, country);
            result.add((IBetMatch)soccerMatch);
        }
        return result;
    }

    @Override
    public Collection<IBetMatch> decodeEvent(Collection<Sports.BaseEvent> in, List<String> pool, EncodeAction action, PartitionKey pk) {
        HashMap<String, List> resultEvents = new HashMap<String, List>();
        HashMap<String, IBetMatch> resultMatches = new HashMap<String, IBetMatch>();
        for (Sports.BaseEvent baseEvent : in) {
            String matchId = pool.get(baseEvent.getMatchId());
            List events = resultEvents.computeIfAbsent(matchId, key -> new ArrayList());
            resultMatches.computeIfAbsent(matchId, key -> new SoccerMatchImpl(null, null, 0L, (Collection)events, matchId, null, new HashMap(), null, null, null));
            String id = pool.get(baseEvent.getId());
            SoccerEventType type = null;
            HashMap<String, String> meta = null;
            type = (SoccerEventType)this.eventTypeMap.inverse().get((Object)baseEvent.getEventType().getSoccerEventType());
            meta = new HashMap<String, String>(baseEvent.getMetaInfoMap());
            List<SoccerEventState> states = Arrays.asList(this.decodeState(matchId, id, baseEvent.getState(), pool, action, pk));
            SoccerEventImpl event = new SoccerEventImpl(id, new ArrayList(), states, matchId, type, meta);
            events.add(event);
        }
        return resultMatches.values();
    }

    @Override
    public Collection<IBetMatch> decodeRecord(Collection<Sports.BaseRecord> in, List<String> pool, EncodeAction action, PartitionKey pk) {
        HashMap<String, IBetMatch> resultMatches = new HashMap<String, IBetMatch>();
        HashMap<String, List> groupEventsByMatchId = new HashMap<String, List>();
        HashMap<String, Map> resultRecords = new HashMap<String, Map>();
        HashMap<String, Map> groupEventsByMatchIdAndEventId = new HashMap<String, Map>();
        for (Sports.BaseRecord baseRecord : in) {
            String matchId = pool.get(baseRecord.getMatchId());
            List events = groupEventsByMatchId.computeIfAbsent(matchId, key -> new ArrayList());
            resultMatches.computeIfAbsent(matchId, key -> new SoccerMatchImpl(null, null, 0L, (Collection)events, matchId, null, new HashMap(), null, null, null));
            Map eventMap = resultRecords.computeIfAbsent(matchId, key -> new HashMap());
            Map groupEventsByEventId = groupEventsByMatchIdAndEventId.computeIfAbsent(matchId, key -> new HashMap());
            String eventId = pool.get(baseRecord.getEventId());
            List records = eventMap.computeIfAbsent(eventId, key -> {
                ArrayList initialRecords = new ArrayList();
                SoccerEventImpl event = new SoccerEventImpl(eventId, initialRecords, new ArrayList(), matchId, null, new HashMap());
                events.add(event);
                groupEventsByEventId.put(eventId, event);
                return initialRecords;
            });
            long id = baseRecord.getId();
            OddType oddType = null;
            LBType lbType = null;
            SoccerTimeType timetype = null;
            String sportbook = pool.get(baseRecord.getSource());
            OddFormat oddFormat = null;
            Map<String, String> meta = null;
            float rateOver = 0.0f;
            float rateUnder = 0.0f;
            float rateEqual = 0.0f;
            float pivotValue = 0.0f;
            PivotType pivotType = null;
            PivotBias pivotBias = null;
            String rateOverId = null;
            String rateUnderId = null;
            String rateEqualId = null;
            oddType = (OddType)this.oddTypeMap.inverse().get((Object)baseRecord.getOddType());
            lbType = (LBType)this.lbTypeMap.inverse().get((Object)baseRecord.getLbType());
            timetype = (SoccerTimeType)this.timeTypeMap.inverse().get((Object)baseRecord.getTimeType().getSoccerTimeType().getSettle());
            oddFormat = (OddFormat)this.oddFormatMap.inverse().get((Object)baseRecord.getFormat());
            meta = baseRecord.getMetaInfoMap();
            rateOver = baseRecord.getRates(0);
            rateUnder = baseRecord.getRates(1);
            rateEqual = baseRecord.getRates(2);
            if (baseRecord.getRateIdsCount() > 0) {
                rateOverId = pool.get(baseRecord.getRateIds(0));
                rateUnderId = pool.get(baseRecord.getRateIds(1));
                rateEqualId = pool.get(baseRecord.getRateIds(2));
            }
            pivotValue = baseRecord.getPivotValue();
            pivotType = (PivotType)this.pivotTypeMap.inverse().get((Object)baseRecord.getPivotType());
            pivotBias = (PivotBias)this.pivotBiasMap.inverse().get((Object)baseRecord.getPivotBias());
            boolean isSwapped = false;
            if (baseRecord.getSoccerRecord() != null) {
                isSwapped = baseRecord.getSoccerRecord().getSwapped();
            }
            SoccerRecordImpl soccerRecord = new SoccerRecordImpl(matchId, eventId, id, oddType, lbType, (TimeType)timetype, sportbook, oddFormat, meta, rateOver, rateUnder, rateEqual, pivotValue, pivotType, pivotBias, rateOverId, rateUnderId, rateEqualId, isSwapped);
            records.add(soccerRecord);
        }
        return resultMatches.values();
    }

    private SoccerEventState decodeState(String matchId, String eventId, Sports.BaseEventState baseEventState, List<String> pool, EncodeAction action, PartitionKey pk) {
        int duration = 0;
        int hostScore = -1;
        int guestScore = -1;
        int hostCard = -1;
        int guestCard = -1;
        SoccerSegment segment = null;
        int bookPriority = 0;
        duration = baseEventState.getDuration();
        Sports.Stats hostStats = baseEventState.getParticipantStats(0);
        Sports.Stats guestStats = baseEventState.getParticipantStats(1);
        hostScore = (byte)hostStats.getScores(0);
        hostCard = (byte)hostStats.getScores(1);
        guestScore = (byte)guestStats.getScores(0);
        guestCard = (byte)guestStats.getScores(1);
        segment = (SoccerSegment)this.segmentMap.inverse().get((Object)baseEventState.getSoccerEventState().getSegment());
        bookPriority = baseEventState.getSoccerEventState().getBookPriority();
        SoccerEventState soccerEventState = new SoccerEventState(duration, pk, matchId, eventId, hostScore, guestScore, hostCard, guestCard, segment, bookPriority);
        return soccerEventState;
    }

    @Override
    public Sports.TimeType encodeTimeType(TimeType timeType) {
        Sports.TimeType.Builder timeTypeBuilder = Sports.TimeType.newBuilder();
        Soccer.SoccerTimeType.Builder soccerTimeTypeBuilder = Soccer.SoccerTimeType.newBuilder();
        soccerTimeTypeBuilder.setSettle((Soccer.SoccerTimeType.SettleOn)((Object)this.timeTypeMap.get((Object)((SoccerTimeType)timeType))));
        timeTypeBuilder.setSoccerTimeType(soccerTimeTypeBuilder);
        return timeTypeBuilder.build();
    }

    @Override
    public TimeType decodeTimeType(Sports.TimeType timeType) {
        TimeType soccerTimeType = (TimeType)this.timeTypeMap.inverse().get((Object)timeType.getSoccerTimeType().getSettle());
        return soccerTimeType;
    }
}

