/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.core;

import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jayeson.lib.sports.core.FSRepo;
import jayeson.lib.sports.core.ISnapshotHandler;
import jayeson.lib.sports.core.TTLRemoveCheck;
import jayeson.lib.sports.datastructure.IndexedSnapshot;

public abstract class AbstractFSRepo
implements FSRepo {
    private Set<ISnapshotHandler> handlers = ConcurrentHashMap.newKeySet();

    @Override
    public abstract List<TTLRemoveCheck> getTtlRemoveSnapshot();

    @Override
    public void freezeSnapshot(String streamName) {
        throw new UnsupportedOperationException("Not supported for aggreagted FS Repo");
    }

    @Override
    public void unFreezeSnapshot(String streamName) {
        throw new UnsupportedOperationException("Not supported for aggreagted FS Repo");
    }

    @Override
    public IndexedSnapshot getSnapshot() {
        throw new UnsupportedOperationException("Not supported for Stream based repo");
    }

    @Override
    public IndexedSnapshot getSnapshot(String streamName) {
        throw new UnsupportedOperationException("Not supported for aggreagted FS Repo");
    }

    @Override
    public void registerSnapshotHandler(ISnapshotHandler ssHandler) {
        this.handlers.add(ssHandler);
    }

    @Override
    public void deRegisterSnapshotHandler(ISnapshotHandler ssHandler) {
        this.handlers.remove(ssHandler);
    }

    @Override
    public Set<ISnapshotHandler> getRegisteredHandlers() {
        return this.handlers;
    }
}

