/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.dispatch;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import jayeson.lib.sports.core.SportsFeedMessageGroup;
import jayeson.lib.sports.datastructure.DeltaOutgoing;
import jayeson.lib.sports.datastructure.Outgoing;
import jayeson.lib.sports.datastructure.TTLDelta;
import jayeson.lib.sports.dispatch.DispatchersGroup;
import jayeson.lib.sports.dispatch.IDispatchableWrapper;
import jayeson.lib.sports.dispatch.IEndPointDispatcher;
import jayeson.lib.sports.dispatch.IEndPointGroup;
import jayeson.lib.sports.dispatch.IndicatorWrapper;
import jayeson.lib.sports.dispatch.PartialSnapshotWrapper;
import jayeson.lib.sports.dispatch.TTLSnapshotWrapper;
import jayeson.lib.sports.util.LogHelper;
import jayeson.utility.concurrent.worker.single.SharedExecutorWorkerGroup;

public abstract class AbstractEPG
implements IEndPointGroup {
    private Map<String, DispatchersGroup> dispatchers;
    protected SharedExecutorWorkerGroup<IDispatchableWrapper, Void> workers;
    private SportsFeedMessageGroup grp;
    private final String id;
    private CompletableFuture<Boolean> initialized;
    private CompletableFuture<Boolean> processingFuture;
    private Map<IEndPointDispatcher, Long> dispatchersAddedTime;

    public AbstractEPG(ScheduledExecutorService executor, SportsFeedMessageGroup grp) {
        this.workers = new SharedExecutorWorkerGroup(executor);
        this.grp = grp;
        this.dispatchers = new ConcurrentHashMap<String, DispatchersGroup>();
        this.id = UUID.randomUUID().toString();
        this.dispatchersAddedTime = new ConcurrentHashMap<IEndPointDispatcher, Long>();
        this.initialized = new CompletableFuture();
        this.processingFuture = this.initialized;
    }

    @Override
    public void process(String stream, Outgoing snapshot) {
        if (this.grp.isIndicatorMessage(snapshot.msgType())) {
            IndicatorWrapper indicatorWrapper = new IndicatorWrapper(snapshot, this, stream);
            this.submitForProcess(indicatorWrapper);
        } else if (snapshot.msgType() == this.grp.TTL_RESTORE) {
            TTLDelta ttlDelta = (TTLDelta)snapshot;
            LogHelper.logFeedUpdate(ttlDelta.delta(), ttlDelta.msgType(), String.valueOf(this), LogHelper.InOut.OUT);
            TTLSnapshotWrapper ttlWrapper = new TTLSnapshotWrapper(ttlDelta.after(), ttlDelta.delta(), this, stream, ttlDelta.getTTLRemovedTime());
            this.submitForProcess(ttlWrapper);
        } else {
            DeltaOutgoing deltaSnapshot = (DeltaOutgoing)snapshot;
            LogHelper.logFeedUpdate(deltaSnapshot.delta(), deltaSnapshot.msgType(), String.valueOf(this), LogHelper.InOut.OUT);
            PartialSnapshotWrapper partialWrapper = new PartialSnapshotWrapper(deltaSnapshot, this, stream);
            this.submitForProcess(partialWrapper);
        }
    }

    @Override
    public Map<String, List<String>> getDispatcherNames() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (String key : this.dispatchers.keySet()) {
            map.put(key, Lists.newArrayList((Object[])new DispatchersGroup[]{this.dispatchers.get(key)}).stream().map(DispatchersGroup::getDispatcherNames).collect(Collectors.toList()));
        }
        return map;
    }

    @Override
    public void addEPD(IEndPointDispatcher epd) {
        DispatchersGroup grp = this.dispatchers.get(epd.getStream());
        if (grp == null) {
            this.dispatchers.putIfAbsent(epd.getStream(), new DispatchersGroup(epd.getStream()));
        }
        this.setEpdConnectedTime(epd, Long.MAX_VALUE);
        this.dispatchers.get(epd.getStream()).addEpd(epd);
        LogHelper.logChangeEPD(LogHelper.Action.ADD, this, epd);
    }

    @Override
    public void removeEPD(IEndPointDispatcher epd) {
        DispatchersGroup grp = this.dispatchers.get(epd.getStream());
        if (grp != null) {
            grp.removeEpd(epd);
            this.dispatchersAddedTime.remove(epd);
            if (grp.isEmpty()) {
                this.dispatchers.remove(epd.getStream());
            }
        }
        LogHelper.logChangeEPD(LogHelper.Action.REMOVE, this, epd);
    }

    @Override
    public long getEpdConnectedTime(IEndPointDispatcher epd) {
        return this.dispatchersAddedTime.get(epd);
    }

    @Override
    public void setEpdConnectedTime(IEndPointDispatcher epd, long timeInMillis) {
        this.dispatchersAddedTime.put(epd, timeInMillis);
    }

    @Override
    public boolean hasEPD(String stream, String id) {
        DispatchersGroup dispGrp = this.dispatchers.get(stream);
        if (dispGrp == null) {
            return false;
        }
        return dispGrp.get(id) != null;
    }

    @Override
    public boolean isEmpty() {
        return this.dispatchers.isEmpty();
    }

    @Override
    public Collection<IEndPointDispatcher> getEPDs(String stream) {
        DispatchersGroup dispGrp = this.dispatchers.get(stream);
        if (dispGrp == null) {
            return Arrays.asList(new IEndPointDispatcher[0]);
        }
        return dispGrp.getAll();
    }

    @Override
    public Collection<IEndPointDispatcher> getEPDs() {
        ArrayList<IEndPointDispatcher> result = new ArrayList<IEndPointDispatcher>();
        this.getStreams().forEach(stream -> result.addAll(this.getEPDs((String)stream)));
        return result;
    }

    @Override
    public Collection<String> getStreams() {
        return this.dispatchers.keySet();
    }

    @Override
    public SportsFeedMessageGroup getSportsFeedGrp() {
        return this.grp;
    }

    public CompletableFuture<Void> submitToQueue(String queueName, IDispatchableWrapper wrapper, Consumer<Void> fn) {
        return this.workers.submit(queueName, (Object)wrapper, arg -> {
            fn.accept(null);
            return null;
        });
    }

    protected String generateQueueName(String queueName) {
        return String.format(queueName, this.id);
    }

    @Override
    public void submitForProcessing(Function<Boolean, Boolean> process) {
        this.processingFuture = this.processingFuture.thenApply(process);
    }

    @Override
    public void setInitialized(boolean value) {
        this.initialized.complete(value);
    }
}

