/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.dispatch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import jayeson.lib.sports.dispatch.IEndPointDispatcher;

class DispatchersGroup {
    private String stream;
    private Map<String, IEndPointDispatcher> dispatchers = new ConcurrentHashMap<String, IEndPointDispatcher>();

    public DispatchersGroup(String stream) {
        this.stream = stream;
    }

    public void addEpd(IEndPointDispatcher epd) {
        this.dispatchers.put(epd.id(), epd);
    }

    public void removeEpd(IEndPointDispatcher epd) {
        this.dispatchers.remove(epd.id());
    }

    public IEndPointDispatcher get(String id) {
        return this.dispatchers.get(id);
    }

    public Collection<IEndPointDispatcher> getAll() {
        return new ArrayList<IEndPointDispatcher>(this.dispatchers.values());
    }

    public boolean isEmpty() {
        return this.dispatchers.isEmpty();
    }

    public String getStreamName() {
        return this.stream;
    }

    public String getDispatcherNames() {
        return this.dispatchers.values().stream().map(Object::toString).collect(Collectors.joining(","));
    }
}

