/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.dispatch;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import jayeson.lib.delivery.api.messages.IMessageClass;
import jayeson.lib.sports.codec.FilterRequest;
import jayeson.lib.sports.core.FSRepo;
import jayeson.lib.sports.datastructure.DataMessageWrapper;
import jayeson.lib.sports.datastructure.IndexedSnapshot;
import jayeson.lib.sports.datastructure.OutgoingImpl;
import jayeson.lib.sports.dispatch.EPDispatcherException;
import jayeson.lib.sports.dispatch.EPGCache;
import jayeson.lib.sports.dispatch.FullSnapshotWrapper;
import jayeson.lib.sports.dispatch.IEndPointDispatcher;
import jayeson.lib.sports.dispatch.IEndPointGroup;
import jayeson.lib.sports.dispatch.IEndPointGroupManager;
import jayeson.lib.sports.dispatch.IndicatorWrapper;
import jayeson.lib.sports.dispatch.RelevantDeltaWrapper;
import jayeson.lib.sports.dispatch.SwitchFilterSnapshotWrapper;
import jayeson.lib.sports.dispatch.relay.RelayEPG;
import jayeson.lib.sports.dispatch.transform.FilteringEPG;
import jayeson.lib.sports.receive.StreamCommandProcessor;
import jayeson.model.IDataFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class EndPointGroupManager
implements IEndPointGroupManager {
    private static Logger log = LoggerFactory.getLogger(EndPointGroupManager.class);
    private StreamCommandProcessor scp;
    private EPGCache cache;

    @Inject
    public EndPointGroupManager(StreamCommandProcessor scp, EPGCache cache) {
        this.scp = scp;
        this.cache = cache;
        this.cache.getFilterListenerImpl().setEPGM(this);
    }

    @Override
    public void switchFilter(IEndPointDispatcher epd, FilterRequest filterRequest) {
        this.switchFilter(Arrays.asList(epd), filterRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void switchFilter(Collection<IEndPointDispatcher> epds, FilterRequest filterRequest) {
        Map streamToDispatchers = epds.stream().collect(Collectors.groupingBy(IEndPointDispatcher::getStream, Collectors.mapping(Function.identity(), Collectors.toList())));
        for (Map.Entry entry : streamToDispatchers.entrySet()) {
            String stream = entry.getKey();
            List<IEndPointDispatcher> currEpds = entry.getValue();
            int requestId = filterRequest.getRequestId();
            IDataFilter newFilter = filterRequest.getFilterData() != null ? filterRequest.getFilterData().getFilter() : null;
            IEndPointDispatcher sampleEpd = (IEndPointDispatcher)currEpds.get(0);
            IEndPointGroup oldGrp = this.cache.getEPG(sampleEpd);
            if (oldGrp instanceof RelayEPG && newFilter == null) {
                log.info("Submiting a request to switch from null filter to null filter.");
                this.sendSwitchFilterFailMsg(oldGrp, stream, currEpds, requestId);
                continue;
            }
            if (oldGrp instanceof FilteringEPG && ((FilteringEPG)oldGrp).getFilter().equals(newFilter)) {
                IDataFilter oldFilter = ((FilteringEPG)oldGrp).getFilter();
                log.info("FilteringEPG submits a request to switch to same filter.{} {}", (Object)oldFilter, (Object)newFilter);
                this.sendSwitchFilterFailMsg(oldGrp, stream, currEpds, requestId);
                continue;
            }
            IEndPointGroup newGrp = null;
            for (IEndPointDispatcher iEndPointDispatcher : currEpds) {
                if (iEndPointDispatcher.isSwitchingFilters()) {
                    log.error("Already switching filters.");
                    this.sendSwitchFilterFailMsg(oldGrp, stream, Arrays.asList(iEndPointDispatcher), requestId);
                    continue;
                }
                log.trace("newFilter for {}-{} \n{}", new Object[]{iEndPointDispatcher.getStream(), iEndPointDispatcher.id(), newFilter});
                if (newGrp == null) {
                    newGrp = this.cache.createEPG(newFilter, stream);
                }
                iEndPointDispatcher.setOldEPG(oldGrp);
                iEndPointDispatcher.setReceivingRelevantDeltaFromNewEPG(false);
                iEndPointDispatcher.setSwitchingFilters(true);
                iEndPointDispatcher.setDispatchedSwitchFilterDeltas(false);
                iEndPointDispatcher.switchInputQueueToIdleQueue();
                newGrp.addEPD(iEndPointDispatcher);
                iEndPointDispatcher.setNewEPG(newGrp);
            }
            if (newGrp == null) continue;
            FSRepo fsRepo = this.scp.getFSRepo(stream);
            try {
                fsRepo.freezeSnapshot(stream);
                for (IEndPointDispatcher epd2 : currEpds) {
                    newGrp.setEpdConnectedTime(epd2, System.currentTimeMillis());
                }
                this.pushSwitchFilterWrapper(oldGrp, newGrp, currEpds, stream, requestId);
                RelevantDeltaWrapper relevantDeltaWrapper = new RelevantDeltaWrapper(newGrp, stream, currEpds);
                newGrp.submitForProcess(relevantDeltaWrapper);
            }
            finally {
                fsRepo.unFreezeSnapshot(stream);
            }
        }
    }

    private void sendSwitchFilterFailMsg(IEndPointGroup epg, String stream, Collection<IEndPointDispatcher> epds, int requestId) {
        OutgoingImpl switchFilterFail = new OutgoingImpl((IMessageClass<?>)epg.getSportsFeedGrp().SWITCH_FILTER_FAIL, requestId);
        DataMessageWrapper switchFilterFailDataMessageWrapper = new DataMessageWrapper(switchFilterFail, switchFilterFail.msgType());
        IndicatorWrapper switchFilterFailWrapper = new IndicatorWrapper(switchFilterFailDataMessageWrapper, epg, stream, epds);
        epg.submitForProcess(switchFilterFailWrapper);
    }

    @Override
    public void registerEPD(IEndPointDispatcher epd, IDataFilter filter) {
        if (this.cache.getEPG(epd) != null) {
            throw new EPDispatcherException("EPD already exists in a group.Id: " + epd.id() + " Stream: " + epd.getStream());
        }
        IEndPointGroup epg = this.cache.createEPG(filter, epd.getStream());
        epg.addEPD(epd);
        epd.setNewEPG(epg);
        this.pushFullSnapshotWrapper(epg, epd);
    }

    @Override
    public void deregisterEPD(IEndPointDispatcher epd) {
        Collection<IEndPointGroup> grps = this.cache.getEPGs(epd);
        grps.forEach(grp -> {
            grp.removeEPD(epd);
            this.cache.destroyEPG((IEndPointGroup)grp);
        });
        epd.cleanup();
    }

    private void pushFullSnapshotWrapper(IEndPointGroup epg, IEndPointDispatcher epd) {
        String stream = epd.getStream();
        epd.isInitialized().thenRun(() -> {
            FSRepo fsRepo = this.scp.getFSRepo(stream);
            try {
                fsRepo.freezeSnapshot(stream);
                epg.setEpdConnectedTime(epd, System.currentTimeMillis());
                IndexedSnapshot rawSnapshot = fsRepo.getSnapshot(stream);
                FullSnapshotWrapper sw = new FullSnapshotWrapper(epg, stream, epd, rawSnapshot);
                epg.submitForProcess(sw);
                RelevantDeltaWrapper wrapper = new RelevantDeltaWrapper(epg, epd.getStream(), Arrays.asList(epd));
                epg.submitForProcess(wrapper);
            }
            finally {
                fsRepo.unFreezeSnapshot(stream);
            }
        });
    }

    private void pushSwitchFilterWrapper(IEndPointGroup oldGrp, IEndPointGroup newGrp, Collection<IEndPointDispatcher> epds, String stream, int requestId) {
        FSRepo fsRepo = this.scp.getFSRepo(stream);
        IndexedSnapshot rawSnapshot = fsRepo.getSnapshot(stream);
        IDataFilter oldDataFilter = null;
        if (oldGrp instanceof FilteringEPG) {
            oldDataFilter = oldGrp.getFilter();
        }
        SwitchFilterSnapshotWrapper sw = new SwitchFilterSnapshotWrapper(oldGrp, newGrp, stream, epds, oldDataFilter, rawSnapshot, this.cache, requestId);
        oldGrp.submitForProcess(sw);
    }

    public EPGCache getCache() {
        return this.cache;
    }
}

